/*
 * Decompiled with CFR 0.152.
 */
package sing;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import sing.MaterialHeadListener;
import sing.MaterialRefreshLayout;
import sing.MaterialUtil;
import sing.SunFaceView;
import sing.SunLineView;

public class SunLayout
extends FrameLayout
implements MaterialHeadListener {
    private static final String Tag = SunLayout.class.getSimpleName();
    protected static final int DEFAULT_SUN_RADIUS = 12;
    private static final int DEFAULT_SUN_COLOR = -65536;
    private static final int DEFAULT_SUN_EYES_SIZE = 2;
    private static final int DEFAULT_LINE_HEIGHT = 3;
    private static final int DEFAULT_LINE_WIDTH = 1;
    private static final int DEFAULT_LINE_LEVEL = 30;
    private static final int DEFAULT_MOUTH_WIDTH = 3;
    private static final int DEFAULT_LINE_COLOR = -65536;
    protected SunFaceView mSunView;
    protected SunLineView mLineView;
    private int mSunRadius;
    private int mSunColor;
    private int mEyesSize;
    private int mLineLevel;
    private int mMouthStro;
    private int mLineColor;
    private int mLineWidth;
    private int mLineHeight;
    private ObjectAnimator mAnimator;

    public SunLayout(Context context) {
        this(context, null);
    }

    public SunLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SunLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mSunRadius = 12;
        this.mSunColor = -65536;
        this.mEyesSize = 2;
        this.mLineColor = -65536;
        this.mLineHeight = 3;
        this.mLineWidth = 1;
        this.mLineLevel = 30;
        this.mMouthStro = 3;
        Context context = this.getContext();
        this.mSunView = new SunFaceView(context);
        this.mSunView.setSunRadius(this.mSunRadius);
        this.mSunView.setSunColor(this.mSunColor);
        this.mSunView.setEyesSize(this.mEyesSize);
        this.mSunView.setMouthStro(this.mMouthStro);
        this.addView(this.mSunView);
        this.mLineView = new SunLineView(context);
        this.mLineView.setSunRadius(this.mSunRadius);
        this.mLineView.setLineLevel(this.mLineLevel);
        this.mLineView.setLineColor(this.mLineColor);
        this.mLineView.setLineHeight(this.mLineHeight);
        this.mLineView.setLineWidth(this.mLineWidth);
        this.addView(this.mLineView);
        this.startSunLineAnim(this.mLineView);
    }

    public void setSunRadius(int sunRadius) {
        this.mSunRadius = sunRadius;
        this.mSunView.setSunRadius(this.mSunRadius);
        this.mLineView.setSunRadius(this.mSunRadius);
    }

    public void setSunColor(int sunColor) {
        this.mSunColor = sunColor;
        this.mSunView.setSunColor(this.mSunColor);
    }

    public void setEyesSize(int eyesSize) {
        this.mEyesSize = eyesSize;
        this.mSunView.setEyesSize(this.mEyesSize);
    }

    public void setLineLevel(int level) {
        this.mLineLevel = level;
        this.mLineView.setLineLevel(this.mLineLevel);
    }

    public void setLineColor(int lineColor) {
        this.mLineColor = lineColor;
        this.mLineView.setLineColor(this.mLineColor);
    }

    public void setLineWidth(int lineWidth) {
        this.mLineWidth = lineWidth;
        this.mLineView.setLineWidth(this.mLineWidth);
    }

    public void setLineHeight(int lineHeight) {
        this.mLineHeight = lineHeight;
        this.mLineView.setLineHeight(this.mLineHeight);
    }

    public void setMouthStro(int mouthStro) {
        this.mMouthStro = mouthStro;
        this.mSunView.setMouthStro(this.mMouthStro);
    }

    public void startSunLineAnim(View v) {
        if (this.mAnimator == null) {
            this.mAnimator = ObjectAnimator.ofFloat((Object)v, (String)"rotation", (float[])new float[]{0.0f, 720.0f});
            this.mAnimator.setDuration(7000L);
            this.mAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.mAnimator.setRepeatCount(-1);
        }
        if (!this.mAnimator.isRunning()) {
            this.mAnimator.start();
        }
    }

    public void cancelSunLineAnim() {
        if (this.mAnimator != null) {
            this.mAnimator.cancel();
        }
    }

    @Override
    public void onComlete(MaterialRefreshLayout materialRefreshLayout) {
        this.cancelSunLineAnim();
        ViewCompat.setScaleX((View)this, (float)0.0f);
        ViewCompat.setScaleY((View)this, (float)0.0f);
    }

    @Override
    public void onBegin(MaterialRefreshLayout materialRefreshLayout) {
        ViewCompat.setScaleX((View)this, (float)0.001f);
        ViewCompat.setScaleY((View)this, (float)0.001f);
    }

    @Override
    public void onPull(MaterialRefreshLayout materialRefreshLayout, float fraction) {
        float a = MaterialUtil.limitValue(1.0f, fraction);
        if ((double)a >= 0.7) {
            this.mLineView.setVisibility(0);
        } else {
            this.mLineView.setVisibility(8);
        }
        this.mSunView.setPerView(this.mSunRadius, a);
        ViewCompat.setScaleX((View)this, (float)a);
        ViewCompat.setScaleY((View)this, (float)a);
        ViewCompat.setAlpha((View)this, (float)a);
    }

    @Override
    public void onRelease(MaterialRefreshLayout materialRefreshLayout, float fraction) {
    }

    @Override
    public void onRefreshing(MaterialRefreshLayout materialRefreshLayout) {
        this.startSunLineAnim(this.mLineView);
    }
}

