/*
 * Decompiled with CFR 0.152.
 */
package sing;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;

public class SunFaceView
extends View {
    private static final String Tag = SunFaceView.class.getSimpleName();
    private static final int DEFAULT_SUN_RADIUS = 12;
    private static final int DEFAULT_EYES_RADIUS = 2;
    private int mHeight;
    private int mWidth;
    private Paint mCirclePaint;
    private int mSunRadius;
    private int mEyesRadius = 2;
    private Rect debugRect;
    private RectF mouthRect;
    private int mSunColor;
    private boolean isDrawFace = true;
    private int mouthStro = 3;

    public SunFaceView(Context context) {
        this(context, null);
    }

    public SunFaceView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SunFaceView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        Log.i((String)Tag, (String)"init");
        this.mSunRadius = this.changeDp(12);
        this.mEyesRadius = this.changeDp(2);
        this.mCirclePaint = new Paint(1);
        this.mCirclePaint.setColor(-65536);
        this.mCirclePaint.setStyle(Paint.Style.FILL);
        this.debugRect = new Rect();
        this.mouthRect = new RectF();
    }

    public void setSunRadius(int sunRadius) {
        this.mSunRadius = this.changeDp(sunRadius);
        this.invalidate();
    }

    public void setEyesSize(int eyesSize) {
        this.mEyesRadius = this.changeDp(eyesSize);
        this.invalidate();
    }

    public void setMouthStro(int mouthStro) {
        this.mouthStro = mouthStro;
        this.invalidate();
    }

    public void setPerView(int sunRadius, float per) {
        sunRadius = this.changeDp(sunRadius);
        this.isDrawFace = (double)per >= 0.8;
        per = Math.min(per, 1.0f);
        float tempRadius = (float)sunRadius * per;
        this.mSunRadius = (int)tempRadius;
        this.mCirclePaint.setAlpha((int)per * 255);
        this.invalidate();
    }

    public void setSunColor(int sunColor) {
        this.mSunColor = sunColor;
        this.invalidate();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        Log.i((String)Tag, (String)("w---->" + w + "  -------  h----->" + h));
        this.mWidth = w;
        this.mHeight = h;
        this.debugRect.left = this.mWidth / 2 - this.mSunRadius;
        this.debugRect.right = this.mWidth / 2 + this.mSunRadius;
        this.debugRect.top = this.mHeight / 2 - this.mSunRadius;
        this.debugRect.bottom = this.mHeight / 2 + this.mSunRadius;
        this.mouthRect.left = this.mWidth / 2 - this.mSunRadius / 2;
        this.mouthRect.right = this.mWidth / 2 + this.mSunRadius / 2;
        this.mouthRect.top = this.mHeight / 2 - this.mSunRadius / 2;
        this.mouthRect.bottom = this.mHeight / 2 + this.mSunRadius / 2;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Log.i((String)Tag, (String)"onMeasure");
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = widthMode == 0x40000000 ? widthSize : this.mSunRadius * 2 + this.getPaddingRight() + this.getPaddingLeft();
        int height = heightMode == 0x40000000 ? heightSize : this.mSunRadius * 2 + this.getPaddingTop() + this.getPaddingBottom();
        this.setMeasuredDimension(width, height);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawCircle(canvas);
        this.mCirclePaint.setStyle(Paint.Style.STROKE);
    }

    private void drawCircle(Canvas canvas) {
        this.mCirclePaint.setColor(this.mSunColor);
        this.mCirclePaint.setStyle(Paint.Style.FILL);
        canvas.drawCircle((float)(this.mWidth / 2), (float)(this.mHeight / 2), (float)this.mSunRadius, this.mCirclePaint);
        this.mCirclePaint.setColor(-1);
        if (this.isDrawFace) {
            canvas.save();
            canvas.drawCircle((float)(this.mWidth / 2 - this.mSunRadius / 2 + this.mEyesRadius), (float)(this.mHeight / 2 - this.mSunRadius / 2 + this.mEyesRadius), (float)this.mEyesRadius, this.mCirclePaint);
            canvas.drawCircle((float)(this.mWidth / 2 + this.mSunRadius / 2 - this.mEyesRadius), (float)(this.mHeight / 2 - this.mSunRadius / 2 + this.mEyesRadius), (float)this.mEyesRadius, this.mCirclePaint);
            this.mCirclePaint.setStyle(Paint.Style.STROKE);
            this.mCirclePaint.setStrokeWidth((float)this.mouthStro);
            canvas.drawArc(this.mouthRect, 20.0f, 140.0f, false, this.mCirclePaint);
            canvas.restore();
        }
    }

    public int changeDp(int value) {
        return (int)TypedValue.applyDimension((int)1, (float)value, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }
}

