/*
 * Decompiled with CFR 0.152.
 */
package sing;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.animation.BounceInterpolator;
import android.view.animation.DecelerateInterpolator;
import sing.MaterialHeadListener;
import sing.MaterialRefreshLayout;
import sing.MaterialUtil;

public class MaterialWaveView
extends View
implements MaterialHeadListener {
    private int waveHeight;
    private int headHeight;
    public static int DefaulWaveHeight;
    public static int DefaulHeadHeight;
    private Path path;
    private Paint paint;
    private int color;

    public MaterialWaveView(Context context) {
        this(context, null, 0);
    }

    public MaterialWaveView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaterialWaveView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setWillNotDraw(false);
        this.path = new Path();
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
        this.invalidate();
    }

    public int getHeadHeight() {
        return this.headHeight;
    }

    public void setHeadHeight(int headHeight) {
        this.headHeight = headHeight;
    }

    public int getWaveHeight() {
        return this.waveHeight;
    }

    public void setWaveHeight(int waveHeight) {
        this.waveHeight = waveHeight;
    }

    public int getDefaulWaveHeight() {
        return DefaulWaveHeight;
    }

    public void setDefaulWaveHeight(int defaulWaveHeight) {
        DefaulWaveHeight = defaulWaveHeight;
    }

    public int getDefaulHeadHeight() {
        return DefaulHeadHeight;
    }

    public void setDefaulHeadHeight(int defaulHeadHeight) {
        DefaulHeadHeight = defaulHeadHeight;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.path.reset();
        this.paint.setColor(this.color);
        this.path.lineTo(0.0f, (float)this.headHeight);
        this.path.quadTo((float)(this.getMeasuredWidth() / 2), (float)(this.headHeight + this.waveHeight), (float)this.getMeasuredWidth(), (float)this.headHeight);
        this.path.lineTo((float)this.getMeasuredWidth(), 0.0f);
        canvas.drawPath(this.path, this.paint);
    }

    @Override
    public void onComlete(MaterialRefreshLayout br) {
        this.waveHeight = 0;
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.headHeight, 0});
        animator.setDuration(200L);
        animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animator.start();
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int value = (Integer)animation.getAnimatedValue();
                MaterialWaveView.this.headHeight = value;
                MaterialWaveView.this.invalidate();
            }
        });
    }

    @Override
    public void onBegin(MaterialRefreshLayout br) {
    }

    @Override
    public void onPull(MaterialRefreshLayout br, float fraction) {
        this.setHeadHeight((int)((float)MaterialUtil.dip2px(this.getContext(), DefaulHeadHeight) * MaterialUtil.limitValue(1.0f, fraction)));
        this.setWaveHeight((int)((float)MaterialUtil.dip2px(this.getContext(), DefaulWaveHeight) * Math.max(0.0f, fraction - 1.0f)));
        this.invalidate();
    }

    @Override
    public void onRelease(MaterialRefreshLayout br, float fraction) {
    }

    @Override
    public void onRefreshing(MaterialRefreshLayout br) {
        this.setHeadHeight(MaterialUtil.dip2px(this.getContext(), DefaulHeadHeight));
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.getWaveHeight(), 0});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Log.i((String)"anim", (String)("value--->" + (Integer)animation.getAnimatedValue()));
                MaterialWaveView.this.setWaveHeight((Integer)animation.getAnimatedValue());
                MaterialWaveView.this.invalidate();
            }
        });
        animator.setInterpolator((TimeInterpolator)new BounceInterpolator());
        animator.setDuration(200L);
        animator.start();
    }
}

