/*
 * Decompiled with CFR 0.152.
 */
package sing;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.ViewPropertyAnimatorUpdateListener;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import sing.MaterialFooterView;
import sing.MaterialHeaderView;
import sing.MaterialRefreshListener;
import sing.MaterialUtil;
import sing.MaterialWaveView;
import sing.SunLayout;
import sing.refreshlayout.R;

public class MaterialRefreshLayout
extends FrameLayout {
    public static final String Tag = MaterialRefreshLayout.class.getSimpleName();
    private static final int DEFAULT_WAVE_HEIGHT = 140;
    private static final int HIGHER_WAVE_HEIGHT = 180;
    private static final int DEFAULT_HEAD_HEIGHT = 70;
    private static final int hIGHER_HEAD_HEIGHT = 100;
    private static final int DEFAULT_PROGRESS_SIZE = 50;
    private static final int BIG_PROGRESS_SIZE = 60;
    private static final int PROGRESS_STOKE_WIDTH = 3;
    private MaterialHeaderView mMaterialHeaderView;
    private MaterialFooterView mMaterialFooterView;
    private SunLayout mSunLayout;
    private boolean isOverlay;
    private int waveType;
    private int waveColor;
    protected float mWaveHeight;
    protected float mHeadHeight;
    private View mChildView;
    protected boolean isRefreshing;
    private float mTouchY;
    private float mCurrentY;
    private DecelerateInterpolator decelerateInterpolator;
    private float headHeight;
    private float waveHeight;
    private int[] colorSchemeColors;
    private int colorsId;
    private int progressTextColor;
    private int progressValue;
    private int progressMax;
    private boolean showArrow = true;
    private int textType;
    private MaterialRefreshListener refreshListener;
    private boolean showProgressBg;
    private int progressBg;
    private boolean isShowWave;
    private int progressSizeType;
    private int progressSize = 0;
    private boolean isLoadMoreing;
    private boolean isLoadMore;
    private boolean isSunStyle = false;

    public MaterialRefreshLayout(Context context) {
        this(context, null, 0);
    }

    public MaterialRefreshLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaterialRefreshLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defstyleAttr) {
        if (this.isInEditMode()) {
            return;
        }
        if (this.getChildCount() > 1) {
            throw new RuntimeException("can only have one child widget");
        }
        this.decelerateInterpolator = new DecelerateInterpolator(10.0f);
        TypedArray t = context.obtainStyledAttributes(attrs, R.styleable.MaterialRefreshLayout, defstyleAttr, 0);
        this.isOverlay = t.getBoolean(R.styleable.MaterialRefreshLayout_overlay, false);
        this.waveType = t.getInt(R.styleable.MaterialRefreshLayout_wave_height_type, 0);
        if (this.waveType == 0) {
            this.headHeight = 70.0f;
            this.waveHeight = 140.0f;
            MaterialWaveView.DefaulHeadHeight = 70;
            MaterialWaveView.DefaulWaveHeight = 140;
        } else {
            this.headHeight = 100.0f;
            this.waveHeight = 180.0f;
            MaterialWaveView.DefaulHeadHeight = 100;
            MaterialWaveView.DefaulWaveHeight = 180;
        }
        this.waveColor = t.getColor(R.styleable.MaterialRefreshLayout_wave_color, -1);
        this.isShowWave = t.getBoolean(R.styleable.MaterialRefreshLayout_wave_show, true);
        this.colorsId = t.getResourceId(R.styleable.MaterialRefreshLayout_progress_colors, R.array.material_colors);
        this.colorSchemeColors = context.getResources().getIntArray(this.colorsId);
        this.showArrow = t.getBoolean(R.styleable.MaterialRefreshLayout_progress_show_arrow, true);
        this.textType = t.getInt(R.styleable.MaterialRefreshLayout_progress_text_visibility, 1);
        this.progressTextColor = t.getColor(R.styleable.MaterialRefreshLayout_progress_text_color, -16777216);
        this.progressValue = t.getInteger(R.styleable.MaterialRefreshLayout_progress_value, 0);
        this.progressMax = t.getInteger(R.styleable.MaterialRefreshLayout_progress_max_value, 100);
        this.showProgressBg = t.getBoolean(R.styleable.MaterialRefreshLayout_progress_show_circle_backgroud, true);
        this.progressBg = t.getColor(R.styleable.MaterialRefreshLayout_progress_backgroud_color, -328966);
        this.progressSizeType = t.getInt(R.styleable.MaterialRefreshLayout_progress_size_type, 0);
        this.progressSize = this.progressSizeType == 0 ? 50 : 60;
        this.isLoadMore = t.getBoolean(R.styleable.MaterialRefreshLayout_isLoadMore, false);
        t.recycle();
    }

    protected void onAttachedToWindow() {
        FrameLayout.LayoutParams layoutParams;
        super.onAttachedToWindow();
        Log.i((String)Tag, (String)"onAttachedToWindow");
        Context context = this.getContext();
        this.mChildView = this.getChildAt(0);
        if (this.mChildView == null) {
            return;
        }
        this.setWaveHeight(MaterialUtil.dip2px(context, this.waveHeight));
        this.setHeaderHeight(MaterialUtil.dip2px(context, this.headHeight));
        if (this.isSunStyle) {
            this.mSunLayout = new SunLayout(context);
            layoutParams = new FrameLayout.LayoutParams(-1, MaterialUtil.dip2px(context, 100.0f));
            layoutParams.gravity = 48;
            this.mSunLayout.setVisibility(8);
            this.setHeaderView((View)this.mSunLayout);
        } else {
            this.mMaterialHeaderView = new MaterialHeaderView(context);
            layoutParams = new FrameLayout.LayoutParams(-1, MaterialUtil.dip2px(context, 100.0f));
            layoutParams.gravity = 48;
            this.mMaterialHeaderView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mMaterialHeaderView.setWaveColor(this.isShowWave ? this.waveColor : 0);
            this.mMaterialHeaderView.showProgressArrow(this.showArrow);
            this.mMaterialHeaderView.setProgressSize(this.progressSize);
            this.mMaterialHeaderView.setProgressColors(this.colorSchemeColors);
            this.mMaterialHeaderView.setProgressStokeWidth(3);
            this.mMaterialHeaderView.setTextType(this.textType);
            this.mMaterialHeaderView.setProgressTextColor(this.progressTextColor);
            this.mMaterialHeaderView.setProgressValue(this.progressValue);
            this.mMaterialHeaderView.setProgressValueMax(this.progressMax);
            this.mMaterialHeaderView.setIsProgressBg(this.showProgressBg);
            this.mMaterialHeaderView.setProgressBg(this.progressBg);
            this.mMaterialHeaderView.setVisibility(8);
            this.setHeaderView((View)this.mMaterialHeaderView);
        }
        this.mMaterialFooterView = new MaterialFooterView(context);
        FrameLayout.LayoutParams layoutParams2 = new FrameLayout.LayoutParams(-1, MaterialUtil.dip2px(context, 100.0f));
        layoutParams2.gravity = 80;
        this.mMaterialFooterView.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        this.mMaterialFooterView.showProgressArrow(this.showArrow);
        this.mMaterialFooterView.setProgressSize(this.progressSize);
        this.mMaterialFooterView.setProgressColors(this.colorSchemeColors);
        this.mMaterialFooterView.setProgressStokeWidth(3);
        this.mMaterialFooterView.setTextType(this.textType);
        this.mMaterialFooterView.setProgressValue(this.progressValue);
        this.mMaterialFooterView.setProgressValueMax(this.progressMax);
        this.mMaterialFooterView.setIsProgressBg(this.showProgressBg);
        this.mMaterialFooterView.setProgressBg(this.progressBg);
        this.mMaterialFooterView.setVisibility(8);
        this.setFooderView((View)this.mMaterialFooterView);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.isRefreshing) {
            return true;
        }
        switch (ev.getAction()) {
            case 0: {
                this.mCurrentY = this.mTouchY = ev.getY();
                break;
            }
            case 2: {
                float currentY = ev.getY();
                float dy = currentY - this.mTouchY;
                if (dy > 0.0f && !this.canChildScrollUp()) {
                    if (this.mMaterialHeaderView != null) {
                        this.mMaterialHeaderView.setVisibility(0);
                        this.mMaterialHeaderView.onBegin(this);
                    } else if (this.mSunLayout != null) {
                        this.mSunLayout.setVisibility(0);
                        this.mSunLayout.onBegin(this);
                    }
                    return true;
                }
                if (!(dy < 0.0f) || this.canChildScrollDown() || !this.isLoadMore) break;
                if (this.mMaterialFooterView != null && !this.isLoadMoreing) {
                    this.soveLoadMoreLogic();
                }
                return super.onInterceptTouchEvent(ev);
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    private void soveLoadMoreLogic() {
        this.isLoadMoreing = true;
        this.mMaterialFooterView.setVisibility(0);
        this.mMaterialFooterView.onBegin(this);
        this.mMaterialFooterView.onRefreshing(this);
        if (this.refreshListener != null) {
            this.refreshListener.onRefreshLoadMore(this);
        }
    }

    public boolean onTouchEvent(MotionEvent e) {
        if (this.isRefreshing) {
            return super.onTouchEvent(e);
        }
        switch (e.getAction()) {
            case 2: {
                this.mCurrentY = e.getY();
                float dy = this.mCurrentY - this.mTouchY;
                dy = Math.min(this.mWaveHeight * 2.0f, dy);
                dy = Math.max(0.0f, dy);
                if (this.mChildView != null) {
                    float offsetY = this.decelerateInterpolator.getInterpolation(dy / this.mWaveHeight / 2.0f) * dy / 2.0f;
                    float fraction = offsetY / this.mHeadHeight;
                    if (this.mMaterialHeaderView != null) {
                        this.mMaterialHeaderView.getLayoutParams().height = (int)offsetY;
                        this.mMaterialHeaderView.requestLayout();
                        this.mMaterialHeaderView.onPull(this, fraction);
                    } else if (this.mSunLayout != null) {
                        this.mSunLayout.getLayoutParams().height = (int)offsetY;
                        this.mSunLayout.requestLayout();
                        this.mSunLayout.onPull(this, fraction);
                    }
                    if (!this.isOverlay) {
                        ViewCompat.setTranslationY((View)this.mChildView, (float)offsetY);
                    }
                }
                return true;
            }
            case 1: 
            case 3: {
                if (this.mChildView != null) {
                    if (this.mMaterialHeaderView != null) {
                        if (this.isOverlay) {
                            if ((float)this.mMaterialHeaderView.getLayoutParams().height > this.mHeadHeight) {
                                this.updateListener();
                                this.mMaterialHeaderView.getLayoutParams().height = (int)this.mHeadHeight;
                                this.mMaterialHeaderView.requestLayout();
                            } else {
                                this.mMaterialHeaderView.getLayoutParams().height = 0;
                                this.mMaterialHeaderView.requestLayout();
                            }
                        } else if (ViewCompat.getTranslationY((View)this.mChildView) >= this.mHeadHeight) {
                            this.createAnimatorTranslationY(this.mChildView, this.mHeadHeight, this.mMaterialHeaderView);
                            this.updateListener();
                        } else {
                            this.createAnimatorTranslationY(this.mChildView, 0.0f, this.mMaterialHeaderView);
                        }
                    } else if (this.mSunLayout != null) {
                        if (this.isOverlay) {
                            if ((float)this.mSunLayout.getLayoutParams().height > this.mHeadHeight) {
                                this.updateListener();
                                this.mSunLayout.getLayoutParams().height = (int)this.mHeadHeight;
                                this.mSunLayout.requestLayout();
                            } else {
                                this.mSunLayout.getLayoutParams().height = 0;
                                this.mSunLayout.requestLayout();
                            }
                        } else if (ViewCompat.getTranslationY((View)this.mChildView) >= this.mHeadHeight) {
                            this.createAnimatorTranslationY(this.mChildView, this.mHeadHeight, this.mSunLayout);
                            this.updateListener();
                        } else {
                            this.createAnimatorTranslationY(this.mChildView, 0.0f, this.mSunLayout);
                        }
                    }
                }
                return true;
            }
        }
        return super.onTouchEvent(e);
    }

    public void setSunStyle(boolean isSunStyle) {
        this.isSunStyle = isSunStyle;
    }

    public void autoRefresh() {
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!MaterialRefreshLayout.this.isRefreshing) {
                    if (MaterialRefreshLayout.this.mMaterialHeaderView != null) {
                        MaterialRefreshLayout.this.mMaterialHeaderView.setVisibility(0);
                        if (MaterialRefreshLayout.this.isOverlay) {
                            ((MaterialRefreshLayout)MaterialRefreshLayout.this).mMaterialHeaderView.getLayoutParams().height = (int)MaterialRefreshLayout.this.mHeadHeight;
                            MaterialRefreshLayout.this.mMaterialHeaderView.requestLayout();
                        } else {
                            MaterialRefreshLayout.this.createAnimatorTranslationY(MaterialRefreshLayout.this.mChildView, MaterialRefreshLayout.this.mHeadHeight, MaterialRefreshLayout.this.mMaterialHeaderView);
                        }
                    } else if (MaterialRefreshLayout.this.mSunLayout != null) {
                        MaterialRefreshLayout.this.mSunLayout.setVisibility(0);
                        if (MaterialRefreshLayout.this.isOverlay) {
                            ((MaterialRefreshLayout)MaterialRefreshLayout.this).mSunLayout.getLayoutParams().height = (int)MaterialRefreshLayout.this.mHeadHeight;
                            MaterialRefreshLayout.this.mSunLayout.requestLayout();
                        } else {
                            MaterialRefreshLayout.this.createAnimatorTranslationY(MaterialRefreshLayout.this.mChildView, MaterialRefreshLayout.this.mHeadHeight, MaterialRefreshLayout.this.mSunLayout);
                        }
                    }
                    MaterialRefreshLayout.this.updateListener();
                }
            }
        }, 50L);
    }

    public void autoRefreshLoadMore() {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (!MaterialRefreshLayout.this.isLoadMore) {
                    throw new RuntimeException("you must setLoadMore ture");
                }
                MaterialRefreshLayout.this.soveLoadMoreLogic();
            }
        });
    }

    public void updateListener() {
        this.isRefreshing = true;
        if (this.mMaterialHeaderView != null) {
            this.mMaterialHeaderView.onRefreshing(this);
        } else if (this.mSunLayout != null) {
            this.mSunLayout.onRefreshing(this);
        }
        if (this.refreshListener != null) {
            this.refreshListener.onRefresh(this);
        }
    }

    public void setLoadMore(boolean isLoadMore) {
        this.isLoadMore = isLoadMore;
    }

    public void setProgressColors(int[] colors) {
        this.colorSchemeColors = colors;
    }

    public void setShowArrow(boolean showArrow) {
        this.showArrow = showArrow;
    }

    public void setShowProgressBg(boolean showProgressBg) {
        this.showProgressBg = showProgressBg;
    }

    public void setWaveColor(int waveColor) {
        this.waveColor = waveColor;
    }

    public void setWaveShow(boolean isShowWave) {
        this.isShowWave = isShowWave;
    }

    public void setIsOverLay(boolean isOverLay) {
        this.isOverlay = isOverLay;
    }

    public void createAnimatorTranslationY(final View v, float h, final FrameLayout fl) {
        ViewPropertyAnimatorCompat viewPropertyAnimatorCompat = ViewCompat.animate((View)v);
        viewPropertyAnimatorCompat.setDuration(250L);
        viewPropertyAnimatorCompat.setInterpolator((Interpolator)new DecelerateInterpolator());
        viewPropertyAnimatorCompat.translationY(h);
        viewPropertyAnimatorCompat.start();
        viewPropertyAnimatorCompat.setUpdateListener(new ViewPropertyAnimatorUpdateListener(){

            public void onAnimationUpdate(View view) {
                float height = ViewCompat.getTranslationY((View)v);
                fl.getLayoutParams().height = (int)height;
                fl.requestLayout();
            }
        });
    }

    public boolean canChildScrollUp() {
        if (this.mChildView == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 14) {
            if (this.mChildView instanceof AbsListView) {
                AbsListView absListView = (AbsListView)this.mChildView;
                return absListView.getChildCount() > 0 && (absListView.getFirstVisiblePosition() > 0 || absListView.getChildAt(0).getTop() < absListView.getPaddingTop());
            }
            return ViewCompat.canScrollVertically((View)this.mChildView, (int)-1) || this.mChildView.getScrollY() > 0;
        }
        return ViewCompat.canScrollVertically((View)this.mChildView, (int)-1);
    }

    public boolean canChildScrollDown() {
        if (this.mChildView == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 14) {
            if (this.mChildView instanceof AbsListView) {
                AbsListView absListView = (AbsListView)this.mChildView;
                if (absListView.getChildCount() > 0) {
                    int lastChildBottom = absListView.getChildAt(absListView.getChildCount() - 1).getBottom();
                    return absListView.getLastVisiblePosition() == ((ListAdapter)absListView.getAdapter()).getCount() - 1 && lastChildBottom <= absListView.getMeasuredHeight();
                }
                return false;
            }
            return ViewCompat.canScrollVertically((View)this.mChildView, (int)1) || this.mChildView.getScrollY() > 0;
        }
        return ViewCompat.canScrollVertically((View)this.mChildView, (int)1);
    }

    public void setWaveHigher() {
        this.headHeight = 100.0f;
        this.waveHeight = 180.0f;
        MaterialWaveView.DefaulHeadHeight = 100;
        MaterialWaveView.DefaulWaveHeight = 180;
    }

    public void finishRefreshing() {
        if (this.mChildView != null) {
            ViewPropertyAnimatorCompat viewPropertyAnimatorCompat = ViewCompat.animate((View)this.mChildView);
            viewPropertyAnimatorCompat.setDuration(200L);
            viewPropertyAnimatorCompat.y(ViewCompat.getTranslationY((View)this.mChildView));
            viewPropertyAnimatorCompat.translationY(0.0f);
            viewPropertyAnimatorCompat.setInterpolator((Interpolator)new DecelerateInterpolator());
            viewPropertyAnimatorCompat.start();
            if (this.mMaterialHeaderView != null) {
                this.mMaterialHeaderView.onComlete(this);
            } else if (this.mSunLayout != null) {
                this.mSunLayout.onComlete(this);
            }
            if (this.refreshListener != null) {
                this.refreshListener.onfinish();
            }
        }
        this.isRefreshing = false;
        this.progressValue = 0;
    }

    public void finishRefresh() {
        this.post(new Runnable(){

            @Override
            public void run() {
                MaterialRefreshLayout.this.finishRefreshing();
            }
        });
    }

    public void finishRefreshLoadMore() {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (MaterialRefreshLayout.this.mMaterialFooterView != null && MaterialRefreshLayout.this.isLoadMoreing) {
                    MaterialRefreshLayout.this.isLoadMoreing = false;
                    MaterialRefreshLayout.this.mMaterialFooterView.onComlete(MaterialRefreshLayout.this);
                }
            }
        });
    }

    private void setHeaderView(View headerView) {
        this.addView(headerView);
    }

    public void setHeader(View headerView) {
        this.setHeaderView(headerView);
    }

    public void setFooderView(View fooderView) {
        this.addView(fooderView);
    }

    public void setWaveHeight(float waveHeight) {
        this.mWaveHeight = waveHeight;
    }

    public void setHeaderHeight(float headHeight) {
        this.mHeadHeight = headHeight;
    }

    public void setMaterialRefreshListener(MaterialRefreshListener refreshListener) {
        this.refreshListener = refreshListener;
    }
}

