/*
 * Decompiled with CFR 0.152.
 */
package sing.refreshlayout.util;

import android.content.Context;
import android.os.Build;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.ScrollingView;
import android.support.v4.view.ViewPager;
import android.support.v4.widget.NestedScrollView;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.AbsListView;
import android.widget.ListView;
import android.widget.ScrollView;

public class SmartUtil {
    public static int getColor(@NonNull Context context, @ColorRes int colorId) {
        if (Build.VERSION.SDK_INT >= 23) {
            return context.getColor(colorId);
        }
        return context.getResources().getColor(colorId);
    }

    public static int measureViewHeight(View view) {
        ViewGroup.LayoutParams p = view.getLayoutParams();
        if (p == null) {
            p = new ViewGroup.LayoutParams(-1, -2);
        }
        int childWidthSpec = ViewGroup.getChildMeasureSpec((int)0, (int)0, (int)p.width);
        int childHeightSpec = p.height > 0 ? View.MeasureSpec.makeMeasureSpec((int)p.height, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view.measure(childWidthSpec, childHeightSpec);
        return view.getMeasuredHeight();
    }

    public static void scrollListBy(@NonNull AbsListView listView, int y) {
        if (Build.VERSION.SDK_INT >= 19) {
            listView.scrollListBy(y);
        } else if (listView instanceof ListView) {
            int firstPosition = listView.getFirstVisiblePosition();
            if (firstPosition == -1) {
                return;
            }
            AbsListView listGroup = listView;
            View firstView = listGroup.getChildAt(0);
            if (firstView == null) {
                return;
            }
            int newTop = firstView.getTop() - y;
            ((ListView)listView).setSelectionFromTop(firstPosition, newTop);
        } else {
            listView.smoothScrollBy(y, 0);
        }
    }

    public static boolean isScrollableView(View view) {
        return view instanceof AbsListView || view instanceof ScrollView || view instanceof ScrollingView || view instanceof WebView || view instanceof ViewPager || view instanceof NestedScrollingChild || view instanceof NestedScrollingParent;
    }

    public static void fling(View scrollableView, int velocity) {
        if (scrollableView instanceof ScrollView) {
            ((ScrollView)scrollableView).fling(velocity);
        } else if (scrollableView instanceof AbsListView) {
            if (Build.VERSION.SDK_INT >= 21) {
                ((AbsListView)scrollableView).fling(velocity);
            }
        } else if (scrollableView instanceof WebView) {
            ((WebView)scrollableView).flingScroll(0, velocity);
        } else if (scrollableView instanceof NestedScrollView) {
            ((NestedScrollView)scrollableView).fling(velocity);
        } else if (scrollableView instanceof RecyclerView) {
            ((RecyclerView)scrollableView).fling(0, velocity);
        }
    }
}

