/*
 * Decompiled with CFR 0.152.
 */
package sing.imagepicker.ui;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import java.io.File;
import java.util.ArrayList;
import sing.imagepicker.ImagePicker;
import sing.imagepicker.R;
import sing.imagepicker.bean.ImageItem;
import sing.imagepicker.ui.ImageBaseActivity;
import sing.imagepicker.view.CropImageView;

public class ImageCropActivity
extends ImageBaseActivity
implements View.OnClickListener,
CropImageView.OnBitmapSaveCompleteListener {
    private CropImageView mCropImageView;
    private Bitmap mBitmap;
    private boolean mIsSaveRectangle;
    private int mOutputX;
    private int mOutputY;
    private ArrayList<ImageItem> mImageItems;
    private ImagePicker imagePicker;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_image_crop);
        this.imagePicker = ImagePicker.getInstance();
        this.findViewById(R.id.btn_back).setOnClickListener((View.OnClickListener)this);
        Button btn_ok = (Button)this.findViewById(R.id.btn_ok);
        btn_ok.setText((CharSequence)this.getString(R.string.complete));
        btn_ok.setOnClickListener((View.OnClickListener)this);
        TextView tv_des = (TextView)this.findViewById(R.id.tv_des);
        tv_des.setText((CharSequence)this.getString(R.string.photo_crop));
        this.mCropImageView = (CropImageView)this.findViewById(R.id.cv_crop_image);
        this.mCropImageView.setOnBitmapSaveCompleteListener(this);
        this.mOutputX = this.imagePicker.getOutPutX();
        this.mOutputY = this.imagePicker.getOutPutY();
        this.mIsSaveRectangle = this.imagePicker.isSaveRectangle();
        this.mImageItems = this.imagePicker.getSelectedImages();
        String imagePath = this.mImageItems.get((int)0).path;
        this.mCropImageView.setFocusStyle(this.imagePicker.getStyle());
        this.mCropImageView.setFocusWidth(this.imagePicker.getFocusWidth());
        this.mCropImageView.setFocusHeight(this.imagePicker.getFocusHeight());
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        options.inSampleSize = this.calculateInSampleSize(options, displayMetrics.widthPixels, displayMetrics.heightPixels);
        options.inJustDecodeBounds = false;
        this.mBitmap = BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        this.mCropImageView.setImageBitmap(this.mBitmap);
    }

    public int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int width = options.outWidth;
        int height = options.outHeight;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            inSampleSize = width > height ? width / reqWidth : height / reqHeight;
        }
        return inSampleSize;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btn_back) {
            this.setResult(0);
            this.finish();
        } else if (id2 == R.id.btn_ok) {
            this.mCropImageView.saveBitmapToFile(this.imagePicker.getCropCacheFolder((Context)this), this.mOutputX, this.mOutputY, this.mIsSaveRectangle);
        }
    }

    @Override
    public void onBitmapSaveSuccess(File file) {
        this.mImageItems.remove(0);
        ImageItem imageItem = new ImageItem();
        imageItem.path = file.getAbsolutePath();
        this.mImageItems.add(imageItem);
        Intent intent = new Intent();
        intent.putExtra("extra_result_items", this.mImageItems);
        this.setResult(1004, intent);
        this.finish();
    }

    @Override
    public void onBitmapSaveError(File file) {
    }

    protected void onDestroy() {
        super.onDestroy();
        if (null != this.mBitmap && !this.mBitmap.isRecycled()) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
    }
}

