/*
 * Decompiled with CFR 0.152.
 */
package sing.imagepicker.adapter;

import android.app.Activity;
import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import java.util.ArrayList;
import sing.imagepicker.ImagePicker;
import sing.imagepicker.Utils;
import sing.imagepicker.bean.ImageItem;
import sing.photoview.PhotoView;
import sing.photoview.PhotoViewAttacher;

public class ImagePageAdapter
extends PagerAdapter {
    private int screenWidth;
    private int screenHeight;
    private ImagePicker imagePicker;
    private ArrayList<ImageItem> images = new ArrayList();
    private Activity mActivity;
    public PhotoViewClickListener listener;

    public ImagePageAdapter(Activity activity, ArrayList<ImageItem> images) {
        this.mActivity = activity;
        this.images = images;
        DisplayMetrics dm = Utils.getScreenPix(activity);
        this.screenWidth = dm.widthPixels;
        this.screenHeight = dm.heightPixels;
        this.imagePicker = ImagePicker.getInstance();
    }

    public void setData(ArrayList<ImageItem> images) {
        this.images = images;
    }

    public void setPhotoViewClickListener(PhotoViewClickListener listener) {
        this.listener = listener;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        PhotoView photoView = new PhotoView((Context)this.mActivity);
        ImageItem imageItem = this.images.get(position);
        this.imagePicker.getImageLoader().displayImage(this.mActivity, imageItem.path, (ImageView)photoView, this.screenWidth, this.screenHeight);
        photoView.setOnPhotoTapListener(new PhotoViewAttacher.OnPhotoTapListener(){

            public void onPhotoTap(View view, float x, float y) {
                if (ImagePageAdapter.this.listener != null) {
                    ImagePageAdapter.this.listener.OnPhotoTapListener(view, x, y);
                }
            }
        });
        container.addView((View)photoView);
        return photoView;
    }

    public int getCount() {
        return this.images.size();
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
    }

    public int getItemPosition(Object object) {
        return -2;
    }

    public static interface PhotoViewClickListener {
        public void OnPhotoTapListener(View var1, float var2, float var3);
    }
}

