/*
 * Decompiled with CFR 0.152.
 */
package sing.imagepicker.adapter;

import android.app.Activity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import sing.imagepicker.ImagePicker;
import sing.imagepicker.R;
import sing.imagepicker.Utils;
import sing.imagepicker.bean.ImageFolder;

public class ImageFolderAdapter
extends BaseAdapter {
    private ImagePicker imagePicker;
    private Activity mActivity;
    private LayoutInflater mInflater;
    private int mImageSize;
    private List<ImageFolder> imageFolders;
    private int lastSelected = 0;

    public ImageFolderAdapter(Activity activity, List<ImageFolder> folders) {
        this.mActivity = activity;
        this.imageFolders = folders != null && folders.size() > 0 ? folders : new ArrayList<ImageFolder>();
        this.imagePicker = ImagePicker.getInstance();
        this.mImageSize = Utils.getImageItemWidth(this.mActivity);
        this.mInflater = (LayoutInflater)activity.getSystemService("layout_inflater");
    }

    public void refreshData(List<ImageFolder> folders) {
        if (folders != null && folders.size() > 0) {
            this.imageFolders = folders;
        } else {
            this.imageFolders.clear();
        }
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.imageFolders.size();
    }

    public ImageFolder getItem(int position) {
        return this.imageFolders.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            convertView = this.mInflater.inflate(R.layout.adapter_folder_list_item, parent, false);
            holder = new ViewHolder(convertView);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        ImageFolder folder = this.getItem(position);
        holder.folderName.setText((CharSequence)folder.name);
        holder.imageCount.setText((CharSequence)this.mActivity.getString(R.string.folder_image_count, new Object[]{folder.images.size()}));
        this.imagePicker.getImageLoader().displayImage(this.mActivity, folder.cover.path, holder.cover, this.mImageSize, this.mImageSize);
        if (this.lastSelected == position) {
            holder.folderCheck.setVisibility(0);
        } else {
            holder.folderCheck.setVisibility(4);
        }
        return convertView;
    }

    public void setSelectIndex(int i) {
        if (this.lastSelected == i) {
            return;
        }
        this.lastSelected = i;
        this.notifyDataSetChanged();
    }

    public int getSelectIndex() {
        return this.lastSelected;
    }

    private class ViewHolder {
        ImageView cover;
        TextView folderName;
        TextView imageCount;
        ImageView folderCheck;

        public ViewHolder(View view) {
            this.cover = (ImageView)view.findViewById(R.id.iv_cover);
            this.folderName = (TextView)view.findViewById(R.id.tv_folder_name);
            this.imageCount = (TextView)view.findViewById(R.id.tv_image_count);
            this.folderCheck = (ImageView)view.findViewById(R.id.iv_folder_check);
            view.setTag((Object)this);
        }
    }
}

