/*
 * Decompiled with CFR 0.152.
 */
package sing.imagepicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import sing.imagepicker.Utils;
import sing.imagepicker.bean.ImageFolder;
import sing.imagepicker.bean.ImageItem;
import sing.imagepicker.loader.ImageLoader;
import sing.imagepicker.view.CropImageView;

public class ImagePicker {
    public static final String TAG = ImagePicker.class.getSimpleName();
    public static final int REQUEST_CODE_TAKE = 1001;
    public static final int REQUEST_CODE_CROP = 1002;
    public static final int REQUEST_CODE_PREVIEW = 1003;
    public static final int RESULT_CODE_ITEMS = 1004;
    public static final int RESULT_CODE_BACK = 1005;
    public static final String EXTRA_RESULT_ITEMS = "extra_result_items";
    public static final String EXTRA_SELECTED_IMAGE_POSITION = "selected_image_position";
    public static final String EXTRA_IMAGE_ITEMS = "extra_image_items";
    private boolean multiMode = true;
    private int selectLimit = 9;
    private boolean crop = true;
    private boolean showCamera = true;
    private boolean isSaveRectangle = false;
    private int outPutX = 800;
    private int outPutY = 800;
    private int focusWidth = 280;
    private int focusHeight = 280;
    private ImageLoader imageLoader;
    private CropImageView.Style style = CropImageView.Style.RECTANGLE;
    private File cropCacheFolder;
    private File takeImageFile;
    public Bitmap cropBitmap;
    private ArrayList<ImageItem> mSelectedImages = new ArrayList();
    private List<ImageFolder> mImageFolders;
    private int mCurrentImageFolderPosition = 0;
    private List<OnImageSelectedListener> mImageSelectedListeners;
    private static ImagePicker mInstance;

    private ImagePicker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImagePicker getInstance() {
        if (mInstance != null) return mInstance;
        Class<ImagePicker> clazz = ImagePicker.class;
        synchronized (ImagePicker.class) {
            if (mInstance != null) return mInstance;
            mInstance = new ImagePicker();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public boolean isMultiMode() {
        return this.multiMode;
    }

    public void setMultiMode(boolean multiMode) {
        this.multiMode = multiMode;
    }

    public int getSelectLimit() {
        return this.selectLimit;
    }

    public void setSelectLimit(int selectLimit) {
        this.selectLimit = selectLimit;
    }

    public boolean isCrop() {
        return this.crop;
    }

    public void setCrop(boolean crop) {
        this.crop = crop;
    }

    public boolean isShowCamera() {
        return this.showCamera;
    }

    public void setShowCamera(boolean showCamera) {
        this.showCamera = showCamera;
    }

    public boolean isSaveRectangle() {
        return this.isSaveRectangle;
    }

    public void setSaveRectangle(boolean isSaveRectangle) {
        this.isSaveRectangle = isSaveRectangle;
    }

    public int getOutPutX() {
        return this.outPutX;
    }

    public void setOutPutX(int outPutX) {
        this.outPutX = outPutX;
    }

    public int getOutPutY() {
        return this.outPutY;
    }

    public void setOutPutY(int outPutY) {
        this.outPutY = outPutY;
    }

    public int getFocusWidth() {
        return this.focusWidth;
    }

    public void setFocusWidth(int focusWidth) {
        this.focusWidth = focusWidth;
    }

    public int getFocusHeight() {
        return this.focusHeight;
    }

    public void setFocusHeight(int focusHeight) {
        this.focusHeight = focusHeight;
    }

    public File getTakeImageFile() {
        return this.takeImageFile;
    }

    public File getCropCacheFolder(Context context) {
        if (this.cropCacheFolder == null) {
            this.cropCacheFolder = new File(context.getCacheDir() + "/ImagePicker/cropTemp/");
        }
        return this.cropCacheFolder;
    }

    public void setCropCacheFolder(File cropCacheFolder) {
        this.cropCacheFolder = cropCacheFolder;
    }

    public ImageLoader getImageLoader() {
        return this.imageLoader;
    }

    public void setImageLoader(ImageLoader imageLoader) {
        this.imageLoader = imageLoader;
    }

    public CropImageView.Style getStyle() {
        return this.style;
    }

    public void setStyle(CropImageView.Style style) {
        this.style = style;
    }

    public List<ImageFolder> getImageFolders() {
        return this.mImageFolders;
    }

    public void setImageFolders(List<ImageFolder> imageFolders) {
        this.mImageFolders = imageFolders;
    }

    public int getCurrentImageFolderPosition() {
        return this.mCurrentImageFolderPosition;
    }

    public void setCurrentImageFolderPosition(int mCurrentSelectedImageSetPosition) {
        this.mCurrentImageFolderPosition = mCurrentSelectedImageSetPosition;
    }

    public ArrayList<ImageItem> getCurrentImageFolderItems() {
        return this.mImageFolders.get((int)this.mCurrentImageFolderPosition).images;
    }

    public boolean isSelect(ImageItem item) {
        return this.mSelectedImages.contains(item);
    }

    public int getSelectImageCount() {
        if (this.mSelectedImages == null) {
            return 0;
        }
        return this.mSelectedImages.size();
    }

    public ArrayList<ImageItem> getSelectedImages() {
        return this.mSelectedImages;
    }

    public void clearSelectedImages() {
        if (this.mSelectedImages != null) {
            this.mSelectedImages.clear();
        }
    }

    public void clear() {
        if (this.mImageSelectedListeners != null) {
            this.mImageSelectedListeners.clear();
            this.mImageSelectedListeners = null;
        }
        if (this.mImageFolders != null) {
            this.mImageFolders.clear();
            this.mImageFolders = null;
        }
        if (this.mSelectedImages != null) {
            this.mSelectedImages.clear();
        }
        this.mCurrentImageFolderPosition = 0;
    }

    public void takePicture(Activity activity, int requestCode) {
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        takePictureIntent.setFlags(0x4000000);
        if (takePictureIntent.resolveActivity(activity.getPackageManager()) != null) {
            this.takeImageFile = Utils.existSDCard() ? new File(Environment.getExternalStorageDirectory(), "/DCIM/camera/") : Environment.getDataDirectory();
            this.takeImageFile = ImagePicker.createFile(this.takeImageFile, "IMG_", ".jpg");
            if (this.takeImageFile != null) {
                takePictureIntent.putExtra("output", (Parcelable)Uri.fromFile((File)this.takeImageFile));
            }
        }
        activity.startActivityForResult(takePictureIntent, requestCode);
    }

    public static File createFile(File folder, String prefix, String suffix) {
        if (!folder.exists() || !folder.isDirectory()) {
            folder.mkdirs();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.CHINA);
        String filename = prefix + dateFormat.format(new Date(System.currentTimeMillis())) + suffix;
        return new File(folder, filename);
    }

    public static void galleryAddPic(Context context, File file) {
        Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        Uri contentUri = Uri.fromFile((File)file);
        mediaScanIntent.setData(contentUri);
        context.sendBroadcast(mediaScanIntent);
    }

    public void addOnImageSelectedListener(OnImageSelectedListener l) {
        if (this.mImageSelectedListeners == null) {
            this.mImageSelectedListeners = new ArrayList<OnImageSelectedListener>();
        }
        this.mImageSelectedListeners.add(l);
    }

    public void removeOnImageSelectedListener(OnImageSelectedListener l) {
        if (this.mImageSelectedListeners == null) {
            return;
        }
        this.mImageSelectedListeners.remove(l);
    }

    public void addSelectedImageItem(int position, ImageItem item, boolean isAdd) {
        if (isAdd) {
            this.mSelectedImages.add(item);
        } else {
            this.mSelectedImages.remove(item);
        }
        this.notifyImageSelectedChanged(position, item, isAdd);
    }

    private void notifyImageSelectedChanged(int position, ImageItem item, boolean isAdd) {
        if (this.mImageSelectedListeners == null) {
            return;
        }
        for (OnImageSelectedListener l : this.mImageSelectedListeners) {
            l.onImageSelected(position, item, isAdd);
        }
    }

    public static interface OnImageSelectedListener {
        public void onImageSelected(int var1, ImageItem var2, boolean var3);
    }
}

