/*
 * Decompiled with CFR 0.152.
 */
package sing.imagepicker;

import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import sing.imagepicker.ImagePicker;
import sing.imagepicker.R;
import sing.imagepicker.bean.ImageFolder;
import sing.imagepicker.bean.ImageItem;

public class ImageDataSource
implements LoaderManager.LoaderCallbacks<Cursor> {
    public static final int LOADER_ALL = 0;
    public static final int LOADER_CATEGORY = 1;
    private final String[] IMAGE_PROJECTION = new String[]{"_display_name", "_data", "_size", "width", "height", "mime_type", "date_added"};
    private FragmentActivity activity;
    private OnImagesLoadedListener loadedListener;
    private ArrayList<ImageFolder> imageFolders = new ArrayList();

    public ImageDataSource(FragmentActivity activity, String path, OnImagesLoadedListener loadedListener) {
        this.activity = activity;
        this.loadedListener = loadedListener;
        LoaderManager loaderManager = activity.getSupportLoaderManager();
        if (path == null) {
            loaderManager.initLoader(0, null, (LoaderManager.LoaderCallbacks)this);
        } else {
            Bundle bundle = new Bundle();
            bundle.putString("path", path);
            loaderManager.initLoader(1, bundle, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
        CursorLoader cursorLoader = null;
        if (id2 == 0) {
            cursorLoader = new CursorLoader((Context)this.activity, MediaStore.Images.Media.EXTERNAL_CONTENT_URI, this.IMAGE_PROJECTION, null, null, this.IMAGE_PROJECTION[6] + " DESC");
        }
        if (id2 == 1) {
            cursorLoader = new CursorLoader((Context)this.activity, MediaStore.Images.Media.EXTERNAL_CONTENT_URI, this.IMAGE_PROJECTION, this.IMAGE_PROJECTION[1] + " like '%" + args.getString("path") + "%'", null, this.IMAGE_PROJECTION[6] + " DESC");
        }
        return cursorLoader;
    }

    public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
        this.imageFolders.clear();
        if (data != null) {
            ArrayList<ImageItem> allImages = new ArrayList<ImageItem>();
            while (data.moveToNext()) {
                String imageName = data.getString(data.getColumnIndexOrThrow(this.IMAGE_PROJECTION[0]));
                String imagePath = data.getString(data.getColumnIndexOrThrow(this.IMAGE_PROJECTION[1]));
                long imageSize = data.getLong(data.getColumnIndexOrThrow(this.IMAGE_PROJECTION[2]));
                int imageWidth = data.getInt(data.getColumnIndexOrThrow(this.IMAGE_PROJECTION[3]));
                int imageHeight = data.getInt(data.getColumnIndexOrThrow(this.IMAGE_PROJECTION[4]));
                String imageMimeType = data.getString(data.getColumnIndexOrThrow(this.IMAGE_PROJECTION[5]));
                long imageAddTime = data.getLong(data.getColumnIndexOrThrow(this.IMAGE_PROJECTION[6]));
                ImageItem imageItem = new ImageItem();
                imageItem.name = imageName;
                imageItem.path = imagePath;
                imageItem.size = imageSize;
                imageItem.width = imageWidth;
                imageItem.height = imageHeight;
                imageItem.mimeType = imageMimeType;
                imageItem.addTime = imageAddTime;
                allImages.add(imageItem);
                File imageFile = new File(imagePath);
                File imageParentFile = imageFile.getParentFile();
                ImageFolder imageFolder = new ImageFolder();
                imageFolder.name = imageParentFile.getName();
                imageFolder.path = imageParentFile.getAbsolutePath();
                if (!this.imageFolders.contains(imageFolder)) {
                    ArrayList<ImageItem> images = new ArrayList<ImageItem>();
                    images.add(imageItem);
                    imageFolder.cover = imageItem;
                    imageFolder.images = images;
                    this.imageFolders.add(imageFolder);
                    continue;
                }
                this.imageFolders.get((int)this.imageFolders.indexOf((Object)imageFolder)).images.add(imageItem);
            }
            if (data.getCount() > 0) {
                ImageFolder allImagesFolder = new ImageFolder();
                allImagesFolder.name = this.activity.getResources().getString(R.string.all_images);
                allImagesFolder.path = "/";
                allImagesFolder.cover = (ImageItem)allImages.get(0);
                allImagesFolder.images = allImages;
                this.imageFolders.add(0, allImagesFolder);
            }
        }
        ImagePicker.getInstance().setImageFolders(this.imageFolders);
        this.loadedListener.onImagesLoaded(this.imageFolders);
    }

    public void onLoaderReset(Loader<Cursor> loader) {
        System.out.println("--------");
    }

    public static interface OnImagesLoadedListener {
        public void onImagesLoaded(List<ImageFolder> var1);
    }
}

