/*
 * Decompiled with CFR 0.152.
 */
package sing.imagepicker.view;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import sing.imagepicker.R;

public class FolderPopUpWindow
extends PopupWindow
implements View.OnClickListener {
    private ListView listView;
    private OnItemClickListener onItemClickListener;
    private final View masker;
    private final View marginView;
    private int marginPx;

    public FolderPopUpWindow(Context context, BaseAdapter adapter) {
        super(context);
        final View view = View.inflate((Context)context, (int)R.layout.pop_folder, null);
        this.masker = view.findViewById(R.id.masker);
        this.masker.setOnClickListener((View.OnClickListener)this);
        this.marginView = view.findViewById(R.id.margin);
        this.marginView.setOnClickListener((View.OnClickListener)this);
        this.listView = (ListView)view.findViewById(R.id.listView);
        this.listView.setAdapter((ListAdapter)adapter);
        this.setContentView(view);
        this.setWidth(-1);
        this.setHeight(-1);
        this.setFocusable(true);
        this.setOutsideTouchable(true);
        this.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.setAnimationStyle(0);
        view.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                int maxHeight = view.getHeight() * 5 / 8;
                int realHeight = FolderPopUpWindow.this.listView.getHeight();
                ViewGroup.LayoutParams listParams = FolderPopUpWindow.this.listView.getLayoutParams();
                listParams.height = realHeight > maxHeight ? maxHeight : realHeight;
                FolderPopUpWindow.this.listView.setLayoutParams(listParams);
                LinearLayout.LayoutParams marginParams = (LinearLayout.LayoutParams)FolderPopUpWindow.this.marginView.getLayoutParams();
                marginParams.height = FolderPopUpWindow.this.marginPx;
                FolderPopUpWindow.this.marginView.setLayoutParams((ViewGroup.LayoutParams)marginParams);
                FolderPopUpWindow.this.enterAnimator();
            }
        });
        this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int position, long l) {
                if (FolderPopUpWindow.this.onItemClickListener != null) {
                    FolderPopUpWindow.this.onItemClickListener.onItemClick(adapterView, view, position, l);
                }
            }
        });
    }

    private void enterAnimator() {
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)this.masker, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator translationY = ObjectAnimator.ofFloat((Object)this.listView, (String)"translationY", (float[])new float[]{this.listView.getHeight(), 0.0f});
        AnimatorSet set = new AnimatorSet();
        set.setDuration(400L);
        set.playTogether(new Animator[]{alpha, translationY});
        set.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        set.start();
    }

    public void dismiss() {
        this.exitAnimator();
    }

    private void exitAnimator() {
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)this.masker, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        ObjectAnimator translationY = ObjectAnimator.ofFloat((Object)this.listView, (String)"translationY", (float[])new float[]{0.0f, this.listView.getHeight()});
        AnimatorSet set = new AnimatorSet();
        set.setDuration(300L);
        set.playTogether(new Animator[]{alpha, translationY});
        set.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        set.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                FolderPopUpWindow.this.listView.setVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
                FolderPopUpWindow.super.dismiss();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        set.start();
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.onItemClickListener = listener;
    }

    public void setSelection(int selection) {
        this.listView.setSelection(selection);
    }

    public void setMargin(int marginPx) {
        this.marginPx = marginPx;
    }

    public void onClick(View v) {
        this.dismiss();
    }

    public static interface OnItemClickListener {
        public void onItemClick(AdapterView<?> var1, View var2, int var3, long var4);
    }
}

