/*
 * Decompiled with CFR 0.152.
 */
package sing.imagepicker.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import sing.imagepicker.R;

public class CropImageView
extends ImageView {
    private Style[] styles = new Style[]{Style.RECTANGLE, Style.CIRCLE};
    private int mMaskColor = -1358954496;
    private int mBorderColor = -1434419072;
    private int mBorderWidth = 1;
    private int mFocusWidth = 250;
    private int mFocusHeight = 250;
    private int mDefaultStyleIndex = 0;
    private Style mStyle = this.styles[this.mDefaultStyleIndex];
    private Paint mBorderPaint = new Paint();
    private Path mFocusPath = new Path();
    private RectF mFocusRect = new RectF();
    private static final float MAX_SCALE = 4.0f;
    private static final int NONE = 0;
    private static final int DRAG = 1;
    private static final int ZOOM = 2;
    private static final int ROTATE = 3;
    private static final int ZOOM_OR_ROTATE = 4;
    private static final int SAVE_SUCCESS = 1001;
    private static final int SAVE_ERROR = 1002;
    private int mImageWidth;
    private int mImageHeight;
    private int mRotatedImageWidth;
    private int mRotatedImageHeight;
    private Matrix matrix = new Matrix();
    private Matrix savedMatrix = new Matrix();
    private PointF pA = new PointF();
    private PointF pB = new PointF();
    private PointF midPoint = new PointF();
    private PointF doubleClickPos = new PointF();
    private PointF mFocusMidPoint = new PointF();
    private int mode = 0;
    private long doubleClickTime = 0L;
    private double rotation = 0.0;
    private float oldDist = 1.0f;
    private int sumRotateLevel = 0;
    private float mMaxScale = 4.0f;
    private boolean isInited = false;
    private boolean mSaving = false;
    private static Handler mHandler = new InnerHandler();
    private static OnBitmapSaveCompleteListener mListener;

    public CropImageView(Context context) {
        this(context, null);
    }

    public CropImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CropImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mFocusWidth = (int)TypedValue.applyDimension((int)1, (float)this.mFocusWidth, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mFocusHeight = (int)TypedValue.applyDimension((int)1, (float)this.mFocusHeight, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mBorderWidth = (int)TypedValue.applyDimension((int)1, (float)this.mBorderWidth, (DisplayMetrics)this.getResources().getDisplayMetrics());
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CropImageView);
        this.mMaskColor = a.getColor(R.styleable.CropImageView_cropMaskColor, this.mMaskColor);
        this.mBorderColor = a.getColor(R.styleable.CropImageView_cropBorderColor, this.mBorderColor);
        this.mBorderWidth = a.getDimensionPixelSize(R.styleable.CropImageView_cropBorderWidth, this.mBorderWidth);
        this.mFocusWidth = a.getDimensionPixelSize(R.styleable.CropImageView_cropFocusWidth, this.mFocusWidth);
        this.mFocusHeight = a.getDimensionPixelSize(R.styleable.CropImageView_cropFocusHeight, this.mFocusHeight);
        this.mDefaultStyleIndex = a.getInteger(R.styleable.CropImageView_cropStyle, this.mDefaultStyleIndex);
        this.mStyle = this.styles[this.mDefaultStyleIndex];
        a.recycle();
        this.setScaleType(ImageView.ScaleType.MATRIX);
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.initImage();
    }

    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
        this.initImage();
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.initImage();
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.initImage();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.isInited = true;
        this.initImage();
    }

    private void initImage() {
        Drawable d = this.getDrawable();
        if (!this.isInited || d == null) {
            return;
        }
        this.mode = 0;
        this.matrix = this.getImageMatrix();
        this.mImageWidth = this.mRotatedImageWidth = d.getIntrinsicWidth();
        this.mImageHeight = this.mRotatedImageHeight = d.getIntrinsicHeight();
        int viewWidth = this.getWidth();
        int viewHeight = this.getHeight();
        float midPointX = viewWidth / 2;
        float midPointY = viewHeight / 2;
        this.mFocusMidPoint = new PointF(midPointX, midPointY);
        if (this.mStyle == Style.CIRCLE) {
            int focusSize;
            this.mFocusWidth = focusSize = Math.min(this.mFocusWidth, this.mFocusHeight);
            this.mFocusHeight = focusSize;
        }
        this.mFocusRect.left = this.mFocusMidPoint.x - (float)(this.mFocusWidth / 2);
        this.mFocusRect.right = this.mFocusMidPoint.x + (float)(this.mFocusWidth / 2);
        this.mFocusRect.top = this.mFocusMidPoint.y - (float)(this.mFocusHeight / 2);
        this.mFocusRect.bottom = this.mFocusMidPoint.y + (float)(this.mFocusHeight / 2);
        float fitFocusScale = this.getScale(this.mImageWidth, this.mImageHeight, this.mFocusWidth, this.mFocusHeight, true);
        this.mMaxScale = fitFocusScale * 4.0f;
        float fitViewScale = this.getScale(this.mImageWidth, this.mImageHeight, viewWidth, viewHeight, false);
        float scale = fitViewScale > fitFocusScale ? fitViewScale : fitFocusScale;
        this.matrix.setScale(scale, scale, (float)(this.mImageWidth / 2), (float)(this.mImageHeight / 2));
        float[] mImageMatrixValues = new float[9];
        this.matrix.getValues(mImageMatrixValues);
        float transX = this.mFocusMidPoint.x - (mImageMatrixValues[2] + (float)this.mImageWidth * mImageMatrixValues[0] / 2.0f);
        float transY = this.mFocusMidPoint.y - (mImageMatrixValues[5] + (float)this.mImageHeight * mImageMatrixValues[4] / 2.0f);
        this.matrix.postTranslate(transX, transY);
        this.setImageMatrix(this.matrix);
        this.invalidate();
    }

    private float getScale(int bitmapWidth, int bitmapHeight, int minWidth, int minHeight, boolean isMinScale) {
        float scaleX = (float)minWidth / (float)bitmapWidth;
        float scaleY = (float)minHeight / (float)bitmapHeight;
        float scale = isMinScale ? (scaleX > scaleY ? scaleX : scaleY) : (scaleX < scaleY ? scaleX : scaleY);
        return scale;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (Style.RECTANGLE == this.mStyle) {
            this.mFocusPath.addRect(this.mFocusRect, Path.Direction.CCW);
            canvas.save();
            canvas.clipRect(0, 0, this.getWidth(), this.getHeight());
            canvas.clipPath(this.mFocusPath, Region.Op.DIFFERENCE);
            canvas.drawColor(this.mMaskColor);
            canvas.restore();
        } else if (Style.CIRCLE == this.mStyle) {
            float radius = Math.min((this.mFocusRect.right - this.mFocusRect.left) / 2.0f, (this.mFocusRect.bottom - this.mFocusRect.top) / 2.0f);
            this.mFocusPath.addCircle(this.mFocusMidPoint.x, this.mFocusMidPoint.y, radius, Path.Direction.CCW);
            canvas.save();
            canvas.clipRect(0, 0, this.getWidth(), this.getHeight());
            canvas.clipPath(this.mFocusPath, Region.Op.DIFFERENCE);
            canvas.drawColor(this.mMaskColor);
            canvas.restore();
        }
        this.mBorderPaint.setColor(this.mBorderColor);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setStrokeWidth((float)this.mBorderWidth);
        this.mBorderPaint.setAntiAlias(true);
        canvas.drawPath(this.mFocusPath, this.mBorderPaint);
        this.mFocusPath.reset();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mSaving || null == this.getDrawable()) {
            return super.onTouchEvent(event);
        }
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.savedMatrix.set(this.matrix);
                this.pA.set(event.getX(), event.getY());
                this.pB.set(event.getX(), event.getY());
                this.mode = 1;
                break;
            }
            case 5: {
                if (event.getActionIndex() > 1) break;
                this.pA.set(event.getX(0), event.getY(0));
                this.pB.set(event.getX(1), event.getY(1));
                this.midPoint.set((this.pA.x + this.pB.x) / 2.0f, (this.pA.y + this.pB.y) / 2.0f);
                this.oldDist = this.spacing(this.pA, this.pB);
                this.savedMatrix.set(this.matrix);
                if (!(this.oldDist > 10.0f)) break;
                this.mode = 4;
                break;
            }
            case 2: {
                double c;
                double b;
                double a;
                PointF pC;
                if (this.mode == 4) {
                    pC = new PointF(event.getX(1) - event.getX(0) + this.pA.x, event.getY(1) - event.getY(0) + this.pA.y);
                    a = this.spacing(this.pB.x, this.pB.y, pC.x, pC.y);
                    b = this.spacing(this.pA.x, this.pA.y, pC.x, pC.y);
                    c = this.spacing(this.pA.x, this.pA.y, this.pB.x, this.pB.y);
                    if (a >= 10.0) {
                        double PID4;
                        double cosB = (a * a + c * c - b * b) / (2.0 * a * c);
                        double angleB = Math.acos(cosB);
                        this.mode = angleB > (PID4 = 0.7853981633974483) && angleB < 3.0 * PID4 ? 3 : 2;
                    }
                }
                if (this.mode == 1) {
                    this.matrix.set(this.savedMatrix);
                    this.matrix.postTranslate(event.getX() - this.pA.x, event.getY() - this.pA.y);
                    this.fixTranslation();
                    this.setImageMatrix(this.matrix);
                    break;
                }
                if (this.mode == 2) {
                    float newDist = this.spacing(event.getX(0), event.getY(0), event.getX(1), event.getY(1));
                    if (!(newDist > 10.0f)) break;
                    this.matrix.set(this.savedMatrix);
                    float tScale = Math.min(newDist / this.oldDist, this.maxPostScale());
                    if (tScale == 0.0f) break;
                    this.matrix.postScale(tScale, tScale, this.midPoint.x, this.midPoint.y);
                    this.fixScale();
                    this.fixTranslation();
                    this.setImageMatrix(this.matrix);
                    break;
                }
                if (this.mode != 3) break;
                pC = new PointF(event.getX(1) - event.getX(0) + this.pA.x, event.getY(1) - event.getY(0) + this.pA.y);
                a = this.spacing(this.pB.x, this.pB.y, pC.x, pC.y);
                b = this.spacing(this.pA.x, this.pA.y, pC.x, pC.y);
                c = this.spacing(this.pA.x, this.pA.y, this.pB.x, this.pB.y);
                if (!(b > 10.0)) break;
                double cosA = (b * b + c * c - a * a) / (2.0 * b * c);
                double angleA = Math.acos(cosA);
                double ta = this.pB.y - this.pA.y;
                double tb = this.pA.x - this.pB.x;
                double tc = this.pB.x * this.pA.y - this.pA.x * this.pB.y;
                double td = ta * (double)pC.x + tb * (double)pC.y + tc;
                if (td > 0.0) {
                    angleA = Math.PI * 2 - angleA;
                }
                this.rotation = angleA;
                this.matrix.set(this.savedMatrix);
                this.matrix.postRotate((float)(this.rotation * 180.0 / Math.PI), this.midPoint.x, this.midPoint.y);
                this.setImageMatrix(this.matrix);
                break;
            }
            case 1: 
            case 6: {
                if (this.mode == 1) {
                    if (this.spacing(this.pA, this.pB) < 50.0f) {
                        long now = System.currentTimeMillis();
                        if (now - this.doubleClickTime < 500L && this.spacing(this.pA, this.doubleClickPos) < 50.0f) {
                            this.doubleClick(this.pA.x, this.pA.y);
                            now = 0L;
                        }
                        this.doubleClickPos.set(this.pA);
                        this.doubleClickTime = now;
                    }
                } else if (this.mode == 3) {
                    int rotateLevel = (int)Math.floor((this.rotation + 0.7853981633974483) / 1.5707963267948966);
                    if (rotateLevel == 4) {
                        rotateLevel = 0;
                    }
                    this.matrix.set(this.savedMatrix);
                    this.matrix.postRotate((float)(90 * rotateLevel), this.midPoint.x, this.midPoint.y);
                    if (rotateLevel == 1 || rotateLevel == 3) {
                        int tmp = this.mRotatedImageWidth;
                        this.mRotatedImageWidth = this.mRotatedImageHeight;
                        this.mRotatedImageHeight = tmp;
                    }
                    this.fixScale();
                    this.fixTranslation();
                    this.setImageMatrix(this.matrix);
                    this.sumRotateLevel += rotateLevel;
                }
                this.mode = 0;
            }
        }
        ViewCompat.postInvalidateOnAnimation((View)this);
        return true;
    }

    private void fixScale() {
        float[] imageMatrixValues = new float[9];
        this.matrix.getValues(imageMatrixValues);
        float currentScale = Math.abs(imageMatrixValues[0]) + Math.abs(imageMatrixValues[1]);
        float minScale = this.getScale(this.mRotatedImageWidth, this.mRotatedImageHeight, this.mFocusWidth, this.mFocusHeight, true);
        this.mMaxScale = minScale * 4.0f;
        if (currentScale < minScale) {
            float scale = minScale / currentScale;
            this.matrix.postScale(scale, scale);
        } else if (currentScale > this.mMaxScale) {
            float scale = this.mMaxScale / currentScale;
            this.matrix.postScale(scale, scale);
        }
    }

    private void fixTranslation() {
        RectF imageRect = new RectF(0.0f, 0.0f, (float)this.mImageWidth, (float)this.mImageHeight);
        this.matrix.mapRect(imageRect);
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        if (imageRect.left > this.mFocusRect.left) {
            deltaX = -imageRect.left + this.mFocusRect.left;
        } else if (imageRect.right < this.mFocusRect.right) {
            deltaX = -imageRect.right + this.mFocusRect.right;
        }
        if (imageRect.top > this.mFocusRect.top) {
            deltaY = -imageRect.top + this.mFocusRect.top;
        } else if (imageRect.bottom < this.mFocusRect.bottom) {
            deltaY = -imageRect.bottom + this.mFocusRect.bottom;
        }
        this.matrix.postTranslate(deltaX, deltaY);
    }

    private float maxPostScale() {
        float[] imageMatrixValues = new float[9];
        this.matrix.getValues(imageMatrixValues);
        float curScale = Math.abs(imageMatrixValues[0]) + Math.abs(imageMatrixValues[1]);
        return this.mMaxScale / curScale;
    }

    private float spacing(float x1, float y1, float x2, float y2) {
        float x = x1 - x2;
        float y = y1 - y2;
        return (float)Math.sqrt(x * x + y * y);
    }

    private float spacing(PointF pA, PointF pB) {
        return this.spacing(pA.x, pA.y, pB.x, pB.y);
    }

    private void doubleClick(float x, float y) {
        float[] p = new float[9];
        this.matrix.getValues(p);
        float curScale = Math.abs(p[0]) + Math.abs(p[1]);
        float minScale = this.getScale(this.mRotatedImageWidth, this.mRotatedImageHeight, this.mFocusWidth, this.mFocusHeight, true);
        if (curScale < this.mMaxScale) {
            float toScale = Math.min(curScale + minScale, this.mMaxScale) / curScale;
            this.matrix.postScale(toScale, toScale, x, y);
        } else {
            float toScale = minScale / curScale;
            this.matrix.postScale(toScale, toScale, x, y);
            this.fixTranslation();
        }
        this.setImageMatrix(this.matrix);
    }

    public Bitmap getCropBitmap(int expectWidth, int exceptHeight, boolean isSaveRectangle) {
        if (expectWidth <= 0 || exceptHeight < 0) {
            return null;
        }
        Bitmap srcBitmap = ((BitmapDrawable)this.getDrawable()).getBitmap();
        srcBitmap = this.rotate(srcBitmap, this.sumRotateLevel * 90);
        return this.makeCropBitmap(srcBitmap, this.mFocusRect, this.getImageMatrixRect(), expectWidth, exceptHeight, isSaveRectangle);
    }

    private Bitmap rotate(Bitmap bitmap, int degrees) {
        if (degrees != 0 && bitmap != null) {
            Matrix matrix = new Matrix();
            matrix.setRotate((float)degrees, (float)bitmap.getWidth() / 2.0f, (float)bitmap.getHeight() / 2.0f);
            try {
                Bitmap rotateBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                if (bitmap != rotateBitmap) {
                    return rotateBitmap;
                }
            }
            catch (OutOfMemoryError ex) {
                ex.printStackTrace();
            }
        }
        return bitmap;
    }

    private RectF getImageMatrixRect() {
        RectF rectF = new RectF();
        rectF.set(0.0f, 0.0f, (float)this.getDrawable().getIntrinsicWidth(), (float)this.getDrawable().getIntrinsicHeight());
        this.matrix.mapRect(rectF);
        return rectF;
    }

    private Bitmap makeCropBitmap(Bitmap bitmap, RectF focusRect, RectF imageMatrixRect, int expectWidth, int exceptHeight, boolean isSaveRectangle) {
        float scale = imageMatrixRect.width() / (float)bitmap.getWidth();
        int left = (int)((focusRect.left - imageMatrixRect.left) / scale);
        int top = (int)((focusRect.top - imageMatrixRect.top) / scale);
        int width = (int)(focusRect.width() / scale);
        int height = (int)(focusRect.height() / scale);
        if (left < 0) {
            left = 0;
        }
        if (top < 0) {
            top = 0;
        }
        if (left + width > bitmap.getWidth()) {
            width = bitmap.getWidth() - left;
        }
        if (top + height > bitmap.getHeight()) {
            height = bitmap.getHeight() - top;
        }
        try {
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)left, (int)top, (int)width, (int)height);
            if (expectWidth != width || exceptHeight != height) {
                bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)expectWidth, (int)exceptHeight, (boolean)true);
                if (this.mStyle == Style.CIRCLE && !isSaveRectangle) {
                    int length = Math.min(expectWidth, exceptHeight);
                    int radius = length / 2;
                    Bitmap circleBitmap = Bitmap.createBitmap((int)length, (int)length, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    Canvas canvas = new Canvas(circleBitmap);
                    BitmapShader bitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                    Paint paint = new Paint();
                    paint.setShader((Shader)bitmapShader);
                    canvas.drawCircle((float)expectWidth / 2.0f, (float)exceptHeight / 2.0f, (float)radius, paint);
                    bitmap = circleBitmap;
                }
            }
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    public void saveBitmapToFile(File folder, int expectWidth, int exceptHeight, boolean isSaveRectangle) {
        if (this.mSaving) {
            return;
        }
        this.mSaving = true;
        final Bitmap croppedImage = this.getCropBitmap(expectWidth, exceptHeight, isSaveRectangle);
        Bitmap.CompressFormat outputFormat = Bitmap.CompressFormat.JPEG;
        File saveFile = this.createFile(folder, "IMG_", ".jpg");
        if (this.mStyle == Style.CIRCLE && !isSaveRectangle) {
            outputFormat = Bitmap.CompressFormat.PNG;
            saveFile = this.createFile(folder, "IMG_", ".png");
        }
        final Bitmap.CompressFormat finalOutputFormat = outputFormat;
        final File finalSaveFile = saveFile;
        new Thread(){

            @Override
            public void run() {
                CropImageView.this.saveOutput(croppedImage, finalOutputFormat, finalSaveFile);
            }
        }.start();
    }

    private File createFile(File folder, String prefix, String suffix) {
        if (!folder.exists() || !folder.isDirectory()) {
            folder.mkdirs();
        }
        try {
            File nomedia = new File(folder, ".nomedia");
            if (!nomedia.exists()) {
                nomedia.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.CHINA);
        String filename = prefix + dateFormat.format(new Date(System.currentTimeMillis())) + suffix;
        return new File(folder, filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOutput(Bitmap croppedImage, Bitmap.CompressFormat outputFormat, File saveFile) {
        OutputStream outputStream = null;
        try {
            outputStream = this.getContext().getContentResolver().openOutputStream(Uri.fromFile((File)saveFile));
            if (outputStream != null) {
                croppedImage.compress(outputFormat, 90, outputStream);
            }
            Message.obtain((Handler)mHandler, (int)1001, (Object)saveFile).sendToTarget();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Message.obtain((Handler)mHandler, (int)1002, (Object)saveFile).sendToTarget();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.mSaving = false;
        croppedImage.recycle();
    }

    public void setOnBitmapSaveCompleteListener(OnBitmapSaveCompleteListener listener) {
        mListener = listener;
    }

    public int getFocusWidth() {
        return this.mFocusWidth;
    }

    public void setFocusWidth(int width) {
        this.mFocusWidth = width;
        this.initImage();
    }

    public int getFocusHeight() {
        return this.mFocusHeight;
    }

    public void setFocusHeight(int height) {
        this.mFocusHeight = height;
        this.initImage();
    }

    public int getMaskColor() {
        return this.mMaskColor;
    }

    public void setMaskColor(int color2) {
        this.mMaskColor = color2;
        this.invalidate();
    }

    public int getFocusColor() {
        return this.mBorderColor;
    }

    public void setBorderColor(int color2) {
        this.mBorderColor = color2;
        this.invalidate();
    }

    public float getBorderWidth() {
        return this.mBorderWidth;
    }

    public void setBorderWidth(int width) {
        this.mBorderWidth = width;
        this.invalidate();
    }

    public void setFocusStyle(Style style) {
        this.mStyle = style;
        this.invalidate();
    }

    public Style getFocusStyle() {
        return this.mStyle;
    }

    public static interface OnBitmapSaveCompleteListener {
        public void onBitmapSaveSuccess(File var1);

        public void onBitmapSaveError(File var1);
    }

    private static class InnerHandler
    extends Handler {
        public InnerHandler() {
            super(Looper.getMainLooper());
        }

        public void handleMessage(Message msg) {
            File saveFile = (File)msg.obj;
            switch (msg.what) {
                case 1001: {
                    if (mListener == null) break;
                    mListener.onBitmapSaveSuccess(saveFile);
                    break;
                }
                case 1002: {
                    if (mListener == null) break;
                    mListener.onBitmapSaveError(saveFile);
                }
            }
        }
    }

    public static enum Style {
        RECTANGLE,
        CIRCLE;

    }
}

