/*
 * Decompiled with CFR 0.152.
 */
package sing.imagepicker.ui;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.util.ArrayList;
import sing.imagepicker.ImagePicker;
import sing.imagepicker.R;
import sing.imagepicker.Utils;
import sing.imagepicker.adapter.ImagePageAdapter;
import sing.imagepicker.bean.ImageItem;
import sing.imagepicker.ui.ImageBaseActivity;
import sing.imagepicker.view.ViewPagerFixed;

public abstract class ImagePreviewBaseActivity
extends ImageBaseActivity {
    protected ImagePicker imagePicker;
    protected ArrayList<ImageItem> mImageItems;
    protected int mCurrentPosition = 0;
    protected TextView mTitleCount;
    protected ArrayList<ImageItem> selectedImages;
    protected View content;
    protected View topBar;
    protected ViewPagerFixed mViewPager;
    protected ImagePageAdapter mAdapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_image_preview);
        this.mCurrentPosition = this.getIntent().getIntExtra("selected_image_position", 0);
        this.mImageItems = (ArrayList)this.getIntent().getSerializableExtra("extra_image_items");
        this.imagePicker = ImagePicker.getInstance();
        this.selectedImages = this.imagePicker.getSelectedImages();
        this.content = this.findViewById(R.id.content);
        this.topBar = this.findViewById(R.id.top_bar);
        if (Build.VERSION.SDK_INT >= 19) {
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.topBar.getLayoutParams();
            params.topMargin = Utils.getStatusHeight((Context)this);
            this.topBar.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.topBar.findViewById(R.id.btn_ok).setVisibility(8);
        this.topBar.findViewById(R.id.btn_back).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImagePreviewBaseActivity.this.finish();
            }
        });
        this.mTitleCount = (TextView)this.findViewById(R.id.tv_des);
        this.mViewPager = (ViewPagerFixed)this.findViewById(R.id.viewpager);
        this.mAdapter = new ImagePageAdapter((Activity)this, this.mImageItems);
        this.mAdapter.setPhotoViewClickListener(new ImagePageAdapter.PhotoViewClickListener(){

            @Override
            public void OnPhotoTapListener(View view, float v, float v1) {
                ImagePreviewBaseActivity.this.onImageSingleTap();
            }
        });
        this.mViewPager.setAdapter(this.mAdapter);
        this.mViewPager.setCurrentItem(this.mCurrentPosition, false);
        this.mTitleCount.setText((CharSequence)this.getString(R.string.preview_image_count, new Object[]{this.mCurrentPosition + 1, this.mImageItems.size()}));
    }

    public abstract void onImageSingleTap();
}

