/*
 * Decompiled with CFR 0.152.
 */
package sing.imagepicker.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.view.ViewPager;
import android.text.format.Formatter;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.Toast;
import sing.imagepicker.ImagePicker;
import sing.imagepicker.R;
import sing.imagepicker.bean.ImageItem;
import sing.imagepicker.ui.ImagePreviewBaseActivity;
import sing.imagepicker.view.SuperCheckBox;

public class ImagePreviewActivity
extends ImagePreviewBaseActivity
implements ImagePicker.OnImageSelectedListener,
View.OnClickListener,
CompoundButton.OnCheckedChangeListener {
    public static final String ISORIGIN = "isOrigin";
    private boolean isOrigin;
    private SuperCheckBox mCbCheck;
    private SuperCheckBox mCbOrigin;
    private Button mBtnOk;
    private View bottomBar;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.isOrigin = this.getIntent().getBooleanExtra(ISORIGIN, false);
        this.imagePicker.addOnImageSelectedListener(this);
        this.mBtnOk = (Button)this.topBar.findViewById(R.id.btn_ok);
        this.mBtnOk.setVisibility(0);
        this.mBtnOk.setOnClickListener((View.OnClickListener)this);
        this.bottomBar = this.findViewById(R.id.bottom_bar);
        this.bottomBar.setVisibility(0);
        this.mCbCheck = (SuperCheckBox)this.findViewById(R.id.cb_check);
        this.mCbOrigin = (SuperCheckBox)this.findViewById(R.id.cb_origin);
        this.mCbOrigin.setText(this.getString(R.string.origin));
        this.mCbOrigin.setOnCheckedChangeListener(this);
        this.mCbOrigin.setChecked(this.isOrigin);
        this.onImageSelected(0, null, false);
        ImageItem item = (ImageItem)this.mImageItems.get(this.mCurrentPosition);
        boolean isSelected = this.imagePicker.isSelect(item);
        this.mTitleCount.setText((CharSequence)this.getString(R.string.preview_image_count, new Object[]{this.mCurrentPosition + 1, this.mImageItems.size()}));
        this.mCbCheck.setChecked(isSelected);
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

            public void onPageSelected(int position) {
                ImagePreviewActivity.this.mCurrentPosition = position;
                ImageItem item = (ImageItem)ImagePreviewActivity.this.mImageItems.get(ImagePreviewActivity.this.mCurrentPosition);
                boolean isSelected = ImagePreviewActivity.this.imagePicker.isSelect(item);
                ImagePreviewActivity.this.mCbCheck.setChecked(isSelected);
                ImagePreviewActivity.this.mTitleCount.setText((CharSequence)ImagePreviewActivity.this.getString(R.string.preview_image_count, new Object[]{ImagePreviewActivity.this.mCurrentPosition + 1, ImagePreviewActivity.this.mImageItems.size()}));
            }
        });
        this.mCbCheck.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImageItem imageItem = (ImageItem)ImagePreviewActivity.this.mImageItems.get(ImagePreviewActivity.this.mCurrentPosition);
                int selectLimit = ImagePreviewActivity.this.imagePicker.getSelectLimit();
                if (ImagePreviewActivity.this.mCbCheck.isChecked() && ImagePreviewActivity.this.selectedImages.size() >= selectLimit) {
                    Toast.makeText((Context)ImagePreviewActivity.this, (CharSequence)ImagePreviewActivity.this.getString(R.string.select_limit, new Object[]{selectLimit}), (int)0).show();
                    ImagePreviewActivity.this.mCbCheck.setChecked(false);
                } else {
                    ImagePreviewActivity.this.imagePicker.addSelectedImageItem(ImagePreviewActivity.this.mCurrentPosition, imageItem, ImagePreviewActivity.this.mCbCheck.isChecked());
                }
            }
        });
    }

    @Override
    public void onImageSelected(int position, ImageItem item, boolean isAdd) {
        if (this.imagePicker.getSelectImageCount() > 0) {
            this.mBtnOk.setText((CharSequence)this.getString(R.string.select_complete, new Object[]{this.imagePicker.getSelectImageCount(), this.imagePicker.getSelectLimit()}));
            this.mBtnOk.setEnabled(true);
        } else {
            this.mBtnOk.setText((CharSequence)this.getString(R.string.complete));
            this.mBtnOk.setEnabled(false);
        }
        if (this.mCbOrigin.isChecked()) {
            long size = 0L;
            for (ImageItem imageItem : this.selectedImages) {
                size += imageItem.size;
            }
            String fileSize = Formatter.formatFileSize((Context)this, (long)size);
            this.mCbOrigin.setText(this.getString(R.string.origin_size, new Object[]{fileSize}));
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btn_ok) {
            Intent intent = new Intent();
            intent.putExtra("extra_result_items", this.imagePicker.getSelectedImages());
            this.setResult(1004, intent);
            this.finish();
        } else if (id2 == R.id.btn_back) {
            Intent intent = new Intent();
            intent.putExtra(ISORIGIN, this.isOrigin);
            this.setResult(1005, intent);
            this.finish();
        }
    }

    public void onBackPressed() {
        Intent intent = new Intent();
        intent.putExtra(ISORIGIN, this.isOrigin);
        this.setResult(1005, intent);
        this.finish();
        super.onBackPressed();
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        int id2 = buttonView.getId();
        if (id2 == R.id.cb_origin) {
            if (isChecked) {
                long size = 0L;
                for (ImageItem item : this.selectedImages) {
                    size += item.size;
                }
                String fileSize = Formatter.formatFileSize((Context)this, (long)size);
                this.isOrigin = true;
                this.mCbOrigin.setText(this.getString(R.string.origin_size, new Object[]{fileSize}));
            } else {
                this.isOrigin = false;
                this.mCbOrigin.setText(this.getString(R.string.origin));
            }
        }
    }

    protected void onDestroy() {
        this.imagePicker.removeOnImageSelectedListener(this);
        super.onDestroy();
    }

    @Override
    public void onImageSingleTap() {
        if (this.topBar.getVisibility() == 0) {
            this.topBar.setAnimation(AnimationUtils.loadAnimation((Context)this, (int)R.anim.top_out));
            this.bottomBar.setAnimation(AnimationUtils.loadAnimation((Context)this, (int)R.anim.fade_out));
            this.topBar.setVisibility(8);
            this.bottomBar.setVisibility(8);
            this.tintManager.setStatusBarTintResource(R.color.transparent);
            if (Build.VERSION.SDK_INT >= 16) {
                this.content.setSystemUiVisibility(4);
            }
        } else {
            this.topBar.setAnimation(AnimationUtils.loadAnimation((Context)this, (int)R.anim.top_in));
            this.bottomBar.setAnimation(AnimationUtils.loadAnimation((Context)this, (int)R.anim.fade_in));
            this.topBar.setVisibility(0);
            this.bottomBar.setVisibility(0);
            this.tintManager.setStatusBarTintResource(R.color.status_bar);
            if (Build.VERSION.SDK_INT >= 16) {
                this.content.setSystemUiVisibility(1024);
            }
        }
    }
}

