/*
 * Decompiled with CFR 0.152.
 */
package sing.imagepicker.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.GridView;
import android.widget.ListAdapter;
import java.util.List;
import sing.imagepicker.ImageDataSource;
import sing.imagepicker.ImagePicker;
import sing.imagepicker.R;
import sing.imagepicker.adapter.ImageFolderAdapter;
import sing.imagepicker.adapter.ImageGridAdapter;
import sing.imagepicker.bean.ImageFolder;
import sing.imagepicker.bean.ImageItem;
import sing.imagepicker.ui.ImageBaseActivity;
import sing.imagepicker.ui.ImageCropActivity;
import sing.imagepicker.ui.ImagePreviewActivity;
import sing.imagepicker.view.FolderPopUpWindow;

public class ImageGridActivity
extends ImageBaseActivity
implements ImageDataSource.OnImagesLoadedListener,
ImageGridAdapter.OnImageItemClickListener,
ImagePicker.OnImageSelectedListener,
View.OnClickListener {
    public static final int REQUEST_PERMISSION_STORAGE = 1;
    public static final int REQUEST_PERMISSION_CAMERA = 2;
    private ImagePicker imagePicker;
    private boolean isOrigin = false;
    private GridView mGridView;
    private View mFooterBar;
    private Button mBtnOk;
    private Button mBtnDir;
    private Button mBtnPre;
    private ImageFolderAdapter mImageFolderAdapter;
    private FolderPopUpWindow mFolderPopupWindow;
    private List<ImageFolder> mImageFolders;
    private ImageGridAdapter mImageGridAdapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_image_grid);
        this.imagePicker = ImagePicker.getInstance();
        this.imagePicker.clear();
        this.imagePicker.addOnImageSelectedListener(this);
        this.findViewById(R.id.btn_back).setOnClickListener((View.OnClickListener)this);
        this.mBtnOk = (Button)this.findViewById(R.id.btn_ok);
        this.mBtnOk.setOnClickListener((View.OnClickListener)this);
        this.mBtnDir = (Button)this.findViewById(R.id.btn_dir);
        this.mBtnDir.setOnClickListener((View.OnClickListener)this);
        this.mBtnPre = (Button)this.findViewById(R.id.btn_preview);
        this.mBtnPre.setOnClickListener((View.OnClickListener)this);
        this.mGridView = (GridView)this.findViewById(R.id.gridview);
        this.mFooterBar = this.findViewById(R.id.footer_bar);
        if (this.imagePicker.isMultiMode()) {
            this.mBtnOk.setVisibility(0);
            this.mBtnPre.setVisibility(0);
        } else {
            this.mBtnOk.setVisibility(8);
            this.mBtnPre.setVisibility(8);
        }
        this.mImageGridAdapter = new ImageGridAdapter((Activity)this, null);
        this.mImageFolderAdapter = new ImageFolderAdapter((Activity)this, null);
        this.onImageSelected(0, null, false);
        if (Build.VERSION.SDK_INT > 16) {
            if (this.checkPermission("android.permission.WRITE_EXTERNAL_STORAGE")) {
                new ImageDataSource((FragmentActivity)this, null, this);
            } else {
                ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)1);
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 1) {
            if (grantResults[0] == 0) {
                new ImageDataSource((FragmentActivity)this, null, this);
            } else {
                this.showToast("\u6743\u9650\u88ab\u7981\u6b62\uff0c\u65e0\u6cd5\u9009\u62e9\u672c\u5730\u56fe\u7247");
            }
        } else if (requestCode == 2) {
            if (grantResults[0] == 0) {
                this.imagePicker.takePicture((Activity)this, 1001);
            } else {
                this.showToast("\u6743\u9650\u88ab\u7981\u6b62\uff0c\u65e0\u6cd5\u6253\u5f00\u76f8\u673a");
            }
        }
    }

    protected void onDestroy() {
        this.imagePicker.removeOnImageSelectedListener(this);
        super.onDestroy();
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btn_ok) {
            Intent intent = new Intent();
            intent.putExtra("extra_result_items", this.imagePicker.getSelectedImages());
            this.setResult(1004, intent);
            this.finish();
        } else if (id2 == R.id.btn_dir) {
            if (this.mImageFolders == null) {
                Log.i((String)"ImageGridActivity", (String)"\u60a8\u7684\u624b\u673a\u6ca1\u6709\u56fe\u7247");
                return;
            }
            this.createPopupFolderList();
            this.mImageFolderAdapter.refreshData(this.mImageFolders);
            if (this.mFolderPopupWindow.isShowing()) {
                this.mFolderPopupWindow.dismiss();
            } else {
                this.mFolderPopupWindow.showAtLocation(this.mFooterBar, 0, 0, 0);
                int index = this.mImageFolderAdapter.getSelectIndex();
                index = index == 0 ? index : index - 1;
                this.mFolderPopupWindow.setSelection(index);
            }
        } else if (id2 == R.id.btn_preview) {
            Intent intent = new Intent((Context)this, ImagePreviewActivity.class);
            intent.putExtra("selected_image_position", 0);
            intent.putExtra("extra_image_items", this.imagePicker.getSelectedImages());
            intent.putExtra("isOrigin", this.isOrigin);
            this.startActivityForResult(intent, 1003);
        } else if (id2 == R.id.btn_back) {
            this.finish();
        }
    }

    private void createPopupFolderList() {
        this.mFolderPopupWindow = new FolderPopUpWindow((Context)this, this.mImageFolderAdapter);
        this.mFolderPopupWindow.setOnItemClickListener(new FolderPopUpWindow.OnItemClickListener(){

            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int position, long l) {
                ImageGridActivity.this.mImageFolderAdapter.setSelectIndex(position);
                ImageGridActivity.this.imagePicker.setCurrentImageFolderPosition(position);
                ImageGridActivity.this.mFolderPopupWindow.dismiss();
                ImageFolder imageFolder = (ImageFolder)adapterView.getAdapter().getItem(position);
                if (null != imageFolder) {
                    ImageGridActivity.this.mImageGridAdapter.refreshData(imageFolder.images);
                    ImageGridActivity.this.mBtnDir.setText((CharSequence)imageFolder.name);
                }
                ImageGridActivity.this.mGridView.smoothScrollToPosition(0);
            }
        });
        this.mFolderPopupWindow.setMargin(this.mFooterBar.getHeight());
    }

    @Override
    public void onImagesLoaded(List<ImageFolder> imageFolders) {
        this.mImageFolders = imageFolders;
        this.imagePicker.setImageFolders(imageFolders);
        if (imageFolders.size() == 0) {
            this.mImageGridAdapter.refreshData(null);
        } else {
            this.mImageGridAdapter.refreshData(imageFolders.get((int)0).images);
        }
        this.mImageGridAdapter.setOnImageItemClickListener(this);
        this.mGridView.setAdapter((ListAdapter)this.mImageGridAdapter);
        this.mImageFolderAdapter.refreshData(imageFolders);
    }

    @Override
    public void onImageItemClick(View view, ImageItem imageItem, int position) {
        int n = position = this.imagePicker.isShowCamera() ? position - 1 : position;
        if (this.imagePicker.isMultiMode()) {
            Intent intent = new Intent((Context)this, ImagePreviewActivity.class);
            intent.putExtra("selected_image_position", position);
            intent.putExtra("extra_image_items", this.imagePicker.getCurrentImageFolderItems());
            intent.putExtra("isOrigin", this.isOrigin);
            this.startActivityForResult(intent, 1003);
        } else {
            this.imagePicker.clearSelectedImages();
            this.imagePicker.addSelectedImageItem(position, this.imagePicker.getCurrentImageFolderItems().get(position), true);
            if (this.imagePicker.isCrop()) {
                Intent intent = new Intent((Context)this, ImageCropActivity.class);
                this.startActivityForResult(intent, 1002);
            } else {
                Intent intent = new Intent();
                intent.putExtra("extra_result_items", this.imagePicker.getSelectedImages());
                this.setResult(1004, intent);
                this.finish();
            }
        }
    }

    @Override
    public void onImageSelected(int position, ImageItem item, boolean isAdd) {
        if (this.imagePicker.getSelectImageCount() > 0) {
            this.mBtnOk.setText((CharSequence)this.getString(R.string.select_complete, new Object[]{this.imagePicker.getSelectImageCount(), this.imagePicker.getSelectLimit()}));
            this.mBtnOk.setEnabled(true);
            this.mBtnPre.setEnabled(true);
        } else {
            this.mBtnOk.setText((CharSequence)this.getString(R.string.complete));
            this.mBtnOk.setEnabled(false);
            this.mBtnPre.setEnabled(false);
        }
        this.mBtnPre.setText((CharSequence)this.getResources().getString(R.string.preview_count, new Object[]{this.imagePicker.getSelectImageCount()}));
        this.mImageGridAdapter.notifyDataSetChanged();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (data != null) {
            if (resultCode == 1005) {
                this.isOrigin = data.getBooleanExtra("isOrigin", false);
            } else if (data.getSerializableExtra("extra_result_items") != null) {
                this.setResult(1004, data);
                this.finish();
            }
        } else if (resultCode == -1 && requestCode == 1001) {
            ImagePicker.galleryAddPic((Context)this, this.imagePicker.getTakeImageFile());
            ImageItem imageItem = new ImageItem();
            imageItem.path = this.imagePicker.getTakeImageFile().getAbsolutePath();
            this.imagePicker.clearSelectedImages();
            this.imagePicker.addSelectedImageItem(0, imageItem, true);
            if (this.imagePicker.isCrop()) {
                Intent intent = new Intent((Context)this, ImageCropActivity.class);
                this.startActivityForResult(intent, 1002);
            } else {
                Intent intent = new Intent();
                intent.putExtra("extra_result_items", this.imagePicker.getSelectedImages());
                this.setResult(1004, intent);
                this.finish();
            }
        }
    }
}

