/*
 * Decompiled with CFR 0.152.
 */
package sing.imagepicker.adapter;

import android.app.Activity;
import android.content.Context;
import android.support.v4.app.ActivityCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.Toast;
import java.util.ArrayList;
import sing.imagepicker.ImagePicker;
import sing.imagepicker.R;
import sing.imagepicker.Utils;
import sing.imagepicker.bean.ImageItem;
import sing.imagepicker.ui.ImageBaseActivity;
import sing.imagepicker.view.SuperCheckBox;

public class ImageGridAdapter
extends BaseAdapter {
    private static final int ITEM_TYPE_CAMERA = 0;
    private static final int ITEM_TYPE_NORMAL = 1;
    private ImagePicker imagePicker;
    private Activity mActivity;
    private ArrayList<ImageItem> images;
    private ArrayList<ImageItem> mSelectedImages;
    private boolean isShowCamera;
    private int mImageSize;
    private OnImageItemClickListener listener;

    public ImageGridAdapter(Activity activity, ArrayList<ImageItem> images) {
        this.mActivity = activity;
        this.images = images == null || images.size() == 0 ? new ArrayList() : images;
        this.mImageSize = Utils.getImageItemWidth(this.mActivity);
        this.imagePicker = ImagePicker.getInstance();
        this.isShowCamera = this.imagePicker.isShowCamera();
        this.mSelectedImages = this.imagePicker.getSelectedImages();
    }

    public void refreshData(ArrayList<ImageItem> images) {
        this.images = images == null || images.size() == 0 ? new ArrayList() : images;
        this.notifyDataSetChanged();
    }

    public int getViewTypeCount() {
        return 2;
    }

    public int getItemViewType(int position) {
        if (this.isShowCamera) {
            return position == 0 ? 0 : 1;
        }
        return 1;
    }

    public int getCount() {
        return this.isShowCamera ? this.images.size() + 1 : this.images.size();
    }

    public ImageItem getItem(int position) {
        if (this.isShowCamera) {
            if (position == 0) {
                return null;
            }
            return this.images.get(position - 1);
        }
        return this.images.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        int itemViewType = this.getItemViewType(position);
        if (itemViewType == 0) {
            convertView = LayoutInflater.from((Context)this.mActivity).inflate(R.layout.adapter_camera_item, parent, false);
            convertView.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, this.mImageSize));
            convertView.setTag(null);
            convertView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (!((ImageBaseActivity)ImageGridAdapter.this.mActivity).checkPermission("android.permission.CAMERA")) {
                        ActivityCompat.requestPermissions((Activity)ImageGridAdapter.this.mActivity, (String[])new String[]{"android.permission.CAMERA"}, (int)2);
                    } else {
                        ImageGridAdapter.this.imagePicker.takePicture(ImageGridAdapter.this.mActivity, 1001);
                    }
                }
            });
        } else {
            ViewHolder holder;
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)this.mActivity).inflate(R.layout.adapter_image_list_item, parent, false);
                convertView.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, this.mImageSize));
                holder = new ViewHolder(convertView);
                convertView.setTag((Object)holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            final ImageItem imageItem = this.getItem(position);
            holder.ivThumb.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ImageGridAdapter.this.listener != null) {
                        ImageGridAdapter.this.listener.onImageItemClick(holder.rootView, imageItem, position);
                    }
                }
            });
            holder.cbCheck.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int selectLimit = ImageGridAdapter.this.imagePicker.getSelectLimit();
                    if (holder.cbCheck.isChecked() && ImageGridAdapter.this.mSelectedImages.size() >= selectLimit) {
                        Toast.makeText((Context)ImageGridAdapter.this.mActivity.getApplicationContext(), (CharSequence)ImageGridAdapter.this.mActivity.getString(R.string.select_limit, new Object[]{selectLimit}), (int)0).show();
                        holder.cbCheck.setChecked(false);
                        holder.mask.setVisibility(8);
                    } else {
                        ImageGridAdapter.this.imagePicker.addSelectedImageItem(position, imageItem, holder.cbCheck.isChecked());
                        holder.mask.setVisibility(0);
                    }
                }
            });
            if (this.imagePicker.isMultiMode()) {
                holder.cbCheck.setVisibility(0);
                boolean checked = this.mSelectedImages.contains(imageItem);
                if (checked) {
                    holder.mask.setVisibility(0);
                    holder.cbCheck.setChecked(true);
                } else {
                    holder.mask.setVisibility(8);
                    holder.cbCheck.setChecked(false);
                }
            } else {
                holder.cbCheck.setVisibility(8);
            }
            this.imagePicker.getImageLoader().displayImage(this.mActivity, imageItem.path, holder.ivThumb, this.mImageSize, this.mImageSize);
        }
        return convertView;
    }

    public void setOnImageItemClickListener(OnImageItemClickListener listener) {
        this.listener = listener;
    }

    public static interface OnImageItemClickListener {
        public void onImageItemClick(View var1, ImageItem var2, int var3);
    }

    private class ViewHolder {
        public View rootView;
        public ImageView ivThumb;
        public View mask;
        public SuperCheckBox cbCheck;

        public ViewHolder(View view) {
            this.rootView = view;
            this.ivThumb = (ImageView)view.findViewById(R.id.iv_thumb);
            this.mask = view.findViewById(R.id.mask);
            this.cbCheck = (SuperCheckBox)view.findViewById(R.id.cb_check);
        }
    }
}

