/*
 * Decompiled with CFR 0.152.
 */
package android.support.log4j;

import android.support.log4j.DailyRollingFileAppender;
import android.support.log4j.LogCatAppender;
import android.support.log4j.RollingFileAppender;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.LogLog;

public class LogConfigurator {
    private Level rootLevel = Level.DEBUG;
    private String filePattern = "%d - [%p::%c::%C] - %m%n";
    private String logCatPattern = "%m%n";
    private String fileName = "android-log4j.log";
    private int maxBackupSize = 10;
    private long maxFileSize = 524288L;
    private boolean immediateFlush = true;
    private boolean useLogCatAppender = true;
    private boolean useFileAppender = true;
    private boolean resetConfiguration = true;
    private boolean internalDebugging = false;
    private String datePattern = "'.'yyyy-MM-dd";
    private boolean asyncFileAppender = true;
    private int maxBackupDays = -1;
    private boolean dailyRollingMode = true;

    public LogConfigurator() {
    }

    public LogConfigurator(String fileName) {
        this.setFileName(fileName);
    }

    public LogConfigurator(String fileName, Level rootLevel) {
        this(fileName);
        this.setRootLevel(rootLevel);
    }

    public LogConfigurator(String fileName, Level rootLevel, String filePattern) {
        this(fileName);
        this.setRootLevel(rootLevel);
        this.setFilePattern(filePattern);
    }

    public LogConfigurator(String fileName, int maxBackupSize, long maxFileSize, String filePattern, Level rootLevel) {
        this(fileName, rootLevel, filePattern);
        this.setMaxBackupSize(maxBackupSize);
        this.setMaxFileSize(maxFileSize);
    }

    public void configure() {
        Logger root = Logger.getRootLogger();
        if (this.isResetConfiguration()) {
            LogManager.getLoggerRepository().resetConfiguration();
        }
        LogLog.setInternalDebugging((boolean)this.isInternalDebugging());
        if (this.isUseFileAppender()) {
            this.configureFileAppender();
        }
        if (this.isUseLogCatAppender()) {
            this.configureLogCatAppender();
        }
        root.setLevel(this.getRootLevel());
    }

    public void setLevel(String loggerName, Level level) {
        Logger.getLogger((String)loggerName).setLevel(level);
    }

    private void configureFileAppender() {
        Logger root = Logger.getRootLogger();
        PatternLayout fileLayout = new PatternLayout(this.getFilePattern());
        if (this.isDailyRollingMode()) {
            DailyRollingFileAppender dailyRollingFileAppender;
            try {
                dailyRollingFileAppender = new DailyRollingFileAppender((Layout)fileLayout, this.getFileName(), this.getDatePattern());
            }
            catch (IOException e) {
                throw new RuntimeException("Exception configuring log system", e);
            }
            dailyRollingFileAppender.setImmediateFlush(this.isImmediateFlush());
            dailyRollingFileAppender.setMaximumFileSize(this.getMaxFileSize());
            dailyRollingFileAppender.setMaxBackupIndex(this.getMaxBackupSize());
            dailyRollingFileAppender.setMaxBackupDays(this.getMaxBackupDays());
            if (this.isAsyncFileAppender()) {
                AsyncAppender asyncAppender = new AsyncAppender();
                asyncAppender.addAppender((Appender)dailyRollingFileAppender);
                root.addAppender((Appender)asyncAppender);
            } else {
                root.addAppender((Appender)dailyRollingFileAppender);
            }
        } else {
            RollingFileAppender rollingFileAppender;
            try {
                rollingFileAppender = new RollingFileAppender((Layout)fileLayout, this.getFileName());
            }
            catch (IOException e) {
                throw new RuntimeException("Exception configuring log system", e);
            }
            rollingFileAppender.setMaxBackupIndex(this.getMaxBackupSize());
            rollingFileAppender.setMaximumFileSize(this.getMaxFileSize());
            rollingFileAppender.setImmediateFlush(this.isImmediateFlush());
            if (this.isAsyncFileAppender()) {
                AsyncAppender asyncAppender = new AsyncAppender();
                asyncAppender.addAppender((Appender)rollingFileAppender);
                root.addAppender((Appender)asyncAppender);
            } else {
                root.addAppender((Appender)rollingFileAppender);
            }
        }
    }

    private void configureLogCatAppender() {
        Logger root = Logger.getRootLogger();
        PatternLayout logCatLayout = new PatternLayout(this.getLogCatPattern());
        LogCatAppender logCatAppender = new LogCatAppender((Layout)logCatLayout);
        root.addAppender((Appender)logCatAppender);
    }

    public Level getRootLevel() {
        return this.rootLevel;
    }

    public void setRootLevel(Level level) {
        this.rootLevel = level;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    public String getLogCatPattern() {
        return this.logCatPattern;
    }

    public void setLogCatPattern(String logCatPattern) {
        this.logCatPattern = logCatPattern;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getMaxBackupSize() {
        return this.maxBackupSize;
    }

    public void setMaxBackupSize(int maxBackupSize) {
        this.maxBackupSize = maxBackupSize;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    public void setImmediateFlush(boolean immediateFlush) {
        this.immediateFlush = immediateFlush;
    }

    public boolean isUseFileAppender() {
        return this.useFileAppender;
    }

    public void setUseFileAppender(boolean useFileAppender) {
        this.useFileAppender = useFileAppender;
    }

    public boolean isUseLogCatAppender() {
        return this.useLogCatAppender;
    }

    public void setUseLogCatAppender(boolean useLogCatAppender) {
        this.useLogCatAppender = useLogCatAppender;
    }

    public void setResetConfiguration(boolean resetConfiguration) {
        this.resetConfiguration = resetConfiguration;
    }

    public boolean isResetConfiguration() {
        return this.resetConfiguration;
    }

    public void setInternalDebugging(boolean internalDebugging) {
        this.internalDebugging = internalDebugging;
    }

    public boolean isInternalDebugging() {
        return this.internalDebugging;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    public boolean isAsyncFileAppender() {
        return this.asyncFileAppender;
    }

    public void setAsyncFileAppender(boolean asyncFileAppender) {
        this.asyncFileAppender = asyncFileAppender;
    }

    public int getMaxBackupDays() {
        return this.maxBackupDays;
    }

    public void setMaxBackupDays(int maxBackupDays) {
        this.maxBackupDays = maxBackupDays;
    }

    public boolean isDailyRollingMode() {
        return this.dailyRollingMode;
    }

    public void setDailyRollingMode(boolean dailyRollingMode) {
        this.dailyRollingMode = dailyRollingMode;
    }
}

