/*
 * Decompiled with CFR 0.152.
 */
package android.support.log4j;

import android.util.Log;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;

public class LogCatAppender
extends AppenderSkeleton {
    private static final int MAX_TAG_LENGTH = 23;
    private static final int MAX_LOG_LENGTH = 3072;
    protected Layout tagLayout;

    public LogCatAppender(Layout messageLayout, Layout tagLayout) {
        this.tagLayout = tagLayout;
        this.setLayout(messageLayout);
    }

    public LogCatAppender(Layout messageLayout) {
        this(messageLayout, (Layout)new PatternLayout("%c"));
    }

    public LogCatAppender() {
        this((Layout)new PatternLayout("%m%n"));
    }

    protected void append(LoggingEvent le) {
        switch (le.getLevel().toInt()) {
            case 5000: {
                if (le.getThrowableInformation() != null) {
                    this.log(2, this.getTag(le), this.getLayout().format(le) + '\n' + Log.getStackTraceString((Throwable)le.getThrowableInformation().getThrowable()));
                    break;
                }
                this.log(2, this.getTag(le), this.getLayout().format(le));
                break;
            }
            case 10000: {
                if (le.getThrowableInformation() != null) {
                    this.log(3, this.getTag(le), this.getLayout().format(le) + '\n' + Log.getStackTraceString((Throwable)le.getThrowableInformation().getThrowable()));
                    break;
                }
                this.log(3, this.getTag(le), this.getLayout().format(le));
                break;
            }
            case 20000: {
                if (le.getThrowableInformation() != null) {
                    this.log(4, this.getTag(le), this.getLayout().format(le) + '\n' + Log.getStackTraceString((Throwable)le.getThrowableInformation().getThrowable()));
                    break;
                }
                this.log(4, this.getTag(le), this.getLayout().format(le));
                break;
            }
            case 30000: {
                if (le.getThrowableInformation() != null) {
                    this.log(5, this.getTag(le), this.getLayout().format(le) + '\n' + Log.getStackTraceString((Throwable)le.getThrowableInformation().getThrowable()));
                    break;
                }
                this.log(5, this.getTag(le), this.getLayout().format(le));
                break;
            }
            case 40000: {
                if (le.getThrowableInformation() != null) {
                    this.log(6, this.getTag(le), this.getLayout().format(le) + '\n' + Log.getStackTraceString((Throwable)le.getThrowableInformation().getThrowable()));
                    break;
                }
                this.log(6, this.getTag(le), this.getLayout().format(le));
                break;
            }
            case 50000: {
                if (le.getThrowableInformation() != null) {
                    Log.wtf((String)this.getTag(le), (String)this.getLayout().format(le), (Throwable)le.getThrowableInformation().getThrowable());
                    break;
                }
                Log.wtf((String)this.getTag(le), (String)this.getLayout().format(le));
            }
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }

    public Layout getTagLayout() {
        return this.tagLayout;
    }

    public void setTagLayout(Layout tagLayout) {
        this.tagLayout = tagLayout;
    }

    private String getTag(LoggingEvent event) {
        String tag = this.getTagLayout().format(event);
        if (tag.length() > 23) {
            tag = tag.substring(0, 22) + "*";
        }
        return tag;
    }

    private void log(int priority, String tag, String msg) {
        if (msg.length() > 3072) {
            int length = msg.length();
            for (int fromIndex = 0; fromIndex <= length; fromIndex += 3072) {
                int toIndex = Math.min(fromIndex + 3072, length);
                String subString = msg.substring(fromIndex, toIndex);
                Log.println((int)priority, (String)tag, (String)subString);
            }
        } else {
            Log.println((int)priority, (String)tag, (String)msg);
        }
    }
}

