/*
 * Decompiled with CFR 0.152.
 */
package android.support.log4j;

import android.support.log4j.RollingCalendar;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;

public class DailyRollingFileAppender
extends FileAppender {
    static final int TOP_OF_TROUBLE = -1;
    static final int TOP_OF_MINUTE = 0;
    static final int TOP_OF_HOUR = 1;
    static final int HALF_DAY = 2;
    static final int TOP_OF_DAY = 3;
    static final int TOP_OF_WEEK = 4;
    static final int TOP_OF_MONTH = 5;
    private String datePattern = "'.'yyyy-MM-dd";
    private String scheduledFilename;
    private long nextCheck = System.currentTimeMillis() - 1L;
    Date now = new Date();
    SimpleDateFormat sdf;
    RollingCalendar rc = new RollingCalendar();
    int checkPeriod = -1;
    static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
    protected long maxFileSize = 0xA00000L;
    protected int maxBackupIndex = 1;
    private long nextRollover = 0L;
    private int maxBackupDays = -1;
    private long maxBackupPeriod = 0L;
    private long previousCheck = 0L;

    public DailyRollingFileAppender() {
    }

    public DailyRollingFileAppender(Layout layout, String filename, String datePattern) throws IOException {
        super(layout, filename, true);
        this.datePattern = datePattern;
        this.activateOptions();
    }

    public void setDatePattern(String pattern) {
        this.datePattern = pattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void activateOptions() {
        super.activateOptions();
        if (this.datePattern != null && this.fileName != null) {
            this.now.setTime(System.currentTimeMillis());
            this.sdf = new SimpleDateFormat(this.datePattern);
            int type = this.computeCheckPeriod();
            this.printPeriodicity(type);
            this.rc.setType(type);
            File file = new File(this.fileName);
            this.scheduledFilename = this.fileName + this.sdf.format(new Date(file.lastModified()));
        } else {
            LogLog.error((String)("Either File or DatePattern options are not set for appender [" + this.name + "]."));
        }
    }

    void printPeriodicity(int type) {
        switch (type) {
            case 0: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled every minute."));
                break;
            }
            case 1: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled on top of every hour."));
                break;
            }
            case 2: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at midday and midnight."));
                break;
            }
            case 3: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at midnight."));
                break;
            }
            case 4: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at start of week."));
                break;
            }
            case 5: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at start of every month."));
                break;
            }
            default: {
                LogLog.warn((String)("Unknown periodicity for appender [" + this.name + "]."));
            }
        }
    }

    int computeCheckPeriod() {
        RollingCalendar rollingCalendar = new RollingCalendar(gmtTimeZone, Locale.getDefault());
        Date epoch = new Date(0L);
        if (this.datePattern != null) {
            for (int i = 0; i <= 5; ++i) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
                simpleDateFormat.setTimeZone(gmtTimeZone);
                String r0 = simpleDateFormat.format(epoch);
                rollingCalendar.setType(i);
                Date next = new Date(rollingCalendar.getNextCheckMillis(epoch));
                String r1 = simpleDateFormat.format(next);
                if (r0 == null || r1 == null || r0.equals(r1)) continue;
                return i;
            }
        }
        return -1;
    }

    void rollOver() throws IOException {
        File file;
        boolean result;
        if (this.datePattern == null) {
            this.errorHandler.error("Missing DatePattern option in rollOver().");
            return;
        }
        String datedFilename = this.fileName + this.sdf.format(this.now);
        if (this.scheduledFilename.equals(datedFilename)) {
            return;
        }
        this.closeFile();
        File target = new File(this.scheduledFilename);
        if (target.exists()) {
            target.delete();
        }
        if (result = (file = new File(this.fileName)).renameTo(target)) {
            LogLog.debug((String)(this.fileName + " -> " + this.scheduledFilename));
        } else {
            LogLog.error((String)("Failed to rename [" + this.fileName + "] to [" + this.scheduledFilename + "]."));
        }
        try {
            this.setFile(this.fileName, true, this.bufferedIO, this.bufferSize);
            this.nextRollover = 0L;
        }
        catch (IOException e) {
            this.errorHandler.error("setFile(" + this.fileName + ", true) call failed.");
        }
        this.scheduledFilename = datedFilename;
    }

    void rollOverForBackup() {
        if (this.qw != null) {
            long size = ((CountingQuietWriter)this.qw).getCount();
            LogLog.debug((String)("rolling over count=" + size));
            this.nextRollover = size + this.maxFileSize;
        }
        LogLog.debug((String)("maxBackupIndex=" + this.maxBackupIndex));
        boolean renameSucceeded = true;
        if (this.maxBackupIndex > 0) {
            File target;
            File file = new File(this.scheduledFilename + '.' + this.maxBackupIndex);
            if (file.exists()) {
                renameSucceeded = file.delete();
            }
            for (int i = this.maxBackupIndex - 1; i >= 1 && renameSucceeded; --i) {
                file = new File(this.scheduledFilename + "." + i);
                if (!file.exists()) continue;
                target = new File(this.scheduledFilename + '.' + (i + 1));
                LogLog.debug((String)("Renaming file " + file + " to " + target));
                renameSucceeded = file.renameTo(target);
            }
            if (renameSucceeded) {
                target = new File(this.scheduledFilename + "." + 1);
                this.closeFile();
                file = new File(this.fileName);
                LogLog.debug((String)("Renaming file " + file + " to " + target));
                renameSucceeded = file.renameTo(target);
                if (!renameSucceeded) {
                    try {
                        this.setFile(this.fileName, true, this.bufferedIO, this.bufferSize);
                    }
                    catch (IOException e) {
                        if (e instanceof InterruptedIOException) {
                            Thread.currentThread().interrupt();
                        }
                        LogLog.error((String)("setFile(" + this.fileName + ", true) call failed."), (Throwable)e);
                    }
                }
            }
        }
        if (renameSucceeded) {
            try {
                this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
                this.nextRollover = 0L;
            }
            catch (IOException e) {
                if (e instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                LogLog.error((String)("setFile(" + this.fileName + ", false) call failed."), (Throwable)e);
            }
        }
    }

    public long getMaximumFileSize() {
        return this.maxFileSize;
    }

    public int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    public void setMaxBackupIndex(int maxBackups) {
        this.maxBackupIndex = maxBackups;
    }

    public void setMaximumFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setMaxFileSize(String value) {
        this.maxFileSize = OptionConverter.toFileSize((String)value, (long)(this.maxFileSize + 1L));
    }

    public int getMaxBackupDays() {
        return this.maxBackupDays;
    }

    public void setMaxBackupDays(int maxBackupDays) {
        if (maxBackupDays > 0) {
            this.maxBackupDays = maxBackupDays;
            this.maxBackupPeriod = maxBackupDays * 24 * 60 * 60 * 1000;
        } else {
            this.maxBackupDays = -1;
            this.maxBackupPeriod = 0L;
        }
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new CountingQuietWriter(writer, this.errorHandler);
    }

    public synchronized void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        super.setFile(fileName, append, bufferedIO, bufferSize);
        if (append && this.qw != null) {
            File f = new File(fileName);
            ((CountingQuietWriter)this.qw).setCount(f.length());
        }
    }

    protected void subAppend(LoggingEvent event) {
        long size;
        File file;
        long n = System.currentTimeMillis();
        if (n >= this.nextCheck) {
            this.now.setTime(n);
            this.nextCheck = this.rc.getNextCheckMillis(this.now);
            try {
                this.rollOver();
            }
            catch (IOException ioe) {
                if (ioe instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                LogLog.error((String)"rollOver() failed.", (Throwable)ioe);
            }
        }
        if (this.maxBackupPeriod > 0L && n - this.previousCheck >= this.maxBackupPeriod) {
            this.now.setTime(n);
            this.previousCheck = this.rc.getPreviousCheckMillis(this.now, this.maxBackupDays);
            this.scheduleCleanTask();
        }
        if (!(file = new File(this.fileName)).exists()) {
            try {
                this.setFile(this.fileName, true, this.bufferedIO, this.bufferSize);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.qw != null) {
            super.subAppend(event);
        }
        if (this.fileName != null && this.qw != null && (size = ((CountingQuietWriter)this.qw).getCount()) >= this.maxFileSize && size >= this.nextRollover) {
            this.rollOverForBackup();
        }
    }

    private void scheduleCleanTask() {
        File[] files;
        String datePattern = this.getDatePattern();
        String fileName = this.getFile();
        SimpleDateFormat sdf = new SimpleDateFormat(datePattern);
        String deletePrefix = fileName + sdf.format(this.rc.getPreviousCheckDate(this.now, this.maxBackupDays));
        File file = new File(fileName);
        File parent = file.getParentFile();
        if (parent.exists() && parent.isDirectory() && (files = parent.listFiles()) != null && files.length > 0) {
            for (File f : files) {
                if (f.getAbsolutePath().equals(fileName) || f.getAbsolutePath().compareTo(deletePrefix) >= 0) continue;
                f.delete();
            }
        }
    }
}

