/*
 * Decompiled with CFR 0.152.
 */
package similar.io.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Shader;
import android.support.annotation.IdRes;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.animation.LinearInterpolator;
import similar.io.view.R;

public class SimilarLoadingView
extends View {
    private static final int MAX_PROGRESS_VALUE = 1450;
    private static final int PROGRESS_TIME = 2000;
    private static final int MAX_ALPHA = 70;
    private Paint paint = new Paint();
    private double hexHeight;
    private double hexWidth;
    private double hexPadding = 0.0;
    private float actualProgress = 0.0f;
    private int maxAlpha = 70;
    @IdRes
    private int loadingDrawable;
    private int animationTime = 2000;
    private int color;
    private int cornerRadius;
    private AnimatorSet indeterminateAnimator;

    public SimilarLoadingView(Context context) {
        super(context);
    }

    public SimilarLoadingView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SimilarLoadingView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initAttributes(attrs, defStyle);
        this.initPaint();
    }

    private void initAttributes(AttributeSet attrs, int defStyle) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.SimilarLoadingView, defStyle, 0);
        this.animationTime = a.getInteger(R.styleable.SimilarLoadingView_similar_animDuration, 2000);
        this.maxAlpha = a.getInteger(R.styleable.SimilarLoadingView_similar_maxAlpha, 70);
        this.color = a.getColor(R.styleable.SimilarLoadingView_similar_color, -16777216);
        this.cornerRadius = a.getInteger(R.styleable.SimilarLoadingView_similar_cornerRadius, 0);
        this.loadingDrawable = a.getResourceId(R.styleable.SimilarLoadingView_similar_loadingDrawable, -1);
        a.recycle();
    }

    private void initPaint() {
        this.paint.setAlpha(0);
        this.paint.setPathEffect((PathEffect)new CornerPathEffect((float)this.cornerRadius));
        this.paint.setColor(this.color);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setAntiAlias(true);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.startAnimation();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopAnimation();
    }

    public void setVisibility(int visibility) {
        int currentVisibility = this.getVisibility();
        super.setVisibility(visibility);
        if (visibility != currentVisibility) {
            if (visibility == 0) {
                this.resetAnimator();
            } else if (visibility == 8 || visibility == 4) {
                this.stopAnimation();
            }
        }
    }

    private void startAnimation() {
        this.resetAnimator();
    }

    private void stopAnimation() {
        this.actualProgress = 0.0f;
        if (this.indeterminateAnimator != null) {
            this.indeterminateAnimator.cancel();
            this.indeterminateAnimator = null;
        }
    }

    private void resetAnimator() {
        if (this.indeterminateAnimator != null && this.indeterminateAnimator.isRunning()) {
            this.indeterminateAnimator.cancel();
        }
        ValueAnimator progressAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1450.0f});
        progressAnimator.setDuration((long)this.animationTime);
        progressAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        progressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                SimilarLoadingView.this.actualProgress = ((Float)animation.getAnimatedValue()).floatValue();
                SimilarLoadingView.this.invalidate();
            }
        });
        this.indeterminateAnimator = new AnimatorSet();
        this.indeterminateAnimator.play((Animator)progressAnimator);
        this.indeterminateAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
            boolean wasCancelled = false;

            public void onAnimationCancel(Animator animation) {
                this.wasCancelled = true;
            }

            public void onAnimationEnd(Animator animation) {
                if (!this.wasCancelled) {
                    SimilarLoadingView.this.resetAnimator();
                }
            }
        });
        this.indeterminateAnimator.start();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        double viewWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        double viewHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        double widthC = (double)SimilarLoadingView.convertDpToPixel(200.0f, this.getRootView().getContext()) / viewWidth;
        double heightC = (double)SimilarLoadingView.convertDpToPixel(220.0f, this.getRootView().getContext()) / viewHeight;
        this.hexWidth = viewWidth / 4.125 * widthC;
        this.hexHeight = viewHeight / 3.5 * heightC;
        this.hexPadding = viewHeight / 23.0;
        this.setMeasuredDimension((int)(viewWidth / 1.385 * widthC), (int)(viewHeight * heightC));
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(Canvas canvas) {
        this.paint.setShader((Shader)new BitmapShader(BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.getHexagonImage(1)), Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        Path hexPath = this.hiveRect(this.hexWidth / 2.0, this.hexPadding, this.hexWidth * 3.0 / 2.0, this.hexHeight + this.hexPadding);
        this.paint.setAlpha(this.getAlpha(1, this.actualProgress));
        canvas.drawPath(hexPath, this.paint);
        hexPath = this.hiveRect(this.hexWidth * 3.0 / 2.0, this.hexPadding, this.hexWidth * 5.0 / 2.0, this.hexHeight + this.hexPadding);
        this.paint.setAlpha(this.getAlpha(2, this.actualProgress));
        canvas.drawPath(hexPath, this.paint);
        hexPath = this.hiveRect(0.0, this.hexHeight * 3.0 / 4.0 + this.hexPadding, this.hexWidth, this.hexHeight * 7.0 / 4.0 + this.hexPadding);
        this.paint.setAlpha(this.getAlpha(6, this.actualProgress));
        canvas.drawPath(hexPath, this.paint);
        hexPath = this.hiveRect(this.hexWidth, this.hexHeight * 3.0 / 4.0 + this.hexPadding, this.hexWidth * 2.0, this.hexHeight * 7.0 / 4.0 + this.hexPadding);
        this.paint.setAlpha(this.getAlpha(7, this.actualProgress));
        canvas.drawPath(hexPath, this.paint);
        hexPath = this.hiveRect(this.hexWidth * 2.0, this.hexHeight * 3.0 / 4.0 + this.hexPadding, this.hexWidth * 3.0, this.hexHeight * 7.0 / 4.0 + this.hexPadding);
        this.paint.setAlpha(this.getAlpha(3, this.actualProgress));
        canvas.drawPath(hexPath, this.paint);
        hexPath = this.hiveRect(this.hexWidth / 2.0, this.hexHeight * 6.0 / 4.0 + this.hexPadding, this.hexWidth * 3.0 / 2.0, this.hexHeight * 10.0 / 4.0 + this.hexPadding);
        this.paint.setAlpha(this.getAlpha(5, this.actualProgress));
        canvas.drawPath(hexPath, this.paint);
        hexPath = this.hiveRect(this.hexWidth * 3.0 / 2.0, this.hexHeight * 6.0 / 4.0 + this.hexPadding, this.hexWidth * 5.0 / 2.0, this.hexHeight * 10.0 / 4.0 + this.hexPadding);
        this.paint.setAlpha(this.getAlpha(4, this.actualProgress));
        canvas.drawPath(hexPath, this.paint);
    }

    private int getHexagonImage(int position) {
        if (position <= 1) {
            return this.loadingDrawable;
        }
        return this.color;
    }

    private int getAlpha(int num, float progress) {
        float alpha;
        if (progress > (float)(num * 100)) {
            alpha = this.maxAlpha;
        } else {
            int min = (num - 1) * 100;
            alpha = progress - (float)min > 0.0f ? progress - (float)min : 0.0f;
            alpha = alpha * (float)this.maxAlpha / 100.0f;
        }
        if (progress > 700.0f) {
            float fadeProgress = progress - 700.0f;
            if (fadeProgress > (float)(num * 100)) {
                alpha = 0.0f;
            } else {
                int min = (num - 1) * 100;
                alpha = fadeProgress - (float)min > 0.0f ? fadeProgress - (float)min : 0.0f;
                alpha = (float)this.maxAlpha - alpha * (float)this.maxAlpha / 100.0f;
            }
        }
        if (progress > 1400.0f) {
            alpha = 0.0f;
        }
        return (int)alpha;
    }

    private Path hiveRect(double left, double top, double right, double bottom) {
        Path path = new Path();
        double height = Math.abs(bottom - top);
        double width = Math.abs(right - left);
        double r = width > height ? height : width;
        float x = (float)((right - left) / 2.0 + left);
        float y = (float)top;
        int edge = (int)((r /= 2.0) * Math.sqrt(3.0) / 2.0);
        path.moveTo(x, y);
        y = (float)((double)y + r / 2.0);
        path.lineTo(x += (float)edge, y);
        y = (float)((double)y + r);
        path.lineTo(x, y);
        y = (float)((double)y + r / 2.0);
        path.lineTo(x -= (float)edge, y);
        y = (float)((double)y - r / 2.0);
        path.lineTo(x -= (float)edge, y);
        y = (float)((double)y - r);
        path.lineTo(x, y);
        path.close();
        return path;
    }

    public static float convertDpToPixel(float dp, Context context) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return px;
    }
}

