/*
 * Decompiled with CFR 0.152.
 */
package si.virag.fuzzydateformatter;

import android.content.Context;
import android.content.res.Resources;
import java.util.Calendar;
import java.util.Date;
import si.virag.fuzzydateformatter.R;

public class FuzzyDateTimeFormatter {
    private static final int SECONDS = 1;
    private static final int MINUTES = 60;
    private static final int HOURS = 3600;
    private static final int DAYS = 86400;
    private static final int WEEKS = 604800;
    private static final int MONTHS = 2419200;
    private static final int YEARS = 29030400;

    public static String getTimeAgo(Context context, Date date) {
        int beforeSeconds = (int)(date.getTime() / 1000L);
        int nowSeconds = (int)(Calendar.getInstance().getTimeInMillis() / 1000L);
        int timeDifference = nowSeconds - beforeSeconds;
        Resources res = context.getResources();
        if (timeDifference < 60) {
            return res.getQuantityString(R.plurals.fuzzydatetime__seconds_ago, timeDifference, new Object[]{timeDifference});
        }
        if (timeDifference < 3600) {
            return res.getQuantityString(R.plurals.fuzzydatetime__minutes_ago, timeDifference / 60, new Object[]{timeDifference / 60});
        }
        if (timeDifference < 86400) {
            return res.getQuantityString(R.plurals.fuzzydatetime__hours_ago, timeDifference / 3600, new Object[]{timeDifference / 3600});
        }
        if (timeDifference < 604800) {
            return res.getQuantityString(R.plurals.fuzzydatetime__days_ago, timeDifference / 86400, new Object[]{timeDifference / 86400});
        }
        if (timeDifference < 2419200) {
            return res.getQuantityString(R.plurals.fuzzydatetime__weeks_ago, timeDifference / 604800, new Object[]{timeDifference / 604800});
        }
        if (timeDifference < 29030400) {
            return res.getQuantityString(R.plurals.fuzzydatetime__months_ago, timeDifference / 2419200, new Object[]{timeDifference / 2419200});
        }
        return res.getQuantityString(R.plurals.fuzzydatetime__years_ago, timeDifference / 29030400, new Object[]{timeDifference / 29030400});
    }
}

