/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.animation.Animator;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.embedding.android.SplashScreen;

public final class DrawableSplashScreen
implements SplashScreen {
    private final Drawable drawable;
    private final ImageView.ScaleType scaleType;
    private final long crossfadeDurationInMillis;
    private DrawableSplashScreenView splashView;

    public DrawableSplashScreen(@NonNull Drawable drawable) {
        this(drawable, ImageView.ScaleType.FIT_XY, 500L);
    }

    public DrawableSplashScreen(@NonNull Drawable drawable, @NonNull ImageView.ScaleType scaleType, long crossfadeDurationInMillis) {
        this.drawable = drawable;
        this.scaleType = scaleType;
        this.crossfadeDurationInMillis = crossfadeDurationInMillis;
    }

    @Override
    @Nullable
    public View createSplashView(@NonNull Context context, @Nullable Bundle savedInstanceState) {
        this.splashView = new DrawableSplashScreenView(context);
        this.splashView.setSplashDrawable(this.drawable, this.scaleType);
        return this.splashView;
    }

    @Override
    public void transitionToFlutter(final @NonNull Runnable onTransitionComplete) {
        if (this.splashView == null) {
            onTransitionComplete.run();
            return;
        }
        this.splashView.animate().alpha(0.0f).setDuration(this.crossfadeDurationInMillis).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                onTransitionComplete.run();
            }

            public void onAnimationCancel(Animator animation) {
                onTransitionComplete.run();
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    public static class DrawableSplashScreenView
    extends ImageView {
        public DrawableSplashScreenView(@NonNull Context context) {
            this(context, null, 0);
        }

        public DrawableSplashScreenView(@NonNull Context context, @Nullable AttributeSet attrs) {
            this(context, attrs, 0);
        }

        public DrawableSplashScreenView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
            super(context, attrs, defStyleAttr);
        }

        public void setSplashDrawable(@Nullable Drawable drawable) {
            this.setSplashDrawable(drawable, ImageView.ScaleType.FIT_XY);
        }

        public void setSplashDrawable(@Nullable Drawable drawable, @NonNull ImageView.ScaleType scaleType) {
            this.setScaleType(scaleType);
            this.setImageDrawable(drawable);
        }
    }
}

