/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.common;

import android.util.Log;
import io.flutter.plugin.common.MessageCodec;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StandardMessageCodec
implements MessageCodec<Object> {
    private static final String TAG = "StandardMessageCodec#";
    public static final StandardMessageCodec INSTANCE = new StandardMessageCodec();
    private static final boolean LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    private static final Charset UTF8 = Charset.forName("UTF8");
    private static final byte NULL = 0;
    private static final byte TRUE = 1;
    private static final byte FALSE = 2;
    private static final byte INT = 3;
    private static final byte LONG = 4;
    private static final byte BIGINT = 5;
    private static final byte DOUBLE = 6;
    private static final byte STRING = 7;
    private static final byte BYTE_ARRAY = 8;
    private static final byte INT_ARRAY = 9;
    private static final byte LONG_ARRAY = 10;
    private static final byte DOUBLE_ARRAY = 11;
    private static final byte LIST = 12;
    private static final byte MAP = 13;

    @Override
    public ByteBuffer encodeMessage(Object message) {
        if (message == null) {
            return null;
        }
        ExposedByteArrayOutputStream stream = new ExposedByteArrayOutputStream();
        this.writeValue(stream, message);
        ByteBuffer buffer = ByteBuffer.allocateDirect(stream.size());
        buffer.put(stream.buffer(), 0, stream.size());
        return buffer;
    }

    @Override
    public Object decodeMessage(ByteBuffer message) {
        if (message == null) {
            return null;
        }
        message.order(ByteOrder.nativeOrder());
        Object value = this.readValue(message);
        if (message.hasRemaining()) {
            throw new IllegalArgumentException("Message corrupted");
        }
        return value;
    }

    protected static final void writeSize(ByteArrayOutputStream stream, int value) {
        if (0 > value) {
            Log.e((String)TAG, (String)"Attempted to write a negative size.");
        }
        if (value < 254) {
            stream.write(value);
        } else if (value <= 65535) {
            stream.write(254);
            StandardMessageCodec.writeChar(stream, value);
        } else {
            stream.write(255);
            StandardMessageCodec.writeInt(stream, value);
        }
    }

    protected static final void writeChar(ByteArrayOutputStream stream, int value) {
        if (LITTLE_ENDIAN) {
            stream.write(value);
            stream.write(value >>> 8);
        } else {
            stream.write(value >>> 8);
            stream.write(value);
        }
    }

    protected static final void writeInt(ByteArrayOutputStream stream, int value) {
        if (LITTLE_ENDIAN) {
            stream.write(value);
            stream.write(value >>> 8);
            stream.write(value >>> 16);
            stream.write(value >>> 24);
        } else {
            stream.write(value >>> 24);
            stream.write(value >>> 16);
            stream.write(value >>> 8);
            stream.write(value);
        }
    }

    protected static final void writeLong(ByteArrayOutputStream stream, long value) {
        if (LITTLE_ENDIAN) {
            stream.write((byte)value);
            stream.write((byte)(value >>> 8));
            stream.write((byte)(value >>> 16));
            stream.write((byte)(value >>> 24));
            stream.write((byte)(value >>> 32));
            stream.write((byte)(value >>> 40));
            stream.write((byte)(value >>> 48));
            stream.write((byte)(value >>> 56));
        } else {
            stream.write((byte)(value >>> 56));
            stream.write((byte)(value >>> 48));
            stream.write((byte)(value >>> 40));
            stream.write((byte)(value >>> 32));
            stream.write((byte)(value >>> 24));
            stream.write((byte)(value >>> 16));
            stream.write((byte)(value >>> 8));
            stream.write((byte)value);
        }
    }

    protected static final void writeDouble(ByteArrayOutputStream stream, double value) {
        StandardMessageCodec.writeLong(stream, Double.doubleToLongBits(value));
    }

    protected static final void writeBytes(ByteArrayOutputStream stream, byte[] bytes) {
        StandardMessageCodec.writeSize(stream, bytes.length);
        stream.write(bytes, 0, bytes.length);
    }

    protected static final void writeAlignment(ByteArrayOutputStream stream, int alignment) {
        int mod = stream.size() % alignment;
        if (mod != 0) {
            for (int i = 0; i < alignment - mod; ++i) {
                stream.write(0);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeValue(ByteArrayOutputStream stream, Object value) {
        if (value == null || value.equals(null)) {
            stream.write(0);
            return;
        } else if (value == Boolean.TRUE) {
            stream.write(1);
            return;
        } else if (value == Boolean.FALSE) {
            stream.write(2);
            return;
        } else if (value instanceof Number) {
            if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
                stream.write(3);
                StandardMessageCodec.writeInt(stream, ((Number)value).intValue());
                return;
            } else if (value instanceof Long) {
                stream.write(4);
                StandardMessageCodec.writeLong(stream, (Long)value);
                return;
            } else if (value instanceof Float || value instanceof Double) {
                stream.write(6);
                StandardMessageCodec.writeAlignment(stream, 8);
                StandardMessageCodec.writeDouble(stream, ((Number)value).doubleValue());
                return;
            } else {
                if (!(value instanceof BigInteger)) throw new IllegalArgumentException("Unsupported Number type: " + value.getClass());
                stream.write(5);
                StandardMessageCodec.writeBytes(stream, ((BigInteger)value).toString(16).getBytes(UTF8));
            }
            return;
        } else if (value instanceof String) {
            stream.write(7);
            StandardMessageCodec.writeBytes(stream, ((String)value).getBytes(UTF8));
            return;
        } else if (value instanceof byte[]) {
            stream.write(8);
            StandardMessageCodec.writeBytes(stream, (byte[])value);
            return;
        } else if (value instanceof int[]) {
            stream.write(9);
            int[] array = (int[])value;
            StandardMessageCodec.writeSize(stream, array.length);
            StandardMessageCodec.writeAlignment(stream, 4);
            for (int n : array) {
                StandardMessageCodec.writeInt(stream, n);
            }
            return;
        } else if (value instanceof long[]) {
            stream.write(10);
            long[] array = (long[])value;
            StandardMessageCodec.writeSize(stream, array.length);
            StandardMessageCodec.writeAlignment(stream, 8);
            for (long n : array) {
                StandardMessageCodec.writeLong(stream, n);
            }
            return;
        } else if (value instanceof double[]) {
            stream.write(11);
            double[] array = (double[])value;
            StandardMessageCodec.writeSize(stream, array.length);
            StandardMessageCodec.writeAlignment(stream, 8);
            for (double d : array) {
                StandardMessageCodec.writeDouble(stream, d);
            }
            return;
        } else if (value instanceof List) {
            stream.write(12);
            List list = (List)value;
            StandardMessageCodec.writeSize(stream, list.size());
            for (Object o : list) {
                this.writeValue(stream, o);
            }
            return;
        } else {
            if (!(value instanceof Map)) throw new IllegalArgumentException("Unsupported value: " + value);
            stream.write(13);
            Map map = (Map)value;
            StandardMessageCodec.writeSize(stream, map.size());
            for (Map.Entry entry : map.entrySet()) {
                this.writeValue(stream, entry.getKey());
                this.writeValue(stream, entry.getValue());
            }
        }
    }

    protected static final int readSize(ByteBuffer buffer) {
        if (!buffer.hasRemaining()) {
            throw new IllegalArgumentException("Message corrupted");
        }
        int value = buffer.get() & 0xFF;
        if (value < 254) {
            return value;
        }
        if (value == 254) {
            return buffer.getChar();
        }
        return buffer.getInt();
    }

    protected static final byte[] readBytes(ByteBuffer buffer) {
        int length = StandardMessageCodec.readSize(buffer);
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return bytes;
    }

    protected static final void readAlignment(ByteBuffer buffer, int alignment) {
        int mod = buffer.position() % alignment;
        if (mod != 0) {
            buffer.position(buffer.position() + alignment - mod);
        }
    }

    protected final Object readValue(ByteBuffer buffer) {
        if (!buffer.hasRemaining()) {
            throw new IllegalArgumentException("Message corrupted");
        }
        byte type = buffer.get();
        return this.readValueOfType(type, buffer);
    }

    protected Object readValueOfType(byte type, ByteBuffer buffer) {
        Object result;
        switch (type) {
            case 0: {
                result = null;
                break;
            }
            case 1: {
                result = true;
                break;
            }
            case 2: {
                result = false;
                break;
            }
            case 3: {
                result = buffer.getInt();
                break;
            }
            case 4: {
                result = buffer.getLong();
                break;
            }
            case 5: {
                byte[] hex = StandardMessageCodec.readBytes(buffer);
                result = new BigInteger(new String(hex, UTF8), 16);
                break;
            }
            case 6: {
                StandardMessageCodec.readAlignment(buffer, 8);
                result = buffer.getDouble();
                break;
            }
            case 7: {
                byte[] bytes = StandardMessageCodec.readBytes(buffer);
                result = new String(bytes, UTF8);
                break;
            }
            case 8: {
                result = StandardMessageCodec.readBytes(buffer);
                break;
            }
            case 9: {
                int length = StandardMessageCodec.readSize(buffer);
                int[] array = new int[length];
                StandardMessageCodec.readAlignment(buffer, 4);
                buffer.asIntBuffer().get(array);
                result = array;
                buffer.position(buffer.position() + 4 * length);
                break;
            }
            case 10: {
                int length = StandardMessageCodec.readSize(buffer);
                long[] array = new long[length];
                StandardMessageCodec.readAlignment(buffer, 8);
                buffer.asLongBuffer().get(array);
                result = array;
                buffer.position(buffer.position() + 8 * length);
                break;
            }
            case 11: {
                int length = StandardMessageCodec.readSize(buffer);
                double[] array = new double[length];
                StandardMessageCodec.readAlignment(buffer, 8);
                buffer.asDoubleBuffer().get(array);
                result = array;
                buffer.position(buffer.position() + 8 * length);
                break;
            }
            case 12: {
                int size = StandardMessageCodec.readSize(buffer);
                ArrayList<Object> list = new ArrayList<Object>(size);
                for (int i = 0; i < size; ++i) {
                    list.add(this.readValue(buffer));
                }
                result = list;
                break;
            }
            case 13: {
                int size = StandardMessageCodec.readSize(buffer);
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                for (int i = 0; i < size; ++i) {
                    map.put(this.readValue(buffer), this.readValue(buffer));
                }
                result = map;
                break;
            }
            default: {
                throw new IllegalArgumentException("Message corrupted");
            }
        }
        return result;
    }

    static final class ExposedByteArrayOutputStream
    extends ByteArrayOutputStream {
        ExposedByteArrayOutputStream() {
        }

        byte[] buffer() {
            return this.buf;
        }
    }
}

