/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.urllauncher;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.embedding.engine.plugins.activity.ActivityAware;
import io.flutter.embedding.engine.plugins.activity.ActivityPluginBinding;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.PluginRegistry;
import io.flutter.plugins.urllauncher.MethodCallHandlerImpl;
import io.flutter.plugins.urllauncher.UrlLauncher;

public final class UrlLauncherPlugin
implements FlutterPlugin,
ActivityAware {
    private static final String TAG = "UrlLauncherPlugin";
    @Nullable
    private MethodCallHandlerImpl methodCallHandler;
    @Nullable
    private UrlLauncher urlLauncher;

    public static void registerWith(PluginRegistry.Registrar registrar) {
        MethodCallHandlerImpl handler = new MethodCallHandlerImpl(new UrlLauncher(registrar.context(), registrar.activity()));
        handler.startListening(registrar.messenger());
    }

    public void onAttachedToEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.urlLauncher = new UrlLauncher(binding.getApplicationContext(), null);
        this.methodCallHandler = new MethodCallHandlerImpl(this.urlLauncher);
        this.methodCallHandler.startListening((BinaryMessenger)binding.getFlutterEngine().getDartExecutor());
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        if (this.methodCallHandler == null) {
            Log.wtf((String)TAG, (String)"Already detached from the engine.");
            return;
        }
        this.methodCallHandler.stopListening();
        this.methodCallHandler = null;
        this.urlLauncher = null;
    }

    public void onAttachedToActivity(@NonNull ActivityPluginBinding binding) {
        if (this.methodCallHandler == null) {
            Log.wtf((String)TAG, (String)"urlLauncher was never set.");
            return;
        }
        this.urlLauncher.setActivity(binding.getActivity());
    }

    public void onDetachedFromActivity() {
        if (this.methodCallHandler == null) {
            Log.wtf((String)TAG, (String)"urlLauncher was never set.");
            return;
        }
        this.urlLauncher.setActivity(null);
    }

    public void onDetachedFromActivityForConfigChanges() {
        this.onDetachedFromActivity();
    }

    public void onReattachedToActivityForConfigChanges(@NonNull ActivityPluginBinding binding) {
        this.onAttachedToActivity(binding);
    }
}

