/*
 * Decompiled with CFR 0.152.
 */
package se.vgregion.portal.rss.client.service;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.rometools.fetcher.FeedFetcher;
import org.rometools.fetcher.FetcherException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import se.vgregion.portal.rss.blacklist.BlackList;
import se.vgregion.portal.rss.client.service.RssFetcherService;

@Service
public class RssFetcherServiceImpl
implements RssFetcherService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RssFetcherServiceImpl.class);
    private final BlackList<String> feedBlackList;
    private final FeedFetcher feedFetcher;

    @Autowired
    public RssFetcherServiceImpl(FeedFetcher feedFetcher, BlackList<String> blackList) {
        this.feedFetcher = feedFetcher;
        this.feedBlackList = blackList;
    }

    @Override
    public List<SyndFeed> getRssFeeds(Set<String> set) throws FeedException, IOException, FetcherException {
        ArrayList<SyndFeed> arrayList = new ArrayList<SyndFeed>();
        if (set != null) {
            for (String string : set) {
                if (StringUtils.isBlank((String)string) || this.feedBlackList.contains(string)) continue;
                try {
                    URL uRL = new URL(string);
                    SyndFeed syndFeed = this.feedFetcher.retrieveFeed(uRL);
                    arrayList.add(syndFeed);
                }
                catch (ConnectException connectException) {
                    this.feedBlackList.add(string);
                    LOGGER.error("Failed to fetch feed [{}], received error [{}]", (Object)string, (Object)connectException.getMessage());
                }
            }
        }
        return arrayList;
    }
}

