/*
 * Decompiled with CFR 0.152.
 */
package se.vgregion.portal.rss.blacklist;

import java.net.ConnectException;
import java.net.URL;
import java.util.TimerTask;
import org.rometools.fetcher.FeedFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.vgregion.portal.rss.blacklist.BlackList;

public class FeedBlackListCleaner
extends TimerTask {
    private static final Logger LOG = LoggerFactory.getLogger(FeedBlackListCleaner.class);
    private BlackList<String> blackList;
    private final FeedFetcher feedFetcher;

    public FeedBlackListCleaner(FeedFetcher feedFetcher, BlackList<String> blackList) {
        this.feedFetcher = feedFetcher;
        this.blackList = blackList;
    }

    @Override
    public void run() {
        for (String string : this.blackList.items()) {
            try {
                this.feedFetcher.retrieveFeed(new URL(string));
                this.blackList.remove(string);
                LOG.info("Remove {} from BlackList", (Object)string);
            }
            catch (ConnectException connectException) {
                LOG.info("{} will stay on BlackList", (Object)string);
            }
            catch (Exception exception) {
                this.blackList.remove(string);
                LOG.info("Remove {} from BlackList", (Object)string);
            }
        }
    }
}

