/*
 * Decompiled with CFR 0.152.
 */
package se.thinkcode.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamConsumer
implements Runnable {
    private static final int SLEEPING_TIME = 20;
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private boolean stop;

    public StreamConsumer(InputStream inputStream, OutputStream outputStream) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.stop = false;
    }

    @Override
    public void run() {
        try {
            while (!this.stop) {
                while (this.inputStream.available() > 0 && !this.stop) {
                    int read = this.inputStream.read();
                    this.flushIfDot((char)read);
                    this.outputStream.write(read);
                }
                this.outputStream.flush();
                Thread.sleep(20L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void flushIfDot(char read) throws IOException {
        String dot = Character.toString(read);
        if (".".equals(dot)) {
            this.outputStream.flush();
        }
    }

    public void stopProcessing() {
        this.stop = true;
    }
}

