/*
 * Decompiled with CFR 0.152.
 */
package se.thinkcode;

import java.io.File;
import org.gradle.api.DefaultTask;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import se.thinkcode.CommandLineBuilder;
import se.thinkcode.CucumberExtension;
import se.thinkcode.stream.StreamConsumer;

public class CucumberTask
extends DefaultTask {
    @Option(option="cucumber-help", description="Get Cucumber help")
    String help;
    @Option(option="cucumber-version", description="Get Cucumber version")
    String version;
    @Option(option="i18n", description="List keywords for in a particular language")
    String i18n;
    @Option(option="threads", description="Number of threads to run tests under. Defaults to 1.")
    String threads;
    @Option(option="glue", description="Package to load glue code (step definitions, hooks and plugins) from. E.g: com.example.app")
    String glue;
    @Option(option="plugin", description="Register one or many plugins. --plugin=\"pretty, progress\" specifies two plugins See Cucumber help for more details, --cucumber-help=please")
    String plugin;
    @Option(option="tags", description="Only run scenarios tagged with tags matching TAG_EXPRESSION.")
    String tags;
    @Option(option="name", description="Only run scenarios whose names match REGEXP.")
    String name;
    @Option(option="cucumber-dry-run", description="Skip execution of glue code.")
    String dryRun;
    @Option(option="monochrome", description="Don't colour terminal output.")
    String monochrome;
    @Option(option="strict", description="Treat undefined and pending steps as errors.")
    String strict;
    @Option(option="snippets", description="Naming convention for generated snippets. Defaults to underscore.")
    String snippets;
    @Option(option="wip", description="Fail if there are any passing scenarios.")
    String wip;
    @Option(option="shorten", description="Shorten the command line by shortening the classpath. Defaults to none. Possible values are [manifest, argfile]")
    String shorten;
    @Option(option="featurePath", description="The feature or features to execute. Defaults to src/test/resources See Cucumber help for more details, --cucumber-help=please")
    String featurePath;

    public void setHelp(String help) {
        this.help = help;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setI18n(String i18n) {
        this.i18n = i18n;
    }

    public void setThreads(String threads) {
        this.threads = threads;
    }

    public void setGlue(String glue) {
        this.glue = glue;
    }

    public void setPlugin(String plugins) {
        this.plugin = plugins;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDryRun(String dryRun) {
        this.dryRun = dryRun;
    }

    public void setMonochrome(String monochrome) {
        this.monochrome = monochrome;
    }

    public void setStrict(String strict) {
        this.strict = strict;
    }

    public void setSnippets(String snippets) {
        this.snippets = snippets;
    }

    public void setWip(String wip) {
        this.wip = wip;
    }

    public void setShorten(String shorten) {
        this.shorten = shorten;
    }

    public void setFeaturePath(String featurePath) {
        this.featurePath = featurePath;
    }

    public CucumberTask() {
        this.setGroup("Cucumber");
        this.setDescription("Execute Cucumber-JVM from Gradle");
    }

    @TaskAction
    public void runCucumber() {
        CucumberExtension extension = (CucumberExtension)this.getProject().getExtensions().findByType(CucumberExtension.class);
        if (extension == null) {
            extension = new CucumberExtension();
        }
        try {
            CommandLineBuilder cliBuilder = new CommandLineBuilder();
            File projectDir = this.getProject().getProjectDir();
            String[] command = cliBuilder.buildCommand(extension, this.getClasspath(), this, projectDir);
            this.debugCommand(command);
            this.execute(command);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void debugCommand(String[] command) {
        Logger logger = this.getLogger();
        if (logger.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            for (String s : command) {
                builder.append(s);
                builder.append(" ");
            }
            System.out.println();
            System.out.println("Cucumber command:");
            System.out.println(builder);
            System.out.println();
        }
    }

    private void execute(String[] command) {
        int exitValue;
        try {
            Process process = new ProcessBuilder(new String[0]).command(command).start();
            StreamConsumer stdOut = new StreamConsumer(process.getInputStream(), System.out);
            new Thread(stdOut).start();
            StreamConsumer stdErr = new StreamConsumer(process.getErrorStream(), System.err);
            new Thread(stdErr).start();
            exitValue = process.waitFor();
            stdOut.stopProcessing();
            stdErr.stopProcessing();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (exitValue != 0) {
            throw new RuntimeException("The execution failed");
        }
    }

    private String getClasspath() {
        SourceSetContainer sourceSets = ((JavaPluginConvention)this.getProject().getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
        for (SourceSet sourceSet : sourceSets) {
            if (!"test".equals(sourceSet.getName())) continue;
            return sourceSet.getRuntimeClasspath().getAsPath();
        }
        throw new RuntimeException("The test classpath was not found");
    }
}

