/*
 * Decompiled with CFR 0.152.
 */
package se.thinkcode;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import se.thinkcode.ClasspathShortener;
import se.thinkcode.CucumberExtension;
import se.thinkcode.CucumberTask;
import se.thinkcode.PluginParser;

class CommandLineBuilder {
    CommandLineBuilder() {
    }

    String[] buildCommand(CucumberExtension extension, String classpath, CucumberTask commandLineOptions, File projectDir) {
        String main = extension.main;
        ArrayList<String> command = new ArrayList<String>();
        command.add("java");
        this.addSystemProperties(command);
        this.addClasspath(command, classpath, extension, commandLineOptions);
        command.add(main);
        this.addHelp(command, extension, commandLineOptions);
        this.addVersion(command, extension, commandLineOptions);
        this.addI18N(command, extension, commandLineOptions);
        this.addThreads(command, extension, commandLineOptions);
        this.addGlue(command, extension, commandLineOptions);
        this.addPlugin(command, extension, commandLineOptions);
        this.addTags(command, extension, commandLineOptions);
        this.addName(command, extension, commandLineOptions);
        this.addDryRun(command, extension, commandLineOptions);
        this.addMonochrome(command, extension, commandLineOptions);
        this.addStrict(command, extension, commandLineOptions);
        this.addSnippets(command, extension, commandLineOptions);
        this.addWip(command, extension, commandLineOptions);
        this.addFeaturePath(command, extension, commandLineOptions, projectDir);
        return command.toArray(new String[0]);
    }

    private void addSystemProperties(List<String> command) {
        Properties props = System.getProperties();
        for (Object key : props.keySet()) {
            String keyValue = (String)key;
            String value = props.getProperty(keyValue);
            String systemProperty = "-D" + keyValue + "=" + value;
            command.add(systemProperty);
        }
    }

    private void addClasspath(List<String> command, String classpath, CucumberExtension extension, CucumberTask commandLineOption) {
        String shorten = null;
        if (commandLineOption.shorten != null) {
            shorten = commandLineOption.shorten;
        } else if (!extension.shorten.isEmpty()) {
            shorten = extension.shorten;
        }
        if ("manifest".equals(shorten)) {
            String tempDir = commandLineOption.getTemporaryDir().getAbsolutePath();
            command.add("-cp");
            command.add(ClasspathShortener.createManifestJarFile(classpath, tempDir));
            return;
        }
        if ("argfile".equals(shorten)) {
            String tempDir = commandLineOption.getTemporaryDir().getAbsolutePath();
            command.add("@" + ClasspathShortener.createJava9argFile(classpath, tempDir));
            return;
        }
        command.add("-cp");
        command.add(classpath);
    }

    private void addHelp(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.help != null) {
            command.add("--help");
            return;
        }
        if (!extension.help.isEmpty()) {
            command.add("--help");
        }
    }

    private void addVersion(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.version != null) {
            command.add("--version");
            return;
        }
        if (!extension.version.isEmpty()) {
            command.add("--version");
        }
    }

    private void addI18N(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.i18n != null) {
            command.add("--i18n");
            command.add(commandLineOption.i18n);
            return;
        }
        if (!extension.i18n.isEmpty()) {
            command.add("--i18n");
            command.add(extension.i18n);
        }
    }

    private void addThreads(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.threads != null) {
            command.add("--threads");
            command.add(commandLineOption.threads);
            return;
        }
        if (!extension.threads.isEmpty()) {
            command.add("--threads");
            command.add(extension.threads);
        }
    }

    private void addGlue(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.glue != null) {
            String[] glues;
            for (String glue : glues = PluginParser.parse(commandLineOption.glue)) {
                command.add("--glue");
                command.add(glue);
            }
            return;
        }
        if (!extension.glue.isEmpty()) {
            command.add("--glue");
            command.add(extension.glue);
        }
        if (extension.extraGlues.length > 0) {
            for (String glue : extension.extraGlues) {
                command.add("--glue");
                command.add(glue);
            }
        }
    }

    private void addPlugin(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.plugin != null) {
            String[] plugins;
            for (String plugin : plugins = PluginParser.parse(commandLineOption.plugin)) {
                command.add("--plugin");
                command.add(plugin);
            }
            return;
        }
        if (extension.plugin.length > 0) {
            for (String plugin : extension.plugin) {
                command.add("--plugin");
                command.add(plugin);
            }
        }
    }

    private void addTags(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.tags != null) {
            command.add("--tags");
            command.add(commandLineOption.tags);
            return;
        }
        if (!extension.tags.isEmpty()) {
            command.add("--tags");
            command.add(extension.tags);
        }
    }

    private void addName(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.name != null) {
            command.add("--name");
            command.add(commandLineOption.name);
            return;
        }
        if (!extension.name.isEmpty()) {
            command.add("--name");
            command.add(extension.name);
        }
    }

    private void addDryRun(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.dryRun != null) {
            command.add("--dry-run");
            return;
        }
        if (!extension.dryRun.isEmpty()) {
            command.add("--dry-run");
        }
    }

    private void addMonochrome(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.monochrome != null) {
            command.add("--monochrome");
            command.add(commandLineOption.monochrome);
            return;
        }
        if (!extension.monochrome.isEmpty()) {
            command.add("--monochrome");
            command.add(extension.monochrome);
        }
    }

    private void addStrict(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.strict != null) {
            command.add("--strict");
            return;
        }
        if (!extension.strict.isEmpty()) {
            command.add("--strict");
        }
    }

    private void addSnippets(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.snippets != null) {
            command.add("--snippets");
            command.add(commandLineOption.snippets);
            return;
        }
        if (!extension.snippets.isEmpty()) {
            command.add("--snippets");
            command.add(extension.snippets);
        }
    }

    private void addWip(List<String> command, CucumberExtension extension, CucumberTask commandLineOption) {
        if (commandLineOption.wip != null) {
            command.add("--wip");
            return;
        }
        if (!extension.wip.isEmpty()) {
            command.add("--wip");
        }
    }

    private void addFeaturePath(List<String> command, CucumberExtension extension, CucumberTask commandLineOption, File projectDir) {
        String featurePath = commandLineOption.featurePath;
        if (featurePath != null) {
            boolean absolutePath = new File(featurePath).isAbsolute();
            if (!absolutePath) {
                String root = this.getAbsoluteRoot(projectDir);
                featurePath = root + featurePath;
            }
            command.add(featurePath);
            return;
        }
        String root = this.getAbsoluteRoot(projectDir);
        featurePath = root + extension.featurePath;
        command.add(featurePath);
    }

    private String getAbsoluteRoot(File projectDir) {
        return projectDir.getAbsolutePath() + File.separator;
    }
}

