/*
 * Decompiled with CFR 0.152.
 */
package se.thinkcode;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;

public class ClasspathShortener {
    public static String createJava9argFile(String classpath, String tempDir) {
        String argFile = Paths.get(tempDir, "cucumber_runner_argFile").toString();
        try {
            FileOutputStream file = new FileOutputStream(argFile);
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)file, StandardCharsets.UTF_8));
            writer.println("-classpath\n" + classpath);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(String.format("Cannot write temporary file on %s,\nexception message:\n %s", argFile, e.getMessage()));
        }
        return argFile;
    }

    public static String createManifestJarFile(String classpath, String tempDir) {
        String manifestJarFile = Paths.get(tempDir, "cucumber_runner_manifest.jar").toString();
        Manifest manifest = ClasspathShortener.createManifestWithClasspath(classpath);
        try {
            JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(manifestJarFile), manifest);
            jarOutputStream.putNextEntry(new ZipEntry("META-INF/"));
            jarOutputStream.close();
            return manifestJarFile;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(String.format("Cannot write temporary file on %s,\nexception message:\n %s", manifestJarFile, e.getMessage()));
        }
    }

    private static Manifest createManifestWithClasspath(String classpath) {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        if (classpath != null) {
            String classpathAttr = Arrays.stream(classpath.split(";")).map(ClasspathShortener::getURL).collect(Collectors.joining(" "));
            attributes.putValue("Class-Path", classpathAttr);
        }
        return manifest;
    }

    private static String getURL(String path) {
        try {
            return Paths.get(path, new String[0]).toUri().toURL().toString();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

