/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.opensaml.xmlsec.signature.support.provider.padding;

import com.google.common.primitives.Bytes;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Arrays;
import se.swedenconnect.opensaml.xmlsec.signature.support.provider.padding.MGF;

public class MGF1
implements MGF {
    private MessageDigest digest;
    private int digestSize;

    public MGF1(MessageDigest digest) {
        this.digest = digest;
        this.digestSize = this.digest.getDigestLength();
    }

    @Override
    public byte[] getMask(byte[] seed, int length) {
        byte[] maskBytes = new byte[]{};
        int n = (int)Math.ceil((double)length / (double)this.digestSize);
        for (int i = 0; i < n; ++i) {
            byte[] counterBytes = MGF1.getCounterBytes(i);
            byte[] maskFragment = this.concatenateAndHash(seed, counterBytes);
            maskBytes = Bytes.concat((byte[][])new byte[][]{maskBytes, maskFragment});
        }
        return Arrays.copyOf(maskBytes, length);
    }

    private byte[] concatenateAndHash(byte[] seed, byte[] counter) {
        this.digest.reset();
        this.digest.update(seed, 0, seed.length);
        this.digest.update(counter, 0, counter.length);
        return this.digest.digest();
    }

    private static byte[] getCounterBytes(int counter) {
        BigInteger c = BigInteger.valueOf(counter);
        int requiredBytes = (int)Math.ceil((double)c.bitLength() / 8.0);
        byte[] counterBytes = c.toByteArray();
        int byteLen = counterBytes.length;
        if (byteLen > requiredBytes) {
            counterBytes = Arrays.copyOfRange(counterBytes, 1, byteLen);
        }
        for (int i = 0; i < 4 - requiredBytes; ++i) {
            counterBytes = Bytes.concat((byte[][])new byte[][]{{0}, counterBytes});
        }
        return counterBytes;
    }
}

