/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.opensaml.xmlsec.signature.support.provider;

import java.net.URL;
import java.net.URLClassLoader;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.Initializer;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.swedenconnect.opensaml.xmlsec.signature.support.provider.ExtendedSignerProvider;

public class ExtendedSignerProviderInitializer
implements Initializer {
    private Logger log = LoggerFactory.getLogger(ExtendedSignerProviderInitializer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() throws InitializationException {
        URL jarPath;
        this.log.debug("Setting up {} as system signer provider ...", (Object)ExtendedSignerProvider.class.getSimpleName());
        try {
            jarPath = ExtendedSignerProvider.class.getProtectionDomain().getCodeSource().getLocation();
            this.log.debug("Will load extended signer provider from {}", (Object)jarPath.toExternalForm());
        }
        catch (NullPointerException | SecurityException e) {
            this.log.error("Failed to get path to extended signer provider", (Throwable)e);
            this.log.warn("Can not guarantee that {} will be used", (Object)ExtendedSignerProvider.class.getSimpleName());
            return;
        }
        ClassLoader defaultLoader = null;
        try {
            defaultLoader = Thread.currentThread().getContextClassLoader();
            URLClassLoader customLoader = new URLClassLoader(new URL[]{jarPath}, defaultLoader != null ? defaultLoader : ClassLoader.getSystemClassLoader());
            Thread.currentThread().setContextClassLoader(customLoader);
            try {
                Signer.signObject(null);
            }
            catch (NullPointerException | ConstraintViolationException | SignatureException throwable) {
                // empty catch block
            }
            this.log.info("{} has now been cached as the signer provider used by the {} class", (Object)ExtendedSignerProvider.class.getName(), (Object)Signer.class.getName());
        }
        catch (SecurityException e) {
            this.log.error("Failed to modify classpath for installation of extended signer provider", (Throwable)e);
            this.log.warn("Can not guarantee that {} will be used", (Object)ExtendedSignerProvider.class.getSimpleName());
        }
        finally {
            if (defaultLoader != null) {
                try {
                    Thread.currentThread().setContextClassLoader(defaultLoader);
                }
                catch (SecurityException securityException) {}
            }
        }
    }
}

