/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.opensaml.xmlsec.signature.support.provider;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.bouncycastle.util.encoders.Base64;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.xmlsec.algorithm.AlgorithmDescriptor;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.algorithm.SignatureAlgorithm;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.impl.SignatureImpl;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.impl.provider.ApacheSantuarioSignerProviderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NodeList;
import se.swedenconnect.opensaml.xmlsec.algorithm.ExtendedAlgorithmSupport;
import se.swedenconnect.opensaml.xmlsec.signature.support.provider.padding.SCPSSPadding;

public class ExtendedSignerProvider
extends ApacheSantuarioSignerProviderImpl {
    private static final Logger log = LoggerFactory.getLogger(ExtendedSignerProvider.class);
    private boolean disabled = Boolean.parseBoolean(System.getProperty("se.swedenconnect.opensaml.xmlsec.signature.support.provider.ExtendedSignerProvider.disabled", "false"));

    public ExtendedSignerProvider() {
        if (this.disabled) {
            log.info("The ExtendedSignerProvider has been disabled - {} will be active", (Object)ApacheSantuarioSignerProviderImpl.class.getName());
        }
    }

    public void signObject(Signature signature) throws SignatureException {
        if (this.disabled) {
            super.signObject(signature);
            return;
        }
        Constraint.isNotNull((Object)signature, (String)"Signature cannot be null");
        Constraint.isTrue((boolean)Init.isInitialized(), (String)"Apache XML security library is not initialized");
        XMLSignature xmlSignature = ((SignatureImpl)signature).getXMLSignature();
        Credential signingCredential = signature.getSigningCredential();
        Key signingKey = CredentialSupport.extractSigningKey((Credential)signingCredential);
        if (!this.shouldOverride(signingKey, xmlSignature)) {
            super.signObject(signature);
            return;
        }
        SignedInfo signedInfo = xmlSignature.getSignedInfo();
        if (signedInfo == null) {
            String msg = "Bad XMLSignature - missing SignedInfo";
            log.error("Bad XMLSignature - missing SignedInfo");
            throw new SignatureException("Bad XMLSignature - missing SignedInfo");
        }
        log.debug("{} executing during signature with {}", (Object)ExtendedSignerProvider.class.getSimpleName(), (Object)signedInfo.getSignatureMethodURI());
        try {
            signedInfo.generateDigestValues();
            byte[] signedInfoBytes = signedInfo.getCanonicalizedOctetStream();
            RSAPublicKey publicKey = (RSAPublicKey)signingCredential.getPublicKey();
            if (publicKey == null) {
                String msg = "No RSA public key found in signing credential";
                log.error("No RSA public key found in signing credential");
                throw new SignatureException("No RSA public key found in signing credential");
            }
            SCPSSPadding pssPadding = new SCPSSPadding(this.getDigest(signedInfo.getSignatureMethodURI()), publicKey.getModulus().bitLength());
            byte[] emBytes = pssPadding.getPaddingFromMessage(signedInfoBytes);
            Cipher cipher = Cipher.getInstance("RSA/ECB/NoPadding");
            cipher.init(2, signingKey);
            byte[] signatureBytes = cipher.doFinal(emBytes);
            NodeList signatureValue = xmlSignature.getElement().getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureValue");
            if (signatureValue.getLength() == 0) {
                throw new SignatureException("Invalid XMLSignature - missing SignatureValue element");
            }
            signatureValue.item(0).setTextContent(Base64.toBase64String((byte[])signatureBytes));
        }
        catch (XMLSecurityException e) {
            log.error("Failure during digest calculation - {}", (Object)e.getMessage(), (Object)e);
            throw new SignatureException("Failure during digest calculation", (Exception)((Object)e));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            log.error("RSA transform failed - {}", (Object)e.getMessage(), (Object)e);
            throw new SignatureException("RSA signature failure", (Exception)e);
        }
    }

    private boolean shouldOverride(Key signingKey, XMLSignature xmlSignature) {
        if (signingKey != null && !"RSA".equals(signingKey.getAlgorithm())) {
            return false;
        }
        if (this.isTestMode()) {
            return true;
        }
        String signingAlgorithm = xmlSignature != null && xmlSignature.getSignedInfo() != null ? xmlSignature.getSignedInfo().getSignatureMethodURI() : null;
        return signingKey != null && "RSA".equals(signingKey.getAlgorithm()) && "sun.security.pkcs11.P11Key$P11PrivateKey".equals(signingKey.getClass().getName()) && ExtendedAlgorithmSupport.isRSAPSS(signingAlgorithm);
    }

    private MessageDigest getDigest(String signatureAlgorithm) throws NoSuchAlgorithmException {
        AlgorithmRegistry algorithmRegistry = AlgorithmSupport.getGlobalAlgorithmRegistry();
        AlgorithmDescriptor algorithmDescriptor = algorithmRegistry.get(signatureAlgorithm);
        if (algorithmDescriptor == null || !AlgorithmDescriptor.AlgorithmType.Signature.equals((Object)algorithmDescriptor.getType())) {
            log.error("Unsupported signature algorithm - {}", (Object)signatureAlgorithm);
            throw new NoSuchAlgorithmException("Unsupported signature algorithm - " + signatureAlgorithm);
        }
        String jcaDigest = ((SignatureAlgorithm)SignatureAlgorithm.class.cast(algorithmDescriptor)).getDigest();
        log.debug("Getting digest algorithm for '{}'", (Object)jcaDigest);
        return MessageDigest.getInstance(jcaDigest);
    }

    private boolean isTestMode() {
        return Boolean.parseBoolean(System.getProperty("se.swedenconnect.opensaml.xmlsec.signature.support.provider.ExtendedSignerProvider.testmode", "false"));
    }
}

