/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.opensaml.xmlsec.keyinfo.provider;

import java.security.interfaces.ECPrivateKey;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500Principal;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableX509DigestCredentialCriterion;
import org.opensaml.security.credential.criteria.impl.EvaluableX509SubjectKeyIdentifierCredentialCriterion;
import org.opensaml.security.credential.criteria.impl.EvaluableX509SubjectNameCredentialCriterion;
import org.opensaml.security.criteria.KeyAlgorithmCriterion;
import org.opensaml.security.criteria.KeyLengthCriterion;
import org.opensaml.security.x509.X509DigestCriterion;
import org.opensaml.security.x509.X509IssuerSerialCriterion;
import org.opensaml.security.x509.X509SubjectKeyIdentifierCriterion;
import org.opensaml.security.x509.X509SubjectNameCriterion;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.encryption.AgreementMethod;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.EncryptionMethod;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.CollectionKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoCredentialContext;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoResolutionContext;
import org.opensaml.xmlsec.keyinfo.impl.LocalKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.AbstractKeyInfoProvider;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.X509Data;
import org.opensaml.xmlsec.signature.X509Digest;
import org.opensaml.xmlsec.signature.X509IssuerSerial;
import org.opensaml.xmlsec.signature.X509SKI;
import org.opensaml.xmlsec.signature.X509SubjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.swedenconnect.opensaml.xmlsec.encryption.KeyDerivationMethod;
import se.swedenconnect.opensaml.xmlsec.encryption.support.ECDHSupport;
import se.swedenconnect.opensaml.xmlsec.keyinfo.provider.EvaluableX509CertificatesCredentialCriterion;

public class KeyAgreementMethodKeyInfoProvider
extends AbstractKeyInfoProvider {
    private static final Logger log = LoggerFactory.getLogger(KeyAgreementMethodKeyInfoProvider.class);
    private List<Credential> localCredentials = null;

    public KeyAgreementMethodKeyInfoProvider() {
        log.debug("KeyAgreementMethodKeyInfoProvider being created without local credentials - Will only function with LocalKeyInfoCredentialResolver");
    }

    public KeyAgreementMethodKeyInfoProvider(@Nonnull @ParameterName(name="credentials") List<Credential> credentials) {
        Constraint.isNotNull(credentials, (String)"Input credentials list cannot be null");
        this.localCredentials = credentials.stream().filter(c -> ECPrivateKey.class.isInstance(c.getPrivateKey())).collect(Collectors.toList());
        if (this.localCredentials.isEmpty()) {
            this.localCredentials = null;
        }
    }

    public boolean handles(XMLObject keyInfoChild) {
        if (AgreementMethod.class.isInstance(keyInfoChild)) {
            AgreementMethod am = (AgreementMethod)keyInfoChild;
            if ("http://www.w3.org/2009/xmlenc11#ECDH-ES".equals(am.getAlgorithm())) {
                KeyDerivationMethod kdm = KeyAgreementMethodKeyInfoProvider.getKeyDerivationMethod(am);
                if (kdm == null) {
                    log.info("No KeyDerivationMethod available for {}", (Object)"http://www.w3.org/2009/xmlenc11#ECDH-ES");
                    return false;
                }
                if ("http://www.w3.org/2009/xmlenc11#ConcatKDF".equals(kdm.getAlgorithm())) {
                    return true;
                }
                log.debug("KeyDerivationMethod {} is not supported for {}", (Object)kdm.getAlgorithm(), (Object)"http://www.w3.org/2009/xmlenc11#ECDH-ES");
                return false;
            }
            log.debug("{} does not handle {} agreement method", (Object)am.getAlgorithm());
            return false;
        }
        return false;
    }

    public Collection<Credential> process(KeyInfoCredentialResolver resolver, XMLObject keyInfoChild, CriteriaSet criteriaSet, KeyInfoResolutionContext kiContext) throws SecurityException {
        if (!this.handles(keyInfoChild)) {
            return null;
        }
        CollectionKeyInfoCredentialResolver ecCredentialsResolver = null;
        if (this.localCredentials != null) {
            ecCredentialsResolver = new CollectionKeyInfoCredentialResolver(this.localCredentials);
        } else if (LocalKeyInfoCredentialResolver.class.isInstance(resolver)) {
            ecCredentialsResolver = ((LocalKeyInfoCredentialResolver)resolver).getLocalCredentialResolver();
        } else {
            log.debug("KeyAgreementMethodKeyInfoProvider can not resolve any EC local credentials");
            return null;
        }
        AgreementMethod agreementMethod = (AgreementMethod)keyInfoChild;
        KeyAlgorithmCriterion keyAlgorithmCriterion = (KeyAlgorithmCriterion)criteriaSet.get(KeyAlgorithmCriterion.class);
        if (keyAlgorithmCriterion == null || keyAlgorithmCriterion.getKeyAlgorithm() == null) {
            log.error("Bad call to KeyAgreementMethodKeyInfoProvider - KeyAlgorithmCriterion is missing");
            throw new SecurityException("KeyAlgorithmCriterion is missing");
        }
        KeyLengthCriterion keyLengthCriterion = (KeyLengthCriterion)criteriaSet.get(KeyLengthCriterion.class);
        if (keyLengthCriterion == null) {
            log.debug("OpenSAML did not give us KeyLengthCriterion, trying to find EncryptionMethod->Algorithm ...");
            keyLengthCriterion = this.createKeyLengthCriterion(agreementMethod);
            if (keyLengthCriterion == null) {
                log.error("Bad call to KeyAgreementMethodKeyInfoProvider - KeyLengthCriterion is missing");
                throw new SecurityException("KeyLengthCriterion is missing");
            }
        }
        try {
            CriteriaSet ecCriteriaSet = this.buildCriteriaSet(agreementMethod);
            for (Credential ecCred : ecCredentialsResolver.resolve((Object)ecCriteriaSet)) {
                try {
                    SecretKey keyAgreementKey = ECDHSupport.getKeyAgreementKey(ecCred.getPrivateKey(), agreementMethod, keyAlgorithmCriterion.getKeyAlgorithm(), keyLengthCriterion.getKeyLength());
                    BasicCredential kakCred = new BasicCredential(keyAgreementKey);
                    KeyInfoCredentialContext credContext = this.buildCredentialContext(kiContext);
                    if (credContext != null) {
                        kakCred.getCredentialContextSet().add((Object)credContext);
                    }
                    LazySet credentialSet = new LazySet();
                    credentialSet.add((Object)kakCred);
                    return credentialSet;
                }
                catch (SecurityException e) {
                    log.error("Failed to get key agreement key - " + e.getMessage(), (Throwable)e);
                }
            }
            log.info("Could not derive a key agreement key - no matching credentials found");
            return null;
        }
        catch (ResolverException e) {
            log.error("Failed to resolve credential for ECDH key agreement", (Throwable)e);
            throw new SecurityException("Resolver error", (Exception)((Object)e));
        }
    }

    private CriteriaSet buildCriteriaSet(AgreementMethod agreementMethod) {
        CriteriaSet criterias = new CriteriaSet();
        if (agreementMethod.getRecipientKeyInfo() == null || agreementMethod.getRecipientKeyInfo().getX509Datas().isEmpty()) {
            return criterias;
        }
        X509Data x509data = (X509Data)agreementMethod.getRecipientKeyInfo().getX509Datas().get(0);
        try {
            X509IssuerSerial is;
            if (!x509data.getX509Certificates().isEmpty()) {
                criterias.add((Object)new EvaluableX509CertificatesCredentialCriterion(x509data.getX509Certificates()));
            }
            if (!x509data.getX509IssuerSerials().isEmpty() && (is = (X509IssuerSerial)x509data.getX509IssuerSerials().get(0)).getX509IssuerName() != null && is.getX509SerialNumber() != null) {
                criterias.add((Object)new X509IssuerSerialCriterion(new X500Principal(is.getX509IssuerName().getValue()), is.getX509SerialNumber().getValue()));
            }
            if (!x509data.getX509SKIs().isEmpty()) {
                X509SKI ski = (X509SKI)x509data.getX509SKIs().get(0);
                criterias.add((Object)new EvaluableX509SubjectKeyIdentifierCredentialCriterion(new X509SubjectKeyIdentifierCriterion(Base64.getDecoder().decode(ski.getValue()))));
            }
            if (!x509data.getX509SubjectNames().isEmpty()) {
                X509SubjectName sn = (X509SubjectName)x509data.getX509SubjectNames().get(0);
                criterias.add((Object)new EvaluableX509SubjectNameCredentialCriterion(new X509SubjectNameCriterion(new X500Principal(sn.getValue()))));
            }
            if (!x509data.getX509Digests().isEmpty()) {
                X509Digest digest = (X509Digest)x509data.getX509Digests().get(0);
                criterias.add((Object)new EvaluableX509DigestCredentialCriterion(new X509DigestCriterion(digest.getAlgorithm(), Base64.getDecoder().decode(digest.getValue()))));
            }
        }
        catch (Exception e) {
            log.error("Error during building of criteria set for KeyAgreementMethodKeyInfoProvider - {}", (Object)e.getMessage(), (Object)e);
        }
        return criterias;
    }

    private KeyLengthCriterion createKeyLengthCriterion(AgreementMethod agreementMethod) {
        Integer len;
        EncryptionMethod encryptionMethod = null;
        if (KeyInfo.class.isInstance(agreementMethod.getParent()) && EncryptedKey.class.isInstance(agreementMethod.getParent().getParent())) {
            encryptionMethod = ((EncryptedKey)agreementMethod.getParent().getParent()).getEncryptionMethod();
        }
        if (encryptionMethod == null) {
            return null;
        }
        if (encryptionMethod.getKeySize() != null && encryptionMethod.getKeySize().getValue() != null) {
            return new KeyLengthCriterion(encryptionMethod.getKeySize().getValue());
        }
        if (encryptionMethod.getAlgorithm() != null && (len = AlgorithmSupport.getKeyLength((String)encryptionMethod.getAlgorithm())) != null) {
            return new KeyLengthCriterion(len);
        }
        return null;
    }

    private static KeyDerivationMethod getKeyDerivationMethod(AgreementMethod agreementMethod) {
        List methods = agreementMethod.getUnknownXMLObjects(KeyDerivationMethod.DEFAULT_ELEMENT_NAME);
        if (methods.isEmpty()) {
            return null;
        }
        return (KeyDerivationMethod)methods.get(0);
    }
}

