/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.opensaml.xmlsec.keyinfo.provider;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.opensaml.security.x509.X509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluableX509CertificatesCredentialCriterion
implements EvaluableCredentialCriterion {
    private static final Logger log = LoggerFactory.getLogger(EvaluableX509CertificatesCredentialCriterion.class);
    private List<X509CertSelector> selectors;

    public EvaluableX509CertificatesCredentialCriterion(@Nonnull List<org.opensaml.xmlsec.signature.X509Certificate> certificates) {
        CertificateFactory factory;
        Constraint.isNotNull(certificates, (String)"certificates must not be null");
        this.selectors = new ArrayList<X509CertSelector>();
        try {
            factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        for (org.opensaml.xmlsec.signature.X509Certificate c : certificates) {
            try {
                X509CertSelector selector = new X509CertSelector();
                selector.setCertificate((X509Certificate)factory.generateCertificate(new ByteArrayInputStream(Base64Support.decode((String)c.getValue()))));
                this.selectors.add(selector);
            }
            catch (Exception e) {
                log.error("Failed to decode certificate", (Throwable)e);
            }
        }
    }

    public boolean apply(@Nullable Credential input) {
        if (input == null) {
            log.error("Credential input was null");
            return false;
        }
        if (!X509Credential.class.isInstance(input)) {
            log.info("Credential is not an X509Credential, cannot evaluate certificate criteria");
            return false;
        }
        X509Certificate entityCertificate = ((X509Credential)input).getEntityCertificate();
        if (entityCertificate == null) {
            log.info("X509Credential did not contain an entity certificate, cannot evaluate certificate criteria");
            return false;
        }
        for (X509CertSelector selector : this.selectors) {
            if (!selector.match(entityCertificate)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "EvaluableX509CertificatesCredentialCriterion [selectors=<contents not displayable>]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.selectors == null ? 0 : this.selectors.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EvaluableX509CertificatesCredentialCriterion other = (EvaluableX509CertificatesCredentialCriterion)obj;
        return !(this.selectors == null ? other.selectors != null : !this.selectors.equals(other.selectors));
    }
}

