/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.opensaml.xmlsec.keyinfo;

import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLRuntimeException;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.encryption.AgreementMethod;
import org.opensaml.xmlsec.encryption.OriginatorKeyInfo;
import org.opensaml.xmlsec.encryption.RecipientKeyInfo;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.swedenconnect.opensaml.security.credential.KeyAgreementCredential;
import se.swedenconnect.opensaml.xmlsec.keyinfo.ExtendedKeyInfoSupport;

public class KeyAgreementKeyInfoGeneratorFactory
extends X509KeyInfoGeneratorFactory {
    private final Logger log = LoggerFactory.getLogger(KeyAgreementKeyInfoGeneratorFactory.class);

    public boolean handles(@Nonnull Credential credential) {
        return credential instanceof KeyAgreementCredential;
    }

    public Class<? extends Credential> getCredentialType() {
        return KeyAgreementCredential.class;
    }

    @Nonnull
    public KeyInfoGenerator newInstance() {
        ExtendedX509Options _options = (ExtendedX509Options)this.getOptions();
        if (!_options.emitOriginatorKeyInfoPublicDEREncodedKeyValue && !_options.emitOriginatorKeyInfoPublicKeyValue) {
            this.log.error("Bad configuration - emitOriginatorKeyInfoPublicDEREncodedKeyValue or emitOriginatorKeyInfoPublicKeyValue must be set");
        }
        return new KeyAgreementKeyInfoGenerator(_options.clone());
    }

    public boolean emitOriginatorKeyInfoPublicKeyValue() {
        if (ExtendedX509Options.class.isInstance(this.getOptions())) {
            return ((ExtendedX509Options)this.getOptions()).emitOriginatorKeyInfoPublicKeyValue;
        }
        return false;
    }

    public void setEmitOriginatorKeyInfoPublicKeyValue(boolean value) {
        if (ExtendedX509Options.class.isInstance(this.getOptions())) {
            ((ExtendedX509Options)this.getOptions()).emitOriginatorKeyInfoPublicKeyValue = value;
        }
    }

    public boolean emitOriginatorKeyInfoPublicDEREncodedKeyValue() {
        if (ExtendedX509Options.class.isInstance(this.getOptions())) {
            return ((ExtendedX509Options)this.getOptions()).emitOriginatorKeyInfoPublicDEREncodedKeyValue;
        }
        return false;
    }

    public void setEmitOriginatorKeyInfoPublicDEREncodedKeyValue(boolean value) {
        if (ExtendedX509Options.class.isInstance(this.getOptions())) {
            ((ExtendedX509Options)this.getOptions()).emitOriginatorKeyInfoPublicDEREncodedKeyValue = value;
        }
    }

    protected X509KeyInfoGeneratorFactory.X509Options newOptions() {
        return new ExtendedX509Options();
    }

    public class KeyAgreementKeyInfoGenerator
    extends X509KeyInfoGeneratorFactory.X509KeyInfoGenerator {
        private final Logger log;

        protected KeyAgreementKeyInfoGenerator(X509KeyInfoGeneratorFactory.X509Options options) {
            super((X509KeyInfoGeneratorFactory)KeyAgreementKeyInfoGeneratorFactory.this, options);
            this.log = LoggerFactory.getLogger(KeyAgreementKeyInfoGenerator.class);
        }

        @Nullable
        public KeyInfo generate(@Nullable Credential credential) throws SecurityException {
            if (credential == null) {
                this.log.warn("KeyAgreementKeyInfoGenerator was passed a null credential");
                return null;
            }
            if (!KeyAgreementCredential.class.isInstance(credential)) {
                this.log.warn("KeyAgreementKeyInfoGenerator was passed a credential that was not an instance of KeyAgreementCredential: {}", (Object)credential.getClass().getName());
                return null;
            }
            KeyAgreementCredential kaCredential = (KeyAgreementCredential)((Object)KeyAgreementCredential.class.cast(credential));
            AgreementMethod am = (AgreementMethod)XMLObjectSupport.buildXMLObject((QName)AgreementMethod.DEFAULT_ELEMENT_NAME);
            am.setAlgorithm(kaCredential.getAgreementMethodAlgorithm());
            am.getUnknownXMLObjects().add(kaCredential.getKeyDerivationMethod());
            OriginatorKeyInfo oki = (OriginatorKeyInfo)XMLObjectSupport.buildXMLObject((QName)OriginatorKeyInfo.DEFAULT_ELEMENT_NAME);
            this.processSenderPublicKey(oki, kaCredential);
            am.setOriginatorKeyInfo(oki);
            KeyInfo toBeRki = super.generate(kaCredential.getPeerCredential());
            RecipientKeyInfo rki = this.cloneToRecipientKeyInfo(toBeRki);
            am.setRecipientKeyInfo(rki);
            KeyInfo keyInfo = (KeyInfo)XMLObjectSupport.buildXMLObject((QName)KeyInfo.DEFAULT_ELEMENT_NAME);
            keyInfo.getAgreementMethods().add(am);
            return keyInfo;
        }

        protected RecipientKeyInfo cloneToRecipientKeyInfo(KeyInfo keyInfo) {
            try {
                Element keyInfoElement = XMLObjectSupport.marshall((XMLObject)keyInfo);
                Document doc = XMLObjectProviderRegistrySupport.getParserPool().newDocument();
                Element clonedElement = (Element)doc.importNode(keyInfoElement, true);
                doc.appendChild(clonedElement);
                doc.renameNode(doc.getDocumentElement(), RecipientKeyInfo.DEFAULT_ELEMENT_NAME.getNamespaceURI(), RecipientKeyInfo.DEFAULT_ELEMENT_NAME.getPrefix() + ":" + RecipientKeyInfo.DEFAULT_ELEMENT_NAME.getLocalPart());
                RecipientKeyInfo rki = (RecipientKeyInfo)XMLObjectSupport.getUnmarshaller((QName)RecipientKeyInfo.DEFAULT_ELEMENT_NAME).unmarshall(doc.getDocumentElement());
                rki.releaseDOM();
                return rki;
            }
            catch (XMLParserException | MarshallingException | UnmarshallingException e) {
                throw new XMLRuntimeException("Failed to clone KeyInfo into RecipientKeyInfo", (Exception)e);
            }
        }

        protected void processPublicKey(KeyInfo keyInfo, Credential credential) throws SecurityException {
            if (credential.getPublicKey() != null) {
                if (KeyAgreementKeyInfoGeneratorFactory.this.emitPublicKeyValue()) {
                    ExtendedKeyInfoSupport.addPublicKey(keyInfo, credential.getPublicKey());
                }
                if (KeyAgreementKeyInfoGeneratorFactory.this.emitPublicDEREncodedKeyValue()) {
                    try {
                        KeyInfoSupport.addDEREncodedPublicKey((KeyInfo)keyInfo, (PublicKey)credential.getPublicKey());
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new SecurityException("Cannot DER-encode key, unsupported key algorithm", (Exception)e);
                    }
                    catch (InvalidKeySpecException e) {
                        throw new SecurityException("Cannot DER-encode key, invalid key specification", (Exception)e);
                    }
                }
            }
        }

        protected void processSenderPublicKey(OriginatorKeyInfo keyInfo, KeyAgreementCredential credential) throws SecurityException {
            if (credential.getSenderGeneratedPublicKey() != null) {
                if (KeyAgreementKeyInfoGeneratorFactory.this.emitOriginatorKeyInfoPublicKeyValue()) {
                    ExtendedKeyInfoSupport.addPublicKey((KeyInfo)keyInfo, credential.getSenderGeneratedPublicKey());
                }
                if (KeyAgreementKeyInfoGeneratorFactory.this.emitOriginatorKeyInfoPublicDEREncodedKeyValue()) {
                    try {
                        KeyInfoSupport.addDEREncodedPublicKey((KeyInfo)keyInfo, (PublicKey)credential.getSenderGeneratedPublicKey());
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new SecurityException("Cannot DER-encode key, unsupported key algorithm", (Exception)e);
                    }
                    catch (InvalidKeySpecException e) {
                        throw new SecurityException("Cannot DER-encode key, invalid key specification", (Exception)e);
                    }
                }
            }
        }
    }

    protected class ExtendedX509Options
    extends X509KeyInfoGeneratorFactory.X509Options {
        private boolean emitOriginatorKeyInfoPublicKeyValue;
        private boolean emitOriginatorKeyInfoPublicDEREncodedKeyValue;

        protected ExtendedX509Options() {
            super((X509KeyInfoGeneratorFactory)KeyAgreementKeyInfoGeneratorFactory.this);
        }

        protected X509KeyInfoGeneratorFactory.X509Options clone() {
            ExtendedX509Options clonedOptions = (ExtendedX509Options)super.clone();
            clonedOptions.emitOriginatorKeyInfoPublicKeyValue = this.emitOriginatorKeyInfoPublicKeyValue;
            clonedOptions.emitOriginatorKeyInfoPublicDEREncodedKeyValue = this.emitOriginatorKeyInfoPublicDEREncodedKeyValue;
            return clonedOptions;
        }
    }
}

