/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.opensaml.xmlsec.keyinfo;

import java.io.IOException;
import java.security.interfaces.ECPublicKey;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.DERBitString;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.security.SecurityException;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.signature.ECKeyValue;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.KeyValue;
import org.opensaml.xmlsec.signature.NamedCurve;
import org.opensaml.xmlsec.signature.PublicKey;

public class ExtendedKeyInfoSupport {
    public static void addPublicKey(@Nonnull KeyInfo keyInfo, @Nullable java.security.PublicKey pk) throws SecurityException {
        Constraint.isNotNull((Object)keyInfo, (String)"KeyInfo cannot be null");
        if (!ECPublicKey.class.isInstance(pk)) {
            KeyInfoSupport.addPublicKey((KeyInfo)keyInfo, (java.security.PublicKey)pk);
            return;
        }
        KeyValue keyValue = (KeyValue)XMLObjectSupport.buildXMLObject((QName)KeyValue.DEFAULT_ELEMENT_NAME);
        keyValue.setECKeyValue(ExtendedKeyInfoSupport.buildECKeyValue((ECPublicKey)pk));
        keyInfo.getKeyValues().add(keyValue);
    }

    @Nonnull
    public static ECKeyValue buildECKeyValue(@Nonnull ECPublicKey ecPubKey) throws SecurityException {
        Constraint.isNotNull((Object)ecPubKey, (String)"EC public key cannot be null");
        try {
            ECKeyValue ecKeyValue = (ECKeyValue)XMLObjectSupport.buildXMLObject((QName)ECKeyValue.DEFAULT_ELEMENT_NAME);
            ASN1StreamParser parser = new ASN1StreamParser(ecPubKey.getEncoded());
            ASN1Sequence seq = (ASN1Sequence)parser.readObject().toASN1Primitive();
            ASN1Sequence innerSeq = (ASN1Sequence)seq.getObjectAt(0).toASN1Primitive();
            ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)innerSeq.getObjectAt(1).toASN1Primitive();
            NamedCurve namedCurve = (NamedCurve)XMLObjectSupport.buildXMLObject((QName)NamedCurve.DEFAULT_ELEMENT_NAME);
            namedCurve.setURI("urn:oid:" + oid.getId());
            ecKeyValue.setNamedCurve(namedCurve);
            PublicKey publicKey = (PublicKey)XMLObjectSupport.buildXMLObject((QName)PublicKey.DEFAULT_ELEMENT_NAME);
            DERBitString key = (DERBitString)seq.getObjectAt(1).toASN1Primitive();
            publicKey.setValue(Base64Support.encode((byte[])key.getBytes(), (boolean)false));
            ecKeyValue.setPublicKey(publicKey);
            return ecKeyValue;
        }
        catch (IOException e) {
            throw new SecurityException("Invalid EC public key parameters", (Exception)e);
        }
    }

    private ExtendedKeyInfoSupport() {
    }
}

