/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.opensaml.xmlsec.encryption.support;

import com.google.common.base.Strings;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.MGF1ParameterSpec;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.encryption.EncryptionMethod;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLCipherInput;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.xmlsec.DecryptionParameters;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.EncryptedType;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import sun.security.rsa.RSAPadding;

public class Pkcs11Decrypter
extends Decrypter {
    private static final Logger log = LoggerFactory.getLogger(Pkcs11Decrypter.class);
    private boolean testMode = false;
    private KeyInfoCredentialResolver _kekResolver;

    public Pkcs11Decrypter(DecryptionParameters params) {
        super(params);
        this._kekResolver = params.getKEKKeyInfoCredentialResolver();
    }

    public Pkcs11Decrypter(KeyInfoCredentialResolver newResolver, KeyInfoCredentialResolver newKEKResolver, EncryptedKeyResolver newEncKeyResolver) {
        super(newResolver, newKEKResolver, newEncKeyResolver);
        this._kekResolver = newKEKResolver;
    }

    public Pkcs11Decrypter(KeyInfoCredentialResolver newResolver, KeyInfoCredentialResolver newKEKResolver, EncryptedKeyResolver newEncKeyResolver, Collection<String> whitelistAlgos, Collection<String> blacklistAlgos) {
        super(newResolver, newKEKResolver, newEncKeyResolver, whitelistAlgos, blacklistAlgos);
        this._kekResolver = newKEKResolver;
    }

    @Nonnull
    public Key decryptKey(@Nonnull EncryptedKey encryptedKey, @Nonnull String algorithm, @Nonnull Key kek) throws DecryptionException {
        if (kek != null && (AlgorithmSupport.isRSAOAEP((String)encryptedKey.getEncryptionMethod().getAlgorithm()) && this.testMode || "sun.security.pkcs11.P11Key$P11PrivateKey".equals(kek.getClass().getName()))) {
            CriteriaSet criteriaSet = this.buildCredentialCriteria((EncryptedType)encryptedKey, this.getKEKResolverCriteria());
            try {
                for (Credential cred : this._kekResolver.resolve((Object)criteriaSet)) {
                    try {
                        if (!RSAPublicKey.class.isInstance(cred.getPublicKey())) continue;
                        return this.decryptKey(encryptedKey, algorithm, CredentialSupport.extractDecryptionKey((Credential)cred), ((RSAPublicKey)cred.getPublicKey()).getModulus().bitLength());
                    }
                    catch (DecryptionException e) {
                        String msg = "Attempt to decrypt EncryptedKey using credential from KEK KeyInfo resolver failed: ";
                        log.debug("Attempt to decrypt EncryptedKey using credential from KEK KeyInfo resolver failed: ", (Throwable)e);
                    }
                }
            }
            catch (ResolverException e) {
                log.error("Error resolving credentials from EncryptedKey KeyInfo", (Throwable)e);
            }
            log.error("Failed to decrypt EncryptedKey, failed to find out the keylength for private key");
            throw new DecryptionException("Valid decryption key for EncryptedKey could not be resolved");
        }
        return super.decryptKey(encryptedKey, algorithm, kek);
    }

    @Nonnull
    public Key decryptKey(@Nonnull EncryptedKey encryptedKey, @Nonnull String algorithm) throws DecryptionException {
        if (AlgorithmSupport.isRSAOAEP((String)encryptedKey.getEncryptionMethod().getAlgorithm())) {
            if (this._kekResolver == null) {
                log.warn("No KEK KeyInfo credential resolver is available, cannot attempt EncryptedKey decryption");
                throw new DecryptionException("No KEK KeyInfo resolver is available for EncryptedKey decryption");
            }
            if (Strings.isNullOrEmpty((String)algorithm)) {
                log.error("Algorithm of encrypted key not supplied, key decryption cannot proceed.");
                throw new DecryptionException("Algorithm of encrypted key not supplied, key decryption cannot proceed.");
            }
            CriteriaSet criteriaSet = this.buildCredentialCriteria((EncryptedType)encryptedKey, this.getKEKResolverCriteria());
            try {
                for (Credential cred : this._kekResolver.resolve((Object)criteriaSet)) {
                    try {
                        if (RSAPublicKey.class.isInstance(cred.getPublicKey())) {
                            return this.decryptKey(encryptedKey, algorithm, CredentialSupport.extractDecryptionKey((Credential)cred), ((RSAPublicKey)cred.getPublicKey()).getModulus().bitLength());
                        }
                        return super.decryptKey(encryptedKey, algorithm, CredentialSupport.extractDecryptionKey((Credential)cred));
                    }
                    catch (DecryptionException e) {
                        String msg = "Attempt to decrypt EncryptedKey using credential from KEK KeyInfo resolver failed: ";
                        log.debug("Attempt to decrypt EncryptedKey using credential from KEK KeyInfo resolver failed: ", (Throwable)e);
                    }
                }
            }
            catch (ResolverException e) {
                log.error("Error resolving credentials from EncryptedKey KeyInfo", (Throwable)e);
            }
            log.error("Failed to decrypt EncryptedKey, valid decryption key could not be resolved");
            throw new DecryptionException("Valid decryption key for EncryptedKey could not be resolved");
        }
        return super.decryptKey(encryptedKey, algorithm);
    }

    @Nonnull
    protected Key decryptKey(@Nonnull EncryptedKey encryptedKey, @Nonnull String algorithm, @Nonnull Key kek, int keysize) throws DecryptionException {
        org.apache.xml.security.encryption.EncryptedKey encKey;
        XMLCipher xmlCipher;
        if (!this.testMode && !"sun.security.pkcs11.P11Key$P11PrivateKey".equals(kek.getClass().getName())) {
            return super.decryptKey(encryptedKey, algorithm, kek);
        }
        if (Strings.isNullOrEmpty((String)algorithm)) {
            log.error("Algorithm of encrypted key not supplied, key decryption cannot proceed.");
            throw new DecryptionException("Algorithm of encrypted key not supplied, key decryption cannot proceed.");
        }
        this.validateAlgorithms(encryptedKey);
        try {
            this.checkAndMarshall((XMLObject)encryptedKey);
        }
        catch (DecryptionException e) {
            log.error("Error marshalling EncryptedKey for decryption", (Throwable)e);
            throw e;
        }
        this.preProcessEncryptedKey(encryptedKey, algorithm, kek);
        try {
            xmlCipher = this.getJCAProviderName() != null ? XMLCipher.getProviderInstance((String)this.getJCAProviderName()) : XMLCipher.getInstance();
            xmlCipher.init(4, kek);
        }
        catch (XMLEncryptionException e) {
            log.error("Error initialzing cipher instance on key decryption", (Throwable)e);
            throw new DecryptionException("Error initialzing cipher instance on key decryption", (Exception)((Object)e));
        }
        try {
            Element targetElement = encryptedKey.getDOM();
            encKey = xmlCipher.loadEncryptedKey(targetElement.getOwnerDocument(), targetElement);
        }
        catch (XMLEncryptionException e) {
            log.error("Error when loading library native encrypted key representation", (Throwable)e);
            throw new DecryptionException("Error when loading library native encrypted key representation", (Exception)((Object)e));
        }
        if (keysize == -1) {
            log.debug("Keysize of private key is not known, will have to find corresponding certificate ...");
        }
        try {
            Key key = this.customizedDecryptKey(encKey, algorithm, kek, keysize);
            if (key == null) {
                throw new DecryptionException("Key could not be decrypted");
            }
            return key;
        }
        catch (XMLEncryptionException e) {
            log.error("Error decrypting encrypted key", (Throwable)e);
            throw new DecryptionException("Error decrypting encrypted key", (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new DecryptionException("Probable runtime exception on decryption:" + e.getMessage(), e);
        }
    }

    private Key customizedDecryptKey(org.apache.xml.security.encryption.EncryptedKey encryptedKey, String algorithm, Key kek, int keysize) throws XMLEncryptionException {
        byte[] encryptedBytes = new XMLCipherInput((org.apache.xml.security.encryption.EncryptedType)encryptedKey).getBytes();
        try {
            String provider = this.getJCAProviderName();
            Cipher c = provider != null ? Cipher.getInstance("RSA/ECB/NoPadding", provider) : Cipher.getInstance("RSA/ECB/NoPadding");
            c.init(2, kek);
            byte[] paddedPlainText = c.doFinal(encryptedBytes);
            if (paddedPlainText.length < keysize / 8) {
                byte[] tmp = new byte[keysize / 8];
                System.arraycopy(paddedPlainText, 0, tmp, tmp.length - paddedPlainText.length, paddedPlainText.length);
                paddedPlainText = tmp;
            }
            EncryptionMethod encMethod = encryptedKey.getEncryptionMethod();
            OAEPParameterSpec oaepParameters = this.constructOAEPParameters(encMethod.getAlgorithm(), encMethod.getDigestAlgorithm(), encMethod.getMGFAlgorithm(), encMethod.getOAEPparams());
            RSAPadding padding = RSAPadding.getInstance(4, keysize / 8, new SecureRandom(), oaepParameters);
            byte[] secretKeyBytes = padding.unpad(paddedPlainText);
            String jceKeyAlgorithm = JCEMapper.getJCEKeyAlgorithmFromURI((String)algorithm);
            return new SecretKeySpec(secretKeyBytes, jceKeyAlgorithm);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new XMLEncryptionException((Exception)e);
        }
    }

    private OAEPParameterSpec constructOAEPParameters(String encryptionAlgorithm, String digestAlgorithm, String mgfAlgorithm, byte[] oaepParams) {
        String jceDigestAlgorithm = "SHA-1";
        if (digestAlgorithm != null) {
            jceDigestAlgorithm = JCEMapper.translateURItoJCEID((String)digestAlgorithm);
        }
        PSource.PSpecified pSource = PSource.PSpecified.DEFAULT;
        if (oaepParams != null) {
            pSource = new PSource.PSpecified(oaepParams);
        }
        MGF1ParameterSpec mgfParameterSpec = new MGF1ParameterSpec("SHA-1");
        if ("http://www.w3.org/2009/xmlenc11#rsa-oaep".equals(encryptionAlgorithm)) {
            if ("http://www.w3.org/2009/xmlenc11#mgf1sha256".equals(mgfAlgorithm)) {
                mgfParameterSpec = new MGF1ParameterSpec("SHA-256");
            } else if ("http://www.w3.org/2009/xmlenc11#mgf1sha384".equals(mgfAlgorithm)) {
                mgfParameterSpec = new MGF1ParameterSpec("SHA-384");
            } else if ("http://www.w3.org/2009/xmlenc11#mgf1sha512".equals(mgfAlgorithm)) {
                mgfParameterSpec = new MGF1ParameterSpec("SHA-512");
            }
        }
        return new OAEPParameterSpec(jceDigestAlgorithm, "MGF1", mgfParameterSpec, pSource);
    }

    private CriteriaSet buildCredentialCriteria(@Nonnull EncryptedType encryptedType, @Nullable CriteriaSet staticCriteria) {
        CriteriaSet newCriteriaSet = new CriteriaSet();
        newCriteriaSet.add((Object)new KeyInfoCriterion(encryptedType.getKeyInfo()));
        if (staticCriteria != null && !staticCriteria.isEmpty()) {
            newCriteriaSet.addAll((Collection)staticCriteria);
        }
        if (!newCriteriaSet.contains(UsageCriterion.class)) {
            newCriteriaSet.add((Object)new UsageCriterion(UsageType.ENCRYPTION));
        }
        return newCriteriaSet;
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }
}

