/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.opensaml.xmlsec.encryption.support;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.algorithm.AlgorithmDescriptor;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.encryption.support.KeyEncryptionParameters;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.swedenconnect.opensaml.security.credential.KeyAgreementCredential;
import se.swedenconnect.opensaml.xmlsec.BasicExtendedEncryptionConfiguration;
import se.swedenconnect.opensaml.xmlsec.algorithm.ExtendedAlgorithmSupport;
import se.swedenconnect.opensaml.xmlsec.config.ExtendedDefaultSecurityConfigurationBootstrap;
import se.swedenconnect.opensaml.xmlsec.encryption.ConcatKDFParams;
import se.swedenconnect.opensaml.xmlsec.encryption.KeyDerivationMethod;
import se.swedenconnect.opensaml.xmlsec.encryption.support.ConcatKDFParameters;
import se.swedenconnect.opensaml.xmlsec.encryption.support.ECDHSupport;
import se.swedenconnect.opensaml.xmlsec.keyinfo.KeyAgreementKeyInfoGeneratorFactory;

public class ECDHKeyAgreementParameters
extends KeyEncryptionParameters {
    private static final Logger log = LoggerFactory.getLogger(ECDHKeyAgreementParameters.class);
    private String keyDerivationAlgorithm;
    private ConcatKDFParameters concatKDFParameters;
    private KeyAgreementCredential keyAgreementCredential;
    private boolean keyAgreementCredentialAssigned = false;

    public ECDHKeyAgreementParameters() {
        BasicExtendedEncryptionConfiguration config = ExtendedDefaultSecurityConfigurationBootstrap.buildDefaultEncryptionConfiguration((EncryptionConfiguration)ConfigurationService.get(EncryptionConfiguration.class));
        this.setAlgorithm(config.getKeyTransportEncryptionAlgorithms().stream().map(arg_0 -> ((AlgorithmRegistry)AlgorithmSupport.getGlobalAlgorithmRegistry()).get(arg_0)).filter(ExtendedAlgorithmSupport::isKeyWrappingAlgorithm).map(AlgorithmDescriptor::getURI).findFirst().orElse(null));
        this.setKeyDerivationAlgorithm(config.getKeyDerivationAlgorithms().stream().findFirst().orElse(null));
        this.setConcatKDFParameters(config.getConcatKDFParameters());
    }

    public ECDHKeyAgreementParameters(EncryptionParameters params, String recipientId) {
        super(params, recipientId);
        if (params.getKeyTransportEncryptionCredential() != null && KeyAgreementCredential.class.isInstance(params.getKeyTransportEncryptionCredential())) {
            this.setKeyAgreementCredential(params.getKeyTransportEncryptionCredential());
        }
    }

    public Credential getKeyAgreementCredential() {
        if (this.keyAgreementCredential != null) {
            return this.keyAgreementCredential;
        }
        log.debug("Generating key agreement credential ...");
        Credential peerCredential = this.getPeerCredential();
        if (peerCredential == null) {
            log.info("Could not generate key agreement credential - peer credential is missing");
            return null;
        }
        try {
            KeyDerivationMethod keyDerivationMethod = (KeyDerivationMethod)XMLObjectSupport.buildXMLObject((QName)KeyDerivationMethod.DEFAULT_ELEMENT_NAME);
            keyDerivationMethod.setAlgorithm(this.keyDerivationAlgorithm);
            if (this.concatKDFParameters != null) {
                keyDerivationMethod.getUnknownXMLObjects().add(this.concatKDFParameters.toXMLObject());
            }
            this.keyAgreementCredential = ECDHSupport.createKeyAgreementCredential(this.getPeerCredential(), this.getAlgorithm(), keyDerivationMethod);
            log.debug("Key agreement credential successfully generated");
            this.keyAgreementCredentialAssigned = false;
            return this.keyAgreementCredential;
        }
        catch (SecurityException e) {
            log.error("Failed to generate KeyAgreementCredential - {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public void setKeyAgreementCredential(Credential keyAgreementCredential) {
        Constraint.isTrue((boolean)KeyAgreementCredential.class.isInstance(keyAgreementCredential), (String)"Supplied credential must be a keyAgreementCredential");
        this.keyAgreementCredential = (KeyAgreementCredential)((Object)KeyAgreementCredential.class.cast(keyAgreementCredential));
        this.keyAgreementCredentialAssigned = true;
    }

    public Credential getEncryptionCredential() {
        return this.getKeyAgreementCredential();
    }

    public void setEncryptionCredential(Credential encryptionCredential) {
        this.setPeerCredential(encryptionCredential);
    }

    public Credential getPeerCredential() {
        return super.getEncryptionCredential();
    }

    public void setPeerCredential(Credential peerCredential) {
        super.setEncryptionCredential(peerCredential);
        if (!this.keyAgreementCredentialAssigned && this.keyAgreementCredential != null) {
            this.keyAgreementCredential = null;
        }
    }

    public KeyInfoGenerator getKeyInfoGenerator() {
        KeyInfoGenerator generator = super.getKeyInfoGenerator();
        if (generator == null || KeyAgreementKeyInfoGeneratorFactory.KeyAgreementKeyInfoGenerator.class.isInstance(generator)) {
            generator = ExtendedDefaultSecurityConfigurationBootstrap.buildDefaultKeyAgreementKeyInfoGeneratorFactory().newInstance();
        }
        return generator;
    }

    public String getKeyDerivationAlgorithm() {
        return this.keyAgreementCredential != null ? this.keyAgreementCredential.getKeyDerivationMethod().getAlgorithm() : null;
    }

    public void setKeyDerivationAlgorithm(String keyDerivationAlgorithm) {
        Constraint.isTrue((boolean)"http://www.w3.org/2009/xmlenc11#ConcatKDF".equals(keyDerivationAlgorithm), (String)String.format("The only supported key derivation algorithm is '%s'", "http://www.w3.org/2009/xmlenc11#ConcatKDF"));
        this.keyDerivationAlgorithm = keyDerivationAlgorithm;
        if (!this.keyAgreementCredentialAssigned && this.keyAgreementCredential != null) {
            this.keyAgreementCredential = null;
        }
    }

    public ConcatKDFParameters getConcatKDFParameters() {
        if (this.keyAgreementCredential != null) {
            KeyDerivationMethod kdm = this.keyAgreementCredential.getKeyDerivationMethod();
            ConcatKDFParams params = kdm.getUnknownXMLObjects(ConcatKDFParams.DEFAULT_ELEMENT_NAME).stream().map(ConcatKDFParams.class::cast).findFirst().orElse(null);
            if (params != null) {
                return new ConcatKDFParameters(params);
            }
        }
        return this.concatKDFParameters;
    }

    public void setConcatKDFParameters(ConcatKDFParameters concatKDFParameters) {
        this.concatKDFParameters = concatKDFParameters;
    }
}

