/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.opensaml.xmlsec.encryption.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.saml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.xmlsec.DecryptionConfiguration;
import org.opensaml.xmlsec.DecryptionParameters;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.encryption.support.ChainingEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleKeyInfoReferenceEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleRetrievalMethodEncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.ChainingKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.CollectionKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.LocalKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.DEREncodedKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.DSAKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.InlineX509DataProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.RSAKeyValueProvider;
import se.swedenconnect.opensaml.xmlsec.keyinfo.provider.KeyAgreementMethodKeyInfoProvider;

public class DecryptionUtils {
    public static DecryptionParameters createDecryptionParameters(Credential ... localCredentials) {
        DecryptionParameters parameters = new DecryptionParameters();
        DecryptionConfiguration config = (DecryptionConfiguration)ConfigurationService.get(DecryptionConfiguration.class);
        if (config == null) {
            config = DefaultSecurityConfigurationBootstrap.buildDefaultDecryptionConfiguration();
        }
        parameters.setBlacklistedAlgorithms(config.getBlacklistedAlgorithms());
        parameters.setWhitelistedAlgorithms(config.getWhitelistedAlgorithms());
        parameters.setDataKeyInfoCredentialResolver(config.getDataKeyInfoCredentialResolver());
        ChainingEncryptedKeyResolver encryptedKeyResolver = new ChainingEncryptedKeyResolver(Arrays.asList(new InlineEncryptedKeyResolver(), new EncryptedElementTypeEncryptedKeyResolver(), new SimpleRetrievalMethodEncryptedKeyResolver(), new SimpleKeyInfoReferenceEncryptedKeyResolver()));
        parameters.setEncryptedKeyResolver((EncryptedKeyResolver)encryptedKeyResolver);
        parameters.setKEKKeyInfoCredentialResolver(DecryptionUtils.createKeyInfoCredentialResolver(localCredentials));
        return parameters;
    }

    public static KeyInfoCredentialResolver createKeyInfoCredentialResolver(Credential ... localCredentials) {
        ArrayList<KeyAgreementMethodKeyInfoProvider> providers = new ArrayList<KeyAgreementMethodKeyInfoProvider>();
        providers.add(new KeyAgreementMethodKeyInfoProvider());
        providers.add((KeyAgreementMethodKeyInfoProvider)new RSAKeyValueProvider());
        providers.add((KeyAgreementMethodKeyInfoProvider)new DSAKeyValueProvider());
        providers.add((KeyAgreementMethodKeyInfoProvider)new DEREncodedKeyValueProvider());
        providers.add((KeyAgreementMethodKeyInfoProvider)new InlineX509DataProvider());
        List<Object> credList = localCredentials != null ? Arrays.asList(localCredentials) : Collections.emptyList();
        return new ChainingKeyInfoCredentialResolver(Arrays.asList(new LocalKeyInfoCredentialResolver(providers, (CredentialResolver)new CollectionKeyInfoCredentialResolver(credList)), new StaticKeyInfoCredentialResolver(credList)));
    }

    protected DecryptionUtils() {
    }
}

