/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.opensaml.xmlsec.encryption.support;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLRuntimeException;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.xmlsec.signature.DigestMethod;
import se.swedenconnect.opensaml.xmlsec.encryption.ConcatKDFParams;

public class ConcatKDFParameters {
    public static final byte[] DEFAULT_ALGORITHM_ID = new byte[0];
    public static final byte[] DEFAULT_PARTY_UINFO = new byte[0];
    public static final byte[] DEFAULT_PARTY_VINFO = new byte[0];
    private ConcatKDFParams xmlObject;

    public ConcatKDFParameters(String digestMethod) {
        this(digestMethod, DEFAULT_ALGORITHM_ID, DEFAULT_PARTY_UINFO, DEFAULT_PARTY_VINFO);
    }

    public ConcatKDFParameters(String digestMethod, byte[] algorithmID, byte[] partyUInfo, byte[] partyVInfo) {
        Constraint.isNotEmpty((String)digestMethod, (String)"digestMethod must be set");
        Constraint.isNotNull((Object)algorithmID, (String)"algorithmID must not be null");
        Constraint.isNotNull((Object)partyUInfo, (String)"partyUInfo must not be null");
        Constraint.isNotNull((Object)partyVInfo, (String)"partyVInfo must not be null");
        this.xmlObject = (ConcatKDFParams)XMLObjectSupport.buildXMLObject((QName)ConcatKDFParams.DEFAULT_ELEMENT_NAME);
        DigestMethod dm = (DigestMethod)XMLObjectSupport.buildXMLObject((QName)DigestMethod.DEFAULT_ELEMENT_NAME);
        dm.setAlgorithm(digestMethod);
        this.xmlObject.setDigestMethod(dm);
        this.xmlObject.setAlgorithmID(ConcatKDFParameters.pad(algorithmID));
        this.xmlObject.setPartyUInfo(ConcatKDFParameters.pad(partyUInfo));
        this.xmlObject.setPartyVInfo(ConcatKDFParameters.pad(partyVInfo));
    }

    public ConcatKDFParameters(ConcatKDFParams params) {
        Constraint.isNotNull((Object)params, (String)"params must not be null");
        Constraint.isNotNull((Object)params.getDigestMethod(), (String)"params.DigestMethod must not be null");
        Constraint.isNotEmpty((String)params.getDigestMethod().getAlgorithm(), (String)"digestMethod must be set");
        Constraint.isNotEmpty((byte[])params.getAlgorithmID(), (String)"params.algorithmID must be set");
        Constraint.isNotEmpty((byte[])params.getPartyUInfo(), (String)"params.partyUInfo must be set");
        Constraint.isNotEmpty((byte[])params.getPartyVInfo(), (String)"params.partyVInfo must be set");
        try {
            this.xmlObject = (ConcatKDFParams)XMLObjectSupport.cloneXMLObject((XMLObject)params);
        }
        catch (MarshallingException | UnmarshallingException e) {
            throw new XMLRuntimeException("Failed to clone ConcatKDFParams", (Exception)e);
        }
    }

    public ConcatKDFParams toXMLObject() {
        try {
            return (ConcatKDFParams)XMLObjectSupport.cloneXMLObject((XMLObject)this.xmlObject);
        }
        catch (MarshallingException | UnmarshallingException e) {
            throw new XMLRuntimeException("Failed to clone ConcatKDFParams", (Exception)e);
        }
    }

    public String getDigestMethod() {
        return this.xmlObject.getDigestMethod().getAlgorithm();
    }

    public void setAlgorithmID(byte[] algorithmID) {
        this.xmlObject.setAlgorithmID(ConcatKDFParameters.pad(algorithmID));
    }

    public void setPartyUInfo(byte[] partyUInfo) {
        this.xmlObject.setPartyUInfo(ConcatKDFParameters.pad(partyUInfo));
    }

    public void setPartyVInfo(byte[] partyVInfo) {
        this.xmlObject.setPartyVInfo(ConcatKDFParameters.pad(partyVInfo));
    }

    public void setSuppPubInfo(byte[] suppPubInfo) {
        this.xmlObject.setSuppPubInfo(ConcatKDFParameters.pad(suppPubInfo));
    }

    public void setSuppPrivInfo(byte[] suppPrivInfo) {
        this.xmlObject.setSuppPrivInfo(ConcatKDFParameters.pad(suppPrivInfo));
    }

    private static byte[] pad(byte[] value) {
        if (value == null) {
            return null;
        }
        byte[] newValue = new byte[value.length + 1];
        newValue[0] = 0;
        System.arraycopy(value, 0, newValue, 1, value.length);
        return newValue;
    }
}

