/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.opensaml.xmlsec.config;

import java.util.ArrayList;
import java.util.Arrays;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.encryption.support.RSAOAEPParameters;
import org.opensaml.xmlsec.impl.BasicEncryptionConfiguration;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import se.swedenconnect.opensaml.xmlsec.config.AbstractSecurityConfiguration;
import se.swedenconnect.opensaml.xmlsec.config.ExtendedDefaultSecurityConfigurationBootstrap;

public class SAML2IntSecurityConfiguration
extends AbstractSecurityConfiguration {
    @Override
    public String getProfileName() {
        return "saml2int";
    }

    @Override
    protected EncryptionConfiguration createDefaultEncryptionConfiguration() {
        BasicEncryptionConfiguration config = DefaultSecurityConfigurationBootstrap.buildDefaultEncryptionConfiguration();
        config.setDataEncryptionAlgorithms(Arrays.asList("http://www.w3.org/2009/xmlenc11#aes256-gcm", "http://www.w3.org/2009/xmlenc11#aes192-gcm", "http://www.w3.org/2009/xmlenc11#aes128-gcm", "http://www.w3.org/2001/04/xmlenc#aes256-cbc", "http://www.w3.org/2001/04/xmlenc#aes192-cbc", "http://www.w3.org/2001/04/xmlenc#aes128-cbc", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc"));
        config.setKeyTransportEncryptionAlgorithms(Arrays.asList("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2001/04/xmlenc#kw-aes256", "http://www.w3.org/2001/04/xmlenc#kw-aes192", "http://www.w3.org/2001/04/xmlenc#kw-aes128", "http://www.w3.org/2001/04/xmlenc#kw-tripledes"));
        config.setRSAOAEPParameters(new RSAOAEPParameters("http://www.w3.org/2000/09/xmldsig#sha1", "http://www.w3.org/2009/xmlenc11#mgf1sha1", null));
        return ExtendedDefaultSecurityConfigurationBootstrap.buildDefaultEncryptionConfiguration((EncryptionConfiguration)config);
    }

    @Override
    protected SignatureSigningConfiguration createDefaultSignatureSigningConfiguration() {
        BasicSignatureSigningConfiguration config = ExtendedDefaultSecurityConfigurationBootstrap.buildDefaultSignatureSigningConfiguration();
        ArrayList<String> blacklistedAlgorithms = new ArrayList<String>(config.getBlacklistedAlgorithms());
        blacklistedAlgorithms.add("http://www.w3.org/2000/09/xmldsig#sha1");
        blacklistedAlgorithms.add("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        blacklistedAlgorithms.add("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1");
        blacklistedAlgorithms.add("http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        blacklistedAlgorithms.add("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        config.setBlacklistedAlgorithms(blacklistedAlgorithms);
        return config;
    }
}

