/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.opensaml.xmlsec.config;

import java.util.ServiceLoader;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.Initializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.swedenconnect.opensaml.xmlsec.algorithm.descriptors.NamedCurve;
import se.swedenconnect.opensaml.xmlsec.algorithm.descriptors.NamedCurveRegistry;

public class NamedCurveRegistryInitializer
implements Initializer {
    private Logger log = LoggerFactory.getLogger(NamedCurveRegistryInitializer.class);

    public void init() throws InitializationException {
        NamedCurveRegistry registry = new NamedCurveRegistry();
        ServiceLoader<NamedCurve> loader = ServiceLoader.load(NamedCurve.class);
        for (NamedCurve curve : loader) {
            this.log.debug("Registering NamedCurve of name '{}' with OID '{}' (keyLength: {}): {}", new Object[]{curve.getName(), curve.getObjectIdentifier(), curve.getKeyLength(), curve.getClass().getName()});
            registry.register(curve);
        }
        ConfigurationService.register(NamedCurveRegistry.class, (Object)registry);
    }
}

