/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.opensaml.xmlsec.config;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.opensaml.saml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.encryption.support.ChainingEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleKeyInfoReferenceEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleRetrievalMethodEncryptedKeyResolver;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import se.swedenconnect.opensaml.xmlsec.BasicExtendedEncryptionConfiguration;
import se.swedenconnect.opensaml.xmlsec.encryption.support.ConcatKDFParameters;
import se.swedenconnect.opensaml.xmlsec.keyinfo.KeyAgreementKeyInfoGeneratorFactory;

public class ExtendedDefaultSecurityConfigurationBootstrap
extends DefaultSecurityConfigurationBootstrap {
    protected ExtendedDefaultSecurityConfigurationBootstrap() {
    }

    @Nonnull
    public static BasicExtendedEncryptionConfiguration buildDefaultEncryptionConfiguration() {
        return ExtendedDefaultSecurityConfigurationBootstrap.buildDefaultEncryptionConfiguration((EncryptionConfiguration)DefaultSecurityConfigurationBootstrap.buildDefaultEncryptionConfiguration());
    }

    public static BasicExtendedEncryptionConfiguration buildDefaultEncryptionConfiguration(EncryptionConfiguration config) {
        if (BasicExtendedEncryptionConfiguration.class.isInstance(config)) {
            return (BasicExtendedEncryptionConfiguration)BasicExtendedEncryptionConfiguration.class.cast(config);
        }
        if (config == null) {
            config = DefaultSecurityConfigurationBootstrap.buildDefaultEncryptionConfiguration();
        }
        BasicExtendedEncryptionConfiguration extendedConfig = new BasicExtendedEncryptionConfiguration();
        extendedConfig.setAgreementMethodAlgorithms(Arrays.asList("http://www.w3.org/2009/xmlenc11#ECDH-ES"));
        extendedConfig.setKeyDerivationAlgorithms(Arrays.asList("http://www.w3.org/2009/xmlenc11#ConcatKDF"));
        extendedConfig.setConcatKDFParameters(new ConcatKDFParameters("http://www.w3.org/2001/04/xmlenc#sha256"));
        extendedConfig.setBlacklistedAlgorithms(config.getBlacklistedAlgorithms());
        extendedConfig.setBlacklistMerge(config.isBlacklistMerge());
        extendedConfig.setWhitelistBlacklistPrecedence(config.getWhitelistBlacklistPrecedence());
        extendedConfig.setWhitelistedAlgorithms(config.getWhitelistedAlgorithms());
        extendedConfig.setWhitelistMerge(config.isWhitelistMerge());
        extendedConfig.setDataEncryptionAlgorithms(config.getDataEncryptionAlgorithms());
        extendedConfig.setDataEncryptionCredentials(config.getDataEncryptionCredentials());
        extendedConfig.setDataKeyInfoGeneratorManager(config.getDataKeyInfoGeneratorManager());
        extendedConfig.setKeyTransportAlgorithmPredicate(config.getKeyTransportAlgorithmPredicate());
        extendedConfig.setKeyTransportEncryptionCredentials(config.getKeyTransportEncryptionCredentials());
        extendedConfig.setRSAOAEPParameters(config.getRSAOAEPParameters());
        extendedConfig.setRSAOAEPParametersMerge(config.isRSAOAEPParametersMerge());
        extendedConfig.setKeyTransportKeyInfoGeneratorManager(config.getKeyTransportKeyInfoGeneratorManager());
        if (config.getKeyTransportEncryptionAlgorithms().equals(DefaultSecurityConfigurationBootstrap.buildDefaultEncryptionConfiguration().getKeyTransportEncryptionAlgorithms())) {
            extendedConfig.setKeyTransportEncryptionAlgorithms(Arrays.asList("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "http://www.w3.org/2001/04/xmlenc#kw-aes256", "http://www.w3.org/2001/04/xmlenc#kw-aes192", "http://www.w3.org/2001/04/xmlenc#kw-aes128", "http://www.w3.org/2001/04/xmlenc#kw-tripledes"));
        } else {
            extendedConfig.setKeyTransportEncryptionAlgorithms(config.getKeyTransportEncryptionAlgorithms());
        }
        return extendedConfig;
    }

    public static BasicSignatureSigningConfiguration buildDefaultSignatureSigningConfiguration() {
        return ExtendedDefaultSecurityConfigurationBootstrap.buildDefaultSignatureSigningConfiguration(null);
    }

    public static BasicSignatureSigningConfiguration buildDefaultSignatureSigningConfiguration(SignatureSigningConfiguration config) {
        BasicSignatureSigningConfiguration updatedConfig;
        if (config == null) {
            updatedConfig = DefaultSecurityConfigurationBootstrap.buildDefaultSignatureSigningConfiguration();
        } else if (BasicSignatureSigningConfiguration.class.isInstance(config)) {
            updatedConfig = (BasicSignatureSigningConfiguration)BasicSignatureSigningConfiguration.class.cast(config);
        } else {
            updatedConfig = new BasicSignatureSigningConfiguration();
            updatedConfig.setBlacklistedAlgorithms(config.getBlacklistedAlgorithms());
            updatedConfig.setBlacklistMerge(config.isBlacklistMerge());
            updatedConfig.setWhitelistedAlgorithms(config.getWhitelistedAlgorithms());
            updatedConfig.setWhitelistMerge(config.isWhitelistMerge());
            updatedConfig.setWhitelistBlacklistPrecedence(config.getWhitelistBlacklistPrecedence());
            updatedConfig.setKeyInfoGeneratorManager(config.getKeyInfoGeneratorManager());
            updatedConfig.setSignatureCanonicalizationAlgorithm(config.getSignatureCanonicalizationAlgorithm());
            updatedConfig.setSignatureHMACOutputLength(config.getSignatureHMACOutputLength());
            updatedConfig.setSignatureReferenceCanonicalizationAlgorithm(config.getSignatureReferenceCanonicalizationAlgorithm());
            updatedConfig.setSignatureReferenceDigestMethods(config.getSignatureReferenceDigestMethods());
            updatedConfig.setSigningCredentials(config.getSigningCredentials());
            updatedConfig.setSignatureAlgorithms(config.getSignatureAlgorithms());
        }
        ArrayList<String> signatureAlgorithms = new ArrayList<String>(updatedConfig.getSignatureAlgorithms());
        if (!signatureAlgorithms.contains("http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1")) {
            signatureAlgorithms.add("http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1");
        }
        if (!signatureAlgorithms.contains("http://www.w3.org/2007/05/xmldsig-more#sha384-rsa-MGF1")) {
            signatureAlgorithms.add("http://www.w3.org/2007/05/xmldsig-more#sha384-rsa-MGF1");
        }
        if (!signatureAlgorithms.contains("http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1")) {
            signatureAlgorithms.add("http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1");
        }
        if (!signatureAlgorithms.contains("http://www.w3.org/2007/05/xmldsig-more#sha224-rsa-MGF1")) {
            signatureAlgorithms.add("http://www.w3.org/2007/05/xmldsig-more#sha224-rsa-MGF1");
        }
        if (!signatureAlgorithms.contains("http://www.w3.org/2007/05/xmldsig-more#sha3-256-rsa-MGF1")) {
            signatureAlgorithms.add("http://www.w3.org/2007/05/xmldsig-more#sha3-256-rsa-MGF1");
        }
        if (!signatureAlgorithms.contains("http://www.w3.org/2007/05/xmldsig-more#sha3-384-rsa-MGF1")) {
            signatureAlgorithms.add("http://www.w3.org/2007/05/xmldsig-more#sha3-384-rsa-MGF1");
        }
        if (!signatureAlgorithms.contains("http://www.w3.org/2007/05/xmldsig-more#sha3-512-rsa-MGF1")) {
            signatureAlgorithms.add("http://www.w3.org/2007/05/xmldsig-more#sha3-512-rsa-MGF1");
        }
        if (!signatureAlgorithms.contains("http://www.w3.org/2007/05/xmldsig-more#sha3-224-rsa-MGF1")) {
            signatureAlgorithms.add("http://www.w3.org/2007/05/xmldsig-more#sha3-224-rsa-MGF1");
        }
        updatedConfig.setSignatureAlgorithms(signatureAlgorithms);
        return updatedConfig;
    }

    protected static EncryptedKeyResolver buildBasicEncryptedKeyResolver() {
        ArrayList<Object> resolverChain = new ArrayList<Object>();
        resolverChain.add(new InlineEncryptedKeyResolver());
        resolverChain.add(new EncryptedElementTypeEncryptedKeyResolver());
        resolverChain.add(new SimpleRetrievalMethodEncryptedKeyResolver());
        resolverChain.add(new SimpleKeyInfoReferenceEncryptedKeyResolver());
        return new ChainingEncryptedKeyResolver(resolverChain);
    }

    public static NamedKeyInfoGeneratorManager buildBasicKeyInfoGeneratorManager() {
        return ExtendedDefaultSecurityConfigurationBootstrap.buildBasicKeyInfoGeneratorManager(DefaultSecurityConfigurationBootstrap.buildBasicKeyInfoGeneratorManager());
    }

    public static NamedKeyInfoGeneratorManager buildBasicKeyInfoGeneratorManager(NamedKeyInfoGeneratorManager manager) {
        manager.getDefaultManager().registerFactory((KeyInfoGeneratorFactory)ExtendedDefaultSecurityConfigurationBootstrap.buildDefaultKeyAgreementKeyInfoGeneratorFactory());
        return manager;
    }

    public static KeyAgreementKeyInfoGeneratorFactory buildDefaultKeyAgreementKeyInfoGeneratorFactory() {
        KeyAgreementKeyInfoGeneratorFactory kaFactory = new KeyAgreementKeyInfoGeneratorFactory();
        kaFactory.setEmitEntityCertificate(true);
        kaFactory.setEmitOriginatorKeyInfoPublicKeyValue(true);
        return kaFactory;
    }
}

