/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.opensaml.xmlsec.config;

import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.xmlsec.DecryptionConfiguration;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureValidationConfiguration;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.swedenconnect.opensaml.xmlsec.config.ExtendedDefaultSecurityConfigurationBootstrap;
import se.swedenconnect.opensaml.xmlsec.config.SecurityConfiguration;

public abstract class AbstractSecurityConfiguration
implements SecurityConfiguration {
    private EncryptionConfiguration defaultEncryptionConfiguration;
    private DecryptionConfiguration defaultDecryptionConfiguration;
    private SignatureSigningConfiguration defaultSignatureSigningConfiguration;
    private SignatureValidationConfiguration defaultSignatureValidationConfiguration;
    private Logger log = LoggerFactory.getLogger(AbstractSecurityConfiguration.class);

    @Override
    public final EncryptionConfiguration getEncryptionConfiguration() {
        EncryptionConfiguration config = this.getDefaultEncryptionConfiguration();
        if (config != null) {
            this.log.debug("Returning encryption configuration for profile '{}'", (Object)this.getProfileName());
            return config;
        }
        this.log.debug("No default encryption configuration configured for security configuration '{}', using OpenSAML defaults", (Object)this.getProfileName());
        config = (EncryptionConfiguration)ConfigurationService.get(EncryptionConfiguration.class);
        if (config == null) {
            this.log.warn("No EncryptionConfiguration object exists in OpenSAML configuration. Has OpenSAML been initialized?");
            this.log.debug("Using ExtendedDefaultSecurityConfigurationBootstrap to create encryption configuration");
            config = ExtendedDefaultSecurityConfigurationBootstrap.buildDefaultEncryptionConfiguration();
        }
        return config;
    }

    protected final EncryptionConfiguration getDefaultEncryptionConfiguration() {
        if (this.defaultEncryptionConfiguration == null) {
            this.defaultEncryptionConfiguration = this.createDefaultEncryptionConfiguration();
        }
        return this.defaultEncryptionConfiguration;
    }

    protected EncryptionConfiguration createDefaultEncryptionConfiguration() {
        return null;
    }

    @Override
    public final DecryptionConfiguration getDecryptionConfiguration() {
        DecryptionConfiguration config = this.getDefaultDecryptionConfiguration();
        if (config != null) {
            this.log.debug("Returning decryption configuration for profile '{}'", (Object)this.getProfileName());
            return config;
        }
        this.log.debug("No default decryption configuration configured for security configuration '{}', using OpenSAML defaults", (Object)this.getProfileName());
        config = (DecryptionConfiguration)ConfigurationService.get(DecryptionConfiguration.class);
        if (config == null) {
            this.log.warn("No DecryptionConfiguration object exists in OpenSAML configuration. Has OpenSAML been initialized?");
            this.log.debug("Using DefaultSecurityConfigurationBootstrap to create encryption configuration");
            config = DefaultSecurityConfigurationBootstrap.buildDefaultDecryptionConfiguration();
        }
        return config;
    }

    protected final DecryptionConfiguration getDefaultDecryptionConfiguration() {
        if (this.defaultDecryptionConfiguration == null) {
            this.defaultDecryptionConfiguration = this.createDefaultDecryptionConfiguration();
        }
        return this.defaultDecryptionConfiguration;
    }

    protected DecryptionConfiguration createDefaultDecryptionConfiguration() {
        return null;
    }

    @Override
    public final SignatureSigningConfiguration getSignatureSigningConfiguration() {
        SignatureSigningConfiguration config = this.getDefaultSignatureSigningConfiguration();
        if (config != null) {
            this.log.debug("Returning signature configuration for profile '{}'", (Object)this.getProfileName());
            return config;
        }
        this.log.debug("No default signature configuration configured for security configuration '{}', using OpenSAML defaults", (Object)this.getProfileName());
        config = (SignatureSigningConfiguration)ConfigurationService.get(SignatureSigningConfiguration.class);
        if (config == null) {
            this.log.warn("No SignatureSigningConfiguration object exists in OpenSAML configuration. Has OpenSAML been initialized?");
            this.log.debug("Using DefaultSecurityConfigurationBootstrap to create signature configuration");
            config = DefaultSecurityConfigurationBootstrap.buildDefaultSignatureSigningConfiguration();
        }
        return config;
    }

    protected final SignatureSigningConfiguration getDefaultSignatureSigningConfiguration() {
        if (this.defaultSignatureSigningConfiguration == null) {
            this.defaultSignatureSigningConfiguration = this.createDefaultSignatureSigningConfiguration();
        }
        return this.defaultSignatureSigningConfiguration;
    }

    protected SignatureSigningConfiguration createDefaultSignatureSigningConfiguration() {
        return null;
    }

    @Override
    public final SignatureValidationConfiguration getSignatureValidationConfiguration() {
        SignatureValidationConfiguration config = this.getDefaultSignatureValidationConfiguration();
        if (config != null) {
            this.log.debug("Returning signature validation configuration for profile '{}'", (Object)this.getProfileName());
            return config;
        }
        this.log.debug("No default signature validation configuration configured for security configuration '{}', using OpenSAML defaults", (Object)this.getProfileName());
        config = (SignatureValidationConfiguration)ConfigurationService.get(SignatureValidationConfiguration.class);
        if (config == null) {
            this.log.warn("No SignatureValidationConfiguration object exists in OpenSAML configuration. Has OpenSAML been initialized?");
            this.log.debug("Using DefaultSecurityConfigurationBootstrap to create signature configuration");
            config = DefaultSecurityConfigurationBootstrap.buildDefaultSignatureValidationConfiguration();
        }
        return config;
    }

    protected final SignatureValidationConfiguration getDefaultSignatureValidationConfiguration() {
        if (this.defaultSignatureValidationConfiguration == null) {
            this.defaultSignatureValidationConfiguration = this.createDefaultSignatureValidationConfiguration();
        }
        return this.defaultSignatureValidationConfiguration;
    }

    protected SignatureValidationConfiguration createDefaultSignatureValidationConfiguration() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initOpenSAML() throws InitializationException {
        Class<ConfigurationService> clazz = ConfigurationService.class;
        synchronized (ConfigurationService.class) {
            if (this.getDefaultEncryptionConfiguration() != null) {
                this.log.info("Security configuration for '{}' profile registers EncryptionConfiguration", (Object)this.getProfileName());
                ConfigurationService.register(EncryptionConfiguration.class, (Object)this.getDefaultEncryptionConfiguration());
            }
            if (this.getDefaultDecryptionConfiguration() != null) {
                this.log.info("Security configuration for '{}' profile registers DecryptionConfiguration", (Object)this.getProfileName());
                ConfigurationService.register(DecryptionConfiguration.class, (Object)this.getDefaultDecryptionConfiguration());
            }
            if (this.getDefaultSignatureSigningConfiguration() != null) {
                this.log.info("Security configuration for '{}' profile registers SignatureSigningConfiguration", (Object)this.getProfileName());
                ConfigurationService.register(SignatureSigningConfiguration.class, (Object)this.getDefaultSignatureSigningConfiguration());
            }
            if (this.getDefaultSignatureValidationConfiguration() != null) {
                this.log.info("Security configuration for '{}' profile registers SignatureValidationConfiguration", (Object)this.getProfileName());
                ConfigurationService.register(SignatureValidationConfiguration.class, (Object)this.getDefaultSignatureValidationConfiguration());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

