/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.opensaml.xmlsec.algorithm.descriptors;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.swedenconnect.opensaml.xmlsec.algorithm.descriptors.NamedCurve;

public class NamedCurveRegistry {
    private Logger log = LoggerFactory.getLogger(NamedCurveRegistry.class);
    private Map<String, NamedCurve> curves = new HashMap<String, NamedCurve>();

    @Nullable
    public NamedCurve get(String oid) {
        String trimmedOid = StringSupport.trimOrNull((String)oid);
        if (trimmedOid == null) {
            return null;
        }
        return this.curves.get(trimmedOid);
    }

    public void clear() {
        this.curves.clear();
    }

    public void register(@Nonnull NamedCurve curve) {
        Constraint.isNotNull((Object)curve, (String)"curve must not be null");
        this.log.debug("Registering curve with OID: {} ({})", (Object)curve.getObjectIdentifier(), (Object)curve.getName());
        NamedCurve old = this.curves.get(curve.getObjectIdentifier());
        if (old != null) {
            this.log.debug("Registry contained existing curve, removing old instance and re-registering: {}", (Object)curve.getObjectIdentifier());
        }
        this.curves.put(curve.getObjectIdentifier(), curve);
    }

    public void deregister(@Nonnull NamedCurve curve) {
        Constraint.isNotNull((Object)curve, (String)"curve must not be null");
        if (this.curves.containsKey(curve.getObjectIdentifier())) {
            this.curves.remove(curve.getObjectIdentifier());
            this.log.debug("Re-registered curve {}", (Object)curve.getObjectIdentifier());
        } else {
            this.log.debug("Registry did not contain curve with OID '{}', nothing to do", (Object)curve.getObjectIdentifier());
        }
    }

    public void deregister(@Nonnull String oid) {
        Constraint.isNotNull((Object)oid, (String)"oid must not be null");
        NamedCurve curve = this.get(oid);
        if (curve != null) {
            this.deregister(curve);
        }
    }
}

