/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.opensaml.xmlsec.algorithm;

import javax.annotation.Nullable;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.algorithm.AlgorithmDescriptor;

public final class ExtendedAlgorithmSupport {
    public static boolean isRSAPSS(String signatureAlgorithm) {
        return "http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1".equals(signatureAlgorithm) || "http://www.w3.org/2007/05/xmldsig-more#sha384-rsa-MGF1".equals(signatureAlgorithm) || "http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1".equals(signatureAlgorithm) || "http://www.w3.org/2007/05/xmldsig-more#sha1-rsa-MGF1".equals(signatureAlgorithm) || "http://www.w3.org/2007/05/xmldsig-more#sha224-rsa-MGF1".equals(signatureAlgorithm) || "http://www.w3.org/2007/05/xmldsig-more#sha3-256-rsa-MGF1".equals(signatureAlgorithm) || "http://www.w3.org/2007/05/xmldsig-more#sha3-384-rsa-MGF1".equals(signatureAlgorithm) || "http://www.w3.org/2007/05/xmldsig-more#sha3-512-rsa-MGF1".equals(signatureAlgorithm) || "http://www.w3.org/2007/05/xmldsig-more#sha3-224-rsa-MGF1".equals(signatureAlgorithm);
    }

    public static boolean isKeyWrappingAlgorithm(@Nullable AlgorithmDescriptor algorithm) {
        if (algorithm == null) {
            return false;
        }
        return AlgorithmDescriptor.AlgorithmType.SymmetricKeyWrap.equals((Object)algorithm.getType());
    }

    public static boolean isKeyAgreementAlgorithm(@Nullable AlgorithmDescriptor algorithm) {
        if (algorithm == null) {
            return false;
        }
        return AlgorithmDescriptor.AlgorithmType.KeyAgreement.equals((Object)algorithm.getType());
    }

    public static boolean peerCredentialSupportsKeyAgreement(@Nullable Credential credential) {
        if (credential == null) {
            return false;
        }
        return credential.getPublicKey() != null && credential.getPublicKey().getAlgorithm().equals("EC");
    }

    private ExtendedAlgorithmSupport() {
    }
}

