/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.opensaml.xmlsec;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.security.Key;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.metadata.EncryptionMethod;
import org.opensaml.saml.security.impl.MetadataCredentialResolver;
import org.opensaml.saml.security.impl.SAMLMDCredentialContext;
import org.opensaml.saml.security.impl.SAMLMetadataEncryptionParametersResolver;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.algorithm.AlgorithmDescriptor;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.swedenconnect.opensaml.security.credential.KeyAgreementCredential;
import se.swedenconnect.opensaml.xmlsec.ExtendedEncryptionParametersResolver;
import se.swedenconnect.opensaml.xmlsec.algorithm.ExtendedAlgorithmSupport;
import se.swedenconnect.opensaml.xmlsec.encryption.ConcatKDFParams;
import se.swedenconnect.opensaml.xmlsec.encryption.KeyDerivationMethod;
import se.swedenconnect.opensaml.xmlsec.encryption.support.ConcatKDFParameters;
import se.swedenconnect.opensaml.xmlsec.encryption.support.ECDHSupport;

public class ExtendedSAMLMetadataEncryptionParametersResolver
extends SAMLMetadataEncryptionParametersResolver {
    private Logger log = LoggerFactory.getLogger(ExtendedSAMLMetadataEncryptionParametersResolver.class);
    private ExtendedEncryptionParametersResolver realSuper = new ExtendedEncryptionParametersResolver();

    public ExtendedSAMLMetadataEncryptionParametersResolver(MetadataCredentialResolver resolver) {
        super(resolver);
    }

    protected void resolveAndPopulateCredentialsAndAlgorithms(@Nonnull EncryptionParameters params, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> whitelistBlacklistPredicate) {
        CriteriaSet mdCredResolverCriteria = new CriteriaSet();
        mdCredResolverCriteria.addAll((Collection)criteria);
        mdCredResolverCriteria.add((Object)new UsageCriterion(UsageType.ENCRYPTION), true);
        try {
            for (Credential keyTransportCredential : this.getMetadataCredentialResolver().resolve(mdCredResolverCriteria)) {
                SAMLMDCredentialContext metadataCredContext;
                Pair dataEncryptionAlgorithmAndMethod;
                ResolvedKeyTransport keyTransportAlgorithmAndMethod;
                if (this.log.isTraceEnabled()) {
                    Key key = CredentialSupport.extractEncryptionKey((Credential)keyTransportCredential);
                    this.log.trace("Evaluating key transport encryption credential from SAML metadata of type: {}", (Object)(key != null ? key.getAlgorithm() : "n/a"));
                }
                if ((keyTransportAlgorithmAndMethod = this.resolveKeyTransport(keyTransportCredential, mdCredResolverCriteria, whitelistBlacklistPredicate, (String)(dataEncryptionAlgorithmAndMethod = this.resolveDataEncryptionAlgorithm(criteria, whitelistBlacklistPredicate, metadataCredContext = (SAMLMDCredentialContext)keyTransportCredential.getCredentialContextSet().get(SAMLMDCredentialContext.class))).getFirst(), metadataCredContext)).getAlgorithm() == null) {
                    this.log.debug("Unable to resolve key transport algorithm for credential with key type '{}', considering other credentials", (Object)CredentialSupport.extractEncryptionKey((Credential)keyTransportCredential).getAlgorithm());
                    continue;
                }
                params.setKeyTransportEncryptionCredential(keyTransportAlgorithmAndMethod.getCredential());
                params.setKeyTransportEncryptionAlgorithm(keyTransportAlgorithmAndMethod.getAlgorithm());
                params.setDataEncryptionAlgorithm((String)dataEncryptionAlgorithmAndMethod.getFirst());
                this.resolveAndPopulateRSAOAEPParams(params, criteria, whitelistBlacklistPredicate, keyTransportAlgorithmAndMethod.getEncryptionMethod());
                this.processDataEncryptionCredentialAutoGeneration(params);
                return;
            }
        }
        catch (ResolverException e) {
            this.log.warn("Problem resolving credentials from metadata, falling back to local configuration", (Throwable)e);
        }
        this.log.debug("Could not resolve encryption parameters based on SAML metadata, falling back to locally configured credentials and algorithms");
        this.realSuper.resolveAndPopulateCredentialsAndAlgorithms(params, criteria, whitelistBlacklistPredicate);
    }

    protected ResolvedKeyTransport resolveKeyTransport(@Nonnull Credential keyTransportCredential, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> whitelistBlacklistPredicate, @Nullable String dataEncryptionAlgorithm, @Nullable SAMLMDCredentialContext metadataCredContext) {
        Pair pair = super.resolveKeyTransportAlgorithm(keyTransportCredential, criteria, whitelistBlacklistPredicate, dataEncryptionAlgorithm, metadataCredContext);
        if (pair.getFirst() != null) {
            return new ResolvedKeyTransport((String)pair.getFirst(), (EncryptionMethod)pair.getSecond(), keyTransportCredential);
        }
        if (!ExtendedAlgorithmSupport.peerCredentialSupportsKeyAgreement(keyTransportCredential)) {
            return new ResolvedKeyTransport();
        }
        String keyWrappingAlgorithm = this.resolveKeyWrappingAlgorithm(keyTransportCredential, criteria, whitelistBlacklistPredicate, metadataCredContext);
        if (keyWrappingAlgorithm == null) {
            this.log.debug("No key wrapping algorithm could be resolved - can not perform key agreement for credential of type '{}'", (Object)CredentialSupport.extractEncryptionKey((Credential)keyTransportCredential).getAlgorithm());
            return new ResolvedKeyTransport();
        }
        Pair<String, KeyDerivationMethod> keyAgreement = this.resolveKeyAgreementAlgorithm(keyTransportCredential, criteria, whitelistBlacklistPredicate, metadataCredContext);
        if (keyAgreement == null) {
            this.log.debug("No key agreement algorithm could be resolved - can not perform key agreement for credential of type '{}'", (Object)CredentialSupport.extractEncryptionKey((Credential)keyTransportCredential).getAlgorithm());
            return new ResolvedKeyTransport();
        }
        try {
            KeyAgreementCredential keyAgreementCredential = ECDHSupport.createKeyAgreementCredential(keyTransportCredential, keyWrappingAlgorithm, (KeyDerivationMethod)keyAgreement.getSecond());
            return new ResolvedKeyTransport(keyWrappingAlgorithm, null, (Credential)keyAgreementCredential);
        }
        catch (SecurityException e) {
            this.log.error("Failed to get a key agreement credential using '{}' ({}) - {}", new Object[]{"http://www.w3.org/2009/xmlenc11#ECDH-ES", "http://www.w3.org/2009/xmlenc11#ConcatKDF", e.getMessage(), e});
            return new ResolvedKeyTransport();
        }
    }

    protected String resolveKeyWrappingAlgorithm(@Nonnull Credential keyTransportCredential, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> whitelistBlacklistPredicate, @Nullable SAMLMDCredentialContext metadataCredContext) {
        if (metadataCredContext != null) {
            for (EncryptionMethod encryptionMethod : metadataCredContext.getEncryptionMethods()) {
                AlgorithmDescriptor algorithmDescriptor = this.getAlgorithmRegistry().get(encryptionMethod.getAlgorithm());
                if (algorithmDescriptor == null || !ExtendedAlgorithmSupport.isKeyWrappingAlgorithm(algorithmDescriptor)) continue;
                if (Predicates.and((Predicate)this.getAlgorithmRuntimeSupportedPredicate(), whitelistBlacklistPredicate).apply((Object)algorithmDescriptor.getURI())) {
                    this.log.debug("Found key wrapping algorithm '{}' under EncryptionMethod for credential of type '{}'", (Object)algorithmDescriptor.getURI(), (Object)CredentialSupport.extractEncryptionKey((Credential)keyTransportCredential).getAlgorithm());
                    return algorithmDescriptor.getURI();
                }
                this.log.debug("Key wrapping algorithm '{}' found under EncryptionMethod for credential of type '{}' is not allowed according to white/black list configuration", (Object)algorithmDescriptor.getURI(), (Object)CredentialSupport.extractEncryptionKey((Credential)keyTransportCredential).getAlgorithm());
            }
        }
        this.log.debug("No key wrapping algorithm specified under EncryptionMethod for credential of type '{}' - trying local configuration", (Object)CredentialSupport.extractEncryptionKey((Credential)keyTransportCredential).getAlgorithm());
        List keyTransportAlgorithms = this.getEffectiveKeyTransportAlgorithms(criteria, whitelistBlacklistPredicate);
        String keyWrappingAlgorithm = keyTransportAlgorithms.stream().map(arg_0 -> ((AlgorithmRegistry)this.getAlgorithmRegistry()).get(arg_0)).filter(ExtendedAlgorithmSupport::isKeyWrappingAlgorithm).map(AlgorithmDescriptor::getURI).findFirst().orElse(null);
        if (keyWrappingAlgorithm != null) {
            this.log.debug("Found key wrapping algorithm '{}' in local configuration", (Object)keyWrappingAlgorithm);
        } else {
            this.log.debug("No key wrapping algorithm was found in metadata or local configuration");
        }
        return keyWrappingAlgorithm;
    }

    protected Pair<String, KeyDerivationMethod> resolveKeyAgreementAlgorithm(@Nonnull Credential keyTransportCredential, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> whitelistBlacklistPredicate, @Nullable SAMLMDCredentialContext metadataCredContext) {
        String keyAgreementAlgorithm = null;
        KeyDerivationMethod keyDerivationMethod = null;
        if (metadataCredContext != null) {
            for (EncryptionMethod encryptionMethod : metadataCredContext.getEncryptionMethods()) {
                AlgorithmDescriptor algorithmDescriptor = this.getAlgorithmRegistry().get(encryptionMethod.getAlgorithm());
                if (algorithmDescriptor == null || !ExtendedAlgorithmSupport.isKeyAgreementAlgorithm(algorithmDescriptor)) continue;
                keyAgreementAlgorithm = algorithmDescriptor.getURI();
                this.log.debug("Found key agreement algorithm '{}' under EncryptionMethod for credential of type '{}'", (Object)keyAgreementAlgorithm, (Object)CredentialSupport.extractEncryptionKey((Credential)keyTransportCredential).getAlgorithm());
                keyDerivationMethod = encryptionMethod.getUnknownXMLObjects(KeyDerivationMethod.DEFAULT_ELEMENT_NAME).stream().map(KeyDerivationMethod.class::cast).findFirst().orElse(null);
                if (keyDerivationMethod != null) {
                    this.log.debug("KeyDerivationMethod '{}' was found under EncryptionMethod for '{}' for credential of type '{}'", new Object[]{keyDerivationMethod.getAlgorithm(), keyAgreementAlgorithm, CredentialSupport.extractEncryptionKey((Credential)keyTransportCredential).getAlgorithm()});
                    if ("http://www.w3.org/2009/xmlenc11#ConcatKDF".equals(keyDerivationMethod.getAlgorithm())) {
                        if (!keyDerivationMethod.getUnknownXMLObjects(ConcatKDFParams.DEFAULT_ELEMENT_NAME).isEmpty()) {
                            return new Pair((Object)keyAgreementAlgorithm, (Object)keyDerivationMethod);
                        }
                        this.log.debug("ConcatKDFParams not specified in metadata - will look for it in local configuration");
                        break;
                    }
                    return new Pair((Object)keyAgreementAlgorithm, (Object)keyDerivationMethod);
                }
                this.log.debug("No KeyDerivationMethod was found under EncryptionMethod for '{}' for credential of type '{}'", (Object)algorithmDescriptor.getURI(), (Object)CredentialSupport.extractEncryptionKey((Credential)keyTransportCredential).getAlgorithm());
                break;
            }
        }
        if (keyAgreementAlgorithm == null) {
            this.log.debug("No key agreement algorithm specified under EncryptionMethod for credential of type '{}' - trying local configuration", (Object)CredentialSupport.extractEncryptionKey((Credential)keyTransportCredential).getAlgorithm());
        } else {
            this.log.debug("Key agreement algorithm '{}' was specified under EncryptionMethod for credential of type '{}' - trying local configuration to find KeyDerivationMethod", keyAgreementAlgorithm, (Object)CredentialSupport.extractEncryptionKey((Credential)keyTransportCredential).getAlgorithm());
        }
        if (keyAgreementAlgorithm == null) {
            List<String> keyAgreementAlgorithms = this.realSuper.getEffectiveKeyAgreementMethods(criteria, whitelistBlacklistPredicate);
            if (keyAgreementAlgorithms.isEmpty()) {
                this.log.debug("No key agreement algorithms found in local configuration");
                return null;
            }
            this.log.debug("Key agreement algorithm(s) {} resolved from local configuration, using '{}'", keyAgreementAlgorithms, (Object)keyAgreementAlgorithms.get(0));
            keyAgreementAlgorithm = keyAgreementAlgorithms.get(0);
        }
        if (keyDerivationMethod == null) {
            List<String> keyDerivationMethods = this.realSuper.getEffectiveKeyDerivationAlgorithms(criteria, whitelistBlacklistPredicate);
            if (keyDerivationMethods.isEmpty()) {
                this.log.debug("No key derivation methods found in local configuration");
                return null;
            }
            this.log.debug("Key derivation method(s) {} resolved from local configuration, using '{}'", keyDerivationMethods, (Object)keyDerivationMethods.get(0));
            keyDerivationMethod = (KeyDerivationMethod)XMLObjectSupport.buildXMLObject((QName)KeyDerivationMethod.DEFAULT_ELEMENT_NAME);
            keyDerivationMethod.setAlgorithm(keyDerivationMethods.get(0));
        }
        if ("http://www.w3.org/2009/xmlenc11#ConcatKDF".equals(keyDerivationMethod.getAlgorithm()) && keyDerivationMethod.getUnknownXMLObjects(ConcatKDFParams.DEFAULT_ELEMENT_NAME).isEmpty()) {
            ConcatKDFParameters concatKDFParameters = this.realSuper.getConcatKDFParameters(criteria, whitelistBlacklistPredicate);
            if (concatKDFParameters == null) {
                this.log.info("Could not get ConcatKDFParams for '{}' from local configuration", (Object)"http://www.w3.org/2009/xmlenc11#ConcatKDF");
                return null;
            }
            keyDerivationMethod.getUnknownXMLObjects().add(concatKDFParameters.toXMLObject());
        }
        return new Pair(keyAgreementAlgorithm, (Object)keyDerivationMethod);
    }

    @Nullable
    protected KeyInfoGenerator resolveKeyTransportKeyInfoGenerator(@Nonnull CriteriaSet criteria, @Nullable Credential keyTransportEncryptionCredential) {
        return this.realSuper.resolveKeyTransportKeyInfoGenerator(criteria, keyTransportEncryptionCredential);
    }

    public void setAlgorithmRegistry(AlgorithmRegistry registry) {
        super.setAlgorithmRegistry(registry);
        this.realSuper.setAlgorithmRegistry(registry);
    }

    public void setAutoGenerateDataEncryptionCredential(boolean flag) {
        super.setAutoGenerateDataEncryptionCredential(flag);
        this.realSuper.setAutoGenerateDataEncryptionCredential(flag);
    }

    public void setUseKeyAgreementDefaults(boolean flag) {
        this.realSuper.setUseKeyAgreementDefaults(flag);
    }

    private static class ResolvedKeyTransport {
        private String algorithm;
        private EncryptionMethod encryptionMethod;
        private Credential credential;

        public ResolvedKeyTransport() {
        }

        public ResolvedKeyTransport(String algorithm, EncryptionMethod encryptionMethod, Credential credential) {
            this.algorithm = algorithm;
            this.encryptionMethod = encryptionMethod;
            this.credential = credential;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public EncryptionMethod getEncryptionMethod() {
            return this.encryptionMethod;
        }

        public Credential getCredential() {
            return this.credential;
        }
    }
}

