/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.opensaml.xmlsec;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.KeyTransportAlgorithmPredicate;
import org.opensaml.xmlsec.algorithm.AlgorithmDescriptor;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.opensaml.xmlsec.criterion.EncryptionConfigurationCriterion;
import org.opensaml.xmlsec.criterion.KeyInfoGenerationProfileCriterion;
import org.opensaml.xmlsec.impl.BasicEncryptionParametersResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.swedenconnect.opensaml.security.credential.KeyAgreementCredential;
import se.swedenconnect.opensaml.xmlsec.BasicExtendedEncryptionConfiguration;
import se.swedenconnect.opensaml.xmlsec.ExtendedEncryptionConfiguration;
import se.swedenconnect.opensaml.xmlsec.algorithm.ExtendedAlgorithmSupport;
import se.swedenconnect.opensaml.xmlsec.config.ExtendedDefaultSecurityConfigurationBootstrap;
import se.swedenconnect.opensaml.xmlsec.encryption.KeyDerivationMethod;
import se.swedenconnect.opensaml.xmlsec.encryption.support.ConcatKDFParameters;
import se.swedenconnect.opensaml.xmlsec.encryption.support.ECDHSupport;

public class ExtendedEncryptionParametersResolver
extends BasicEncryptionParametersResolver {
    private Logger log = LoggerFactory.getLogger(ExtendedEncryptionParametersResolver.class);
    private boolean useKeyAgreementDefaults = false;
    private BasicExtendedEncryptionConfiguration defaultEncryptionConfiguration;

    protected void resolveAndPopulateCredentialsAndAlgorithms(@Nonnull EncryptionParameters params, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> whitelistBlacklistPredicate) {
        List<String> keyDerivationAlgorithms;
        List keyTransportCredentials = this.getEffectiveKeyTransportCredentials(criteria);
        List keyTransportAlgorithms = this.getEffectiveKeyTransportAlgorithms(criteria, whitelistBlacklistPredicate);
        this.log.trace("Resolved effective key transport algorithms: {}", (Object)keyTransportAlgorithms);
        keyTransportCredentials.addAll(0, this.getEffectivePeerKeyAgreementCredentials(criteria));
        List keyWrappingAlgorithms = keyTransportAlgorithms.stream().map(arg_0 -> ((AlgorithmRegistry)this.getAlgorithmRegistry()).get(arg_0)).filter(ExtendedAlgorithmSupport::isKeyWrappingAlgorithm).map(AlgorithmDescriptor::getURI).collect(Collectors.toList());
        this.log.trace("Resolved effective key wrapping algorithms: {}", keyWrappingAlgorithms);
        List dataEncryptionCredentials = this.getEffectiveDataEncryptionCredentials(criteria);
        List dataEncryptionAlgorithms = this.getEffectiveDataEncryptionAlgorithms(criteria, whitelistBlacklistPredicate);
        this.log.trace("Resolved effective data encryption algorithms: {}", (Object)dataEncryptionAlgorithms);
        if (dataEncryptionCredentials.isEmpty()) {
            params.setDataEncryptionAlgorithm(this.resolveDataEncryptionAlgorithm(null, dataEncryptionAlgorithms));
        } else {
            for (Credential dataEncryptionCredential : dataEncryptionCredentials) {
                String dataEncryptionAlgorithm = this.resolveDataEncryptionAlgorithm(dataEncryptionCredential, dataEncryptionAlgorithms);
                if (dataEncryptionAlgorithm != null) {
                    params.setDataEncryptionCredential(dataEncryptionCredential);
                    params.setDataEncryptionAlgorithm(dataEncryptionAlgorithm);
                    break;
                }
                this.log.debug("Unable to resolve data encryption algorithm for credential with key type '{}', considering other credentials", (Object)CredentialSupport.extractEncryptionKey((Credential)dataEncryptionCredential).getAlgorithm());
            }
        }
        List<String> keyAgreementMethods = this.getEffectiveKeyAgreementMethods(criteria, whitelistBlacklistPredicate);
        if (keyAgreementMethods.isEmpty()) {
            this.log.debug("No key agreement methods found in configuration ...");
        }
        if ((keyDerivationAlgorithms = this.getEffectiveKeyDerivationAlgorithms(criteria, whitelistBlacklistPredicate)).isEmpty()) {
            this.log.debug("No key derivation algorithms found in configuration ...");
        }
        ConcatKDFParameters concatKDFParameters = keyDerivationAlgorithms.contains("http://www.w3.org/2009/xmlenc11#ConcatKDF") ? this.getConcatKDFParameters(criteria, whitelistBlacklistPredicate) : null;
        KeyTransportAlgorithmPredicate keyTransportPredicate = this.resolveKeyTransportAlgorithmPredicate(criteria);
        for (Credential keyTransportCredential : keyTransportCredentials) {
            String keyTransportAlgorithm = this.resolveKeyTransportAlgorithm(keyTransportCredential, keyTransportAlgorithms, params.getDataEncryptionAlgorithm(), keyTransportPredicate);
            if (keyTransportAlgorithm != null) {
                params.setKeyTransportEncryptionCredential(keyTransportCredential);
                params.setKeyTransportEncryptionAlgorithm(keyTransportAlgorithm);
                this.resolveAndPopulateRSAOAEPParams(params, criteria, whitelistBlacklistPredicate);
                break;
            }
            if (ExtendedAlgorithmSupport.peerCredentialSupportsKeyAgreement(keyTransportCredential) && !keyAgreementMethods.isEmpty() && !keyDerivationAlgorithms.isEmpty()) {
                for (String keyWrappingAlgo : keyWrappingAlgorithms) {
                    try {
                        Credential keyAgreementCredential = this.generateKeyAgreementCredential(keyTransportCredential, keyWrappingAlgo, keyAgreementMethods, keyDerivationAlgorithms, concatKDFParameters);
                        params.setKeyTransportEncryptionCredential(keyAgreementCredential);
                        params.setKeyTransportEncryptionAlgorithm(keyWrappingAlgo);
                        break;
                    }
                    catch (SecurityException e) {
                        this.log.error("Failed to create key agreement credential using {} key wrapping - {}", new Object[]{keyWrappingAlgo, e.getMessage(), e});
                    }
                }
                if (params.getKeyTransportEncryptionAlgorithm() == null) continue;
                break;
            }
            this.log.debug("Unable to resolve key transport algorithm for credential with key type '{}', considering other credentials", (Object)CredentialSupport.extractEncryptionKey((Credential)keyTransportCredential).getAlgorithm());
        }
        this.processDataEncryptionCredentialAutoGeneration(params);
    }

    protected Credential generateKeyAgreementCredential(@Nonnull Credential credential, @Nonnull String keyWrappingAlgorithm, @Nonnull List<String> keyAgreementMethods, @Nonnull List<String> keyDerivationAlgorithms, ConcatKDFParameters concatKDFParameters) throws SecurityException {
        if (!keyAgreementMethods.contains("http://www.w3.org/2009/xmlenc11#ECDH-ES")) {
            this.log.info("{} not among configured key agreement methods - it's the only supported key agreement method at the moment", (Object)"http://www.w3.org/2009/xmlenc11#ECDH-ES");
            return null;
        }
        if (!keyDerivationAlgorithms.contains("http://www.w3.org/2009/xmlenc11#ConcatKDF")) {
            this.log.info("{} not among configured key derivation algorithms - it's the only supported algorithm at the moment", (Object)"http://www.w3.org/2009/xmlenc11#ConcatKDF");
            return null;
        }
        if (concatKDFParameters == null) {
            this.log.debug("No ConcatKDFPars found in configuration, using default parameters ...");
            concatKDFParameters = this.getDefaultEncryptionConfiguration().getConcatKDFParameters();
        }
        KeyDerivationMethod keyDerivationMethod = (KeyDerivationMethod)XMLObjectSupport.buildXMLObject((QName)KeyDerivationMethod.DEFAULT_ELEMENT_NAME);
        keyDerivationMethod.setAlgorithm("http://www.w3.org/2009/xmlenc11#ConcatKDF");
        keyDerivationMethod.getUnknownXMLObjects().add(concatKDFParameters.toXMLObject());
        return ECDHSupport.createKeyAgreementCredential(credential, keyWrappingAlgorithm, keyDerivationMethod);
    }

    @Nonnull
    protected List<String> getEffectiveKeyAgreementMethods(@Nonnull CriteriaSet criteria, @Nonnull Predicate<String> whitelistBlacklistPredicate) {
        ArrayList<String> methods = new ArrayList<String>();
        List<ExtendedEncryptionConfiguration> cfgList = this.getExtendedConfiguration(criteria);
        if (cfgList.isEmpty()) {
            if (this.useKeyAgreementDefaults) {
                methods.addAll(this.getDefaultEncryptionConfiguration().getAgreementMethodAlgorithms());
                this.log.debug("Assuming default key agreement methods: {}", methods);
            } else {
                this.log.debug("useDefaultKeyAgreementMethods is not set and criteria contains no ExtendedEncryptionConfiguration - No key agreement methods can be found");
            }
            return methods;
        }
        cfgList.stream().map(c -> Collections2.filter(c.getAgreementMethodAlgorithms(), (Predicate)Predicates.and((Predicate)this.getAlgorithmRuntimeSupportedPredicate(), (Predicate)whitelistBlacklistPredicate))).forEach(methods::addAll);
        return methods;
    }

    @Nonnull
    protected List<String> getEffectiveKeyDerivationAlgorithms(@Nonnull CriteriaSet criteria, @Nonnull Predicate<String> whitelistBlacklistPredicate) {
        ArrayList<String> algos = new ArrayList<String>();
        List<ExtendedEncryptionConfiguration> cfgList = this.getExtendedConfiguration(criteria);
        if (cfgList.isEmpty()) {
            if (this.useKeyAgreementDefaults) {
                algos.addAll(this.getDefaultEncryptionConfiguration().getKeyDerivationAlgorithms());
                this.log.debug("Assuming default key derivation algorithms: {}", algos);
            } else {
                this.log.debug("useDefaultKeyAgreementMethods is not set and criteria contains no ExtendedEncryptionConfiguration - No key derivation methods can be found");
            }
            return algos;
        }
        cfgList.stream().map(ExtendedEncryptionConfiguration::getKeyDerivationAlgorithms).forEach(algos::addAll);
        return algos;
    }

    @Nonnull
    protected ConcatKDFParameters getConcatKDFParameters(@Nonnull CriteriaSet criteria, @Nonnull Predicate<String> whitelistBlacklistPredicate) {
        List<ExtendedEncryptionConfiguration> cfgList = this.getExtendedConfiguration(criteria);
        if (!cfgList.isEmpty()) {
            for (ExtendedEncryptionConfiguration config : cfgList) {
                ConcatKDFParameters pars = config.getConcatKDFParameters();
                if (!whitelistBlacklistPredicate.apply((Object)pars.getDigestMethod())) {
                    this.log.debug("ConcatKDFParams found in criteria states digest method '{}' - this is not valid according to white/black list", (Object)pars.getDigestMethod());
                    continue;
                }
                return pars;
            }
        } else if (this.useKeyAgreementDefaults) {
            return this.getDefaultEncryptionConfiguration().getConcatKDFParameters();
        }
        return null;
    }

    @Nonnull
    protected List<Credential> getEffectivePeerKeyAgreementCredentials(@Nonnull CriteriaSet criteria) {
        ArrayList<Credential> credentials = new ArrayList<Credential>();
        List<ExtendedEncryptionConfiguration> extCfg = this.getExtendedConfiguration(criteria);
        extCfg.stream().map(ExtendedEncryptionConfiguration::getKeyAgreementCredentials).forEach(credentials::addAll);
        return credentials;
    }

    private List<ExtendedEncryptionConfiguration> getExtendedConfiguration(@Nonnull CriteriaSet criteria) {
        EncryptionConfigurationCriterion encryptionConfigurationCriterion = (EncryptionConfigurationCriterion)criteria.get(EncryptionConfigurationCriterion.class);
        if (encryptionConfigurationCriterion == null) {
            this.log.debug("No EncryptionConfigurationCriterion available");
            return Collections.emptyList();
        }
        return encryptionConfigurationCriterion.getConfigurations().stream().filter(ExtendedEncryptionConfiguration.class::isInstance).map(ExtendedEncryptionConfiguration.class::cast).collect(Collectors.toList());
    }

    @Nullable
    protected KeyInfoGenerator resolveKeyTransportKeyInfoGenerator(@Nonnull CriteriaSet criteria, @Nullable Credential keyTransportEncryptionCredential) {
        KeyInfoGenerator keyInfoGenerator = super.resolveKeyTransportKeyInfoGenerator(criteria, keyTransportEncryptionCredential);
        if (keyInfoGenerator == null && KeyAgreementCredential.class.isInstance(keyTransportEncryptionCredential)) {
            String name = criteria.get(KeyInfoGenerationProfileCriterion.class) != null ? ((KeyInfoGenerationProfileCriterion)criteria.get(KeyInfoGenerationProfileCriterion.class)).getName() : null;
            keyInfoGenerator = this.lookupKeyInfoGenerator(keyTransportEncryptionCredential, ExtendedDefaultSecurityConfigurationBootstrap.buildBasicKeyInfoGeneratorManager(), name);
        }
        return keyInfoGenerator;
    }

    public void setUseKeyAgreementDefaults(boolean flag) {
        this.useKeyAgreementDefaults = flag;
    }

    protected void logResult(EncryptionParameters params) {
        if (this.log.isDebugEnabled()) {
            if (KeyAgreementCredential.class.isInstance(params.getKeyTransportEncryptionCredential())) {
                this.log.debug("Resolved EncryptionParameters:");
                KeyAgreementCredential kaCred = (KeyAgreementCredential)((Object)KeyAgreementCredential.class.cast(params.getKeyTransportEncryptionCredential()));
                this.log.debug("\tKey agreement algorithm: {}", (Object)kaCred.getAgreementMethodAlgorithm());
                this.log.debug("\tKey derivation method: {}", (Object)(kaCred.getKeyDerivationMethod() != null ? kaCred.getKeyDerivationMethod().getAlgorithm() : "null"));
                this.log.debug("\tPeer credential with key algorithm: {}", (Object)CredentialSupport.extractEncryptionKey((Credential)kaCred.getPeerCredential()).getAlgorithm());
                this.log.debug("\tKey wrapping algorithm: {}", (Object)params.getKeyTransportEncryptionAlgorithm());
                this.log.debug("\tKey transport KeyInfoGenerator: {}", (Object)(params.getKeyTransportKeyInfoGenerator() != null ? "present" : "null"));
                Key dataKey = CredentialSupport.extractEncryptionKey((Credential)params.getDataEncryptionCredential());
                if (dataKey != null) {
                    this.log.debug("\tData encryption credential with key algorithm: {}", (Object)dataKey.getAlgorithm());
                } else {
                    this.log.debug("\tData encryption credential: null");
                }
                this.log.debug("\tData encryption algorithm URI: {}", (Object)params.getDataEncryptionAlgorithm());
                this.log.debug("\tData encryption KeyInfoGenerator: {}", (Object)(params.getDataKeyInfoGenerator() != null ? "present" : "null"));
            } else {
                super.logResult(params);
            }
        }
    }

    private BasicExtendedEncryptionConfiguration getDefaultEncryptionConfiguration() {
        if (this.defaultEncryptionConfiguration == null) {
            this.defaultEncryptionConfiguration = ExtendedDefaultSecurityConfigurationBootstrap.buildDefaultEncryptionConfiguration((EncryptionConfiguration)ConfigurationService.get(EncryptionConfiguration.class));
        }
        return this.defaultEncryptionConfiguration;
    }
}

