/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.opensaml.xmlsec;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.impl.BasicEncryptionConfiguration;
import se.swedenconnect.opensaml.xmlsec.ExtendedEncryptionConfiguration;
import se.swedenconnect.opensaml.xmlsec.encryption.support.ConcatKDFParameters;

public class BasicExtendedEncryptionConfiguration
extends BasicEncryptionConfiguration
implements ExtendedEncryptionConfiguration {
    @Nonnull
    @NonnullElements
    private List<Credential> keyAgreementCredentials = Collections.emptyList();
    @Nonnull
    @NonnullElements
    private List<String> agreementMethodAlgorithms = Collections.emptyList();
    @Nonnull
    @NonnullElements
    private List<String> keyDerivationAlgorithms = Collections.emptyList();
    @Nullable
    private ConcatKDFParameters concatKDFParameters;

    @Override
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<Credential> getKeyAgreementCredentials() {
        return ImmutableList.copyOf(this.keyAgreementCredentials);
    }

    public void setKeyAgreementCredentials(@Nullable List<Credential> keyAgreementCredentials) {
        if (keyAgreementCredentials == null) {
            this.keyAgreementCredentials = Collections.emptyList();
            return;
        }
        this.keyAgreementCredentials = new ArrayList<Credential>(Collections2.filter(keyAgreementCredentials, (Predicate)Predicates.notNull()));
    }

    @Override
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<String> getAgreementMethodAlgorithms() {
        return ImmutableList.copyOf(this.agreementMethodAlgorithms);
    }

    public void setAgreementMethodAlgorithms(@Nullable List<String> algorithms) {
        if (algorithms == null) {
            this.agreementMethodAlgorithms = Collections.emptyList();
            return;
        }
        this.agreementMethodAlgorithms = new ArrayList<String>(StringSupport.normalizeStringCollection(algorithms));
    }

    @Override
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<String> getKeyDerivationAlgorithms() {
        return ImmutableList.copyOf(this.keyDerivationAlgorithms);
    }

    public void setKeyDerivationAlgorithms(@Nullable List<String> algorithms) {
        if (algorithms == null) {
            this.keyDerivationAlgorithms = Collections.emptyList();
            return;
        }
        this.keyDerivationAlgorithms = new ArrayList<String>(StringSupport.normalizeStringCollection(algorithms));
    }

    @Override
    @Nullable
    public ConcatKDFParameters getConcatKDFParameters() {
        return this.concatKDFParameters;
    }

    public void setConcatKDFParameters(@Nullable ConcatKDFParameters concatKDFParameters) {
        this.concatKDFParameters = concatKDFParameters;
    }
}

